/**
 */
package activity.impl;

import activity.ActivityPackage;
import activity.ProductChange;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import product.IProductDefinition;
import product.Property;
import product.TransferType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Product Change</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link activity.impl.ProductChangeImpl#getStartProperties <em>Start Properties</em>}</li>
 *   <li>{@link activity.impl.ProductChangeImpl#getEndProperties <em>End Properties</em>}</li>
 *   <li>{@link activity.impl.ProductChangeImpl#getSlot <em>Slot</em>}</li>
 *   <li>{@link activity.impl.ProductChangeImpl#getProduct <em>Product</em>}</li>
 *   <li>{@link activity.impl.ProductChangeImpl#getTransferType <em>Transfer Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProductChangeImpl extends MinimalEObjectImpl.Container implements ProductChange
{
    /**
     * The cached value of the '{@link #getStartProperties() <em>Start Properties</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getStartProperties()
     * @generated
     * @ordered
     */
    protected EList<Property> startProperties;

    /**
     * The cached value of the '{@link #getEndProperties() <em>End Properties</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getEndProperties()
     * @generated
     * @ordered
     */
    protected EList<Property> endProperties;

    /**
     * The default value of the '{@link #getSlot() <em>Slot</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSlot()
     * @generated
     * @ordered
     */
    protected static final String SLOT_EDEFAULT = "";

    /**
     * The cached value of the '{@link #getSlot() <em>Slot</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSlot()
     * @generated
     * @ordered
     */
    protected String slot = SLOT_EDEFAULT;

    /**
     * The cached value of the '{@link #getProduct() <em>Product</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProduct()
     * @generated
     * @ordered
     */
    protected IProductDefinition product;

    /**
     * The default value of the '{@link #getTransferType() <em>Transfer Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTransferType()
     * @generated
     * @ordered
     */
    protected static final TransferType TRANSFER_TYPE_EDEFAULT = TransferType.UNKNOWN;

    /**
     * The cached value of the '{@link #getTransferType() <em>Transfer Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTransferType()
     * @generated
     * @ordered
     */
    protected TransferType transferType = TRANSFER_TYPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProductChangeImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return ActivityPackage.Literals.PRODUCT_CHANGE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<Property> getStartProperties()
    {
        if (startProperties == null)
        {
            startProperties = new EObjectContainmentEList<Property>(Property.class, this, ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES);
        }
        return startProperties;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<Property> getEndProperties()
    {
        if (endProperties == null)
        {
            endProperties = new EObjectContainmentEList<Property>(Property.class, this, ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES);
        }
        return endProperties;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String getSlot()
    {
        return slot;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setSlot(String newSlot)
    {
        String oldSlot = slot;
        slot = newSlot;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.PRODUCT_CHANGE__SLOT, oldSlot, slot));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public IProductDefinition getProduct()
    {
        if (product != null && product.eIsProxy())
        {
            InternalEObject oldProduct = (InternalEObject)product;
            product = (IProductDefinition)eResolveProxy(oldProduct);
            if (product != oldProduct)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ActivityPackage.PRODUCT_CHANGE__PRODUCT, oldProduct, product));
            }
        }
        return product;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public IProductDefinition basicGetProduct()
    {
        return product;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setProduct(IProductDefinition newProduct)
    {
        IProductDefinition oldProduct = product;
        product = newProduct;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.PRODUCT_CHANGE__PRODUCT, oldProduct, product));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public TransferType getTransferType()
    {
        return transferType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setTransferType(TransferType newTransferType)
    {
        TransferType oldTransferType = transferType;
        transferType = newTransferType == null ? TRANSFER_TYPE_EDEFAULT : newTransferType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.PRODUCT_CHANGE__TRANSFER_TYPE, oldTransferType, transferType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES:
                return ((InternalEList<?>)getStartProperties()).basicRemove(otherEnd, msgs);
            case ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES:
                return ((InternalEList<?>)getEndProperties()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES:
                return getStartProperties();
            case ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES:
                return getEndProperties();
            case ActivityPackage.PRODUCT_CHANGE__SLOT:
                return getSlot();
            case ActivityPackage.PRODUCT_CHANGE__PRODUCT:
                if (resolve) return getProduct();
                return basicGetProduct();
            case ActivityPackage.PRODUCT_CHANGE__TRANSFER_TYPE:
                return getTransferType();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES:
                getStartProperties().clear();
                getStartProperties().addAll((Collection<? extends Property>)newValue);
                return;
            case ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES:
                getEndProperties().clear();
                getEndProperties().addAll((Collection<? extends Property>)newValue);
                return;
            case ActivityPackage.PRODUCT_CHANGE__SLOT:
                setSlot((String)newValue);
                return;
            case ActivityPackage.PRODUCT_CHANGE__PRODUCT:
                setProduct((IProductDefinition)newValue);
                return;
            case ActivityPackage.PRODUCT_CHANGE__TRANSFER_TYPE:
                setTransferType((TransferType)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES:
                getStartProperties().clear();
                return;
            case ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES:
                getEndProperties().clear();
                return;
            case ActivityPackage.PRODUCT_CHANGE__SLOT:
                setSlot(SLOT_EDEFAULT);
                return;
            case ActivityPackage.PRODUCT_CHANGE__PRODUCT:
                setProduct((IProductDefinition)null);
                return;
            case ActivityPackage.PRODUCT_CHANGE__TRANSFER_TYPE:
                setTransferType(TRANSFER_TYPE_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.PRODUCT_CHANGE__START_PROPERTIES:
                return startProperties != null && !startProperties.isEmpty();
            case ActivityPackage.PRODUCT_CHANGE__END_PROPERTIES:
                return endProperties != null && !endProperties.isEmpty();
            case ActivityPackage.PRODUCT_CHANGE__SLOT:
                return SLOT_EDEFAULT == null ? slot != null : !SLOT_EDEFAULT.equals(slot);
            case ActivityPackage.PRODUCT_CHANGE__PRODUCT:
                return product != null;
            case ActivityPackage.PRODUCT_CHANGE__TRANSFER_TYPE:
                return transferType != TRANSFER_TYPE_EDEFAULT;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (slot: ");
        result.append(slot);
        result.append(", transferType: ");
        result.append(transferType);
        result.append(')');
        return result.toString();
    }

} //ProductChangeImpl
