/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.callgraph.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StapGraphParser
extends SystemTapParser {
    public Map<Integer, Long> timeMap;
    public Map<Integer, String> serialMap;
    public Map<Integer, HashMap<Integer, ArrayList<Integer>>> neighbourMaps;
    public Map<String, Long> aggregateTimeMap;
    public Map<String, Integer> countMap;
    public List<Integer> callOrderList;
    public Map<Integer, String> markedMap;
    public Long endingTimeInNS;
    public long totalTime;
    public Map<Integer, Integer> lastFunctionMap;
    public ICProject project;
    private static final String DELIM = ",,";
    private boolean encounteredMain = false;
    private List<Integer> shouldGetEndingTimeForID = new ArrayList<Integer>();
    private Map<Integer, List<String>> nameMaps;
    private Map<Integer, List<Integer>> idMaps;
    private boolean skippedDirectives = false;
    private int firstNode = -1;
    public long startTime = -1L;

    protected void initialize() {
        this.neighbourMaps = new HashMap<Integer, HashMap<Integer, ArrayList<Integer>>>();
        this.timeMap = new HashMap<Integer, Long>();
        this.serialMap = new TreeMap<Integer, String>();
        this.aggregateTimeMap = new HashMap<String, Long>();
        this.countMap = new HashMap<String, Integer>();
        this.endingTimeInNS = 0L;
        this.callOrderList = new ArrayList<Integer>();
        this.markedMap = new HashMap<Integer, String>();
        this.lastFunctionMap = new HashMap<Integer, Integer>();
        this.nameMaps = new HashMap<Integer, List<String>>();
        this.idMaps = new HashMap<Integer, List<Integer>>();
        this.project = null;
        this.startTime = -1L;
    }

    public IStatus nonRealTimeParsing() {
        this.neighbourMaps.clear();
        this.timeMap.clear();
        this.serialMap.clear();
        this.aggregateTimeMap.clear();
        this.countMap.clear();
        this.callOrderList.clear();
        this.shouldGetEndingTimeForID.clear();
        this.nameMaps.clear();
        this.idMaps.clear();
        this.encounteredMain = false;
        this.skippedDirectives = false;
        this.firstNode = -1;
        this.startTime = -1L;
        BufferedReader buff = null;
        try {
            buff = new BufferedReader(new FileReader(this.sourcePath));
        }
        catch (FileNotFoundException e1) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("StapGraphParser.FileNotFound"), (String)(Messages.getString("StapGraphParser.CouldNotOpen") + this.sourcePath)));
            return Status.CANCEL_STATUS;
        }
        this.internalData = buff;
        return this.realTimeParsing();
    }

    private void parseEnd() {
        boolean timeCheck;
        for (Map.Entry<Integer, List<Integer>> entry : this.idMaps.entrySet()) {
            List<Integer> idList = entry.getValue();
            int lastFunctionCalled = this.lastFunctionMap.get(entry.getKey());
            if (idList.size() <= 1) continue;
            for (int val : idList) {
                String name = this.serialMap.get(val);
                long time = this.endingTimeInNS - this.timeMap.get(val);
                this.timeMap.put(val, time);
                if (val == this.firstNode) {
                    this.showTime(val, time);
                }
                if (this.shouldGetEndingTimeForID.contains(val)) {
                    long cumulativeTime = this.aggregateTimeMap.get(name) + this.endingTimeInNS;
                    this.aggregateTimeMap.put(name, cumulativeTime);
                }
                lastFunctionCalled = val;
            }
            String tmp = this.markedMap.get(lastFunctionCalled);
            if (tmp == null) {
                tmp = "";
            }
            this.markedMap.put(lastFunctionCalled, tmp + "\n" + Messages.getString("StapGraphParser.Term"));
        }
        boolean bl = timeCheck = this.totalTime < 50000000L && ((double)((float)this.timeMap.get(this.firstNode).longValue() / (float)this.totalTime) > 1.01 || (double)((float)this.timeMap.get(this.firstNode).longValue() / (float)this.totalTime) < 0.99);
        if (this.skippedDirectives || timeCheck) {
            this.totalTime = this.timeMap.get(this.firstNode);
            Object markedMessage = "";
            if (this.markedMap.containsKey(this.firstNode)) {
                markedMessage = this.markedMap.get(this.firstNode) + "\n";
            }
            if (this.skippedDirectives) {
                markedMessage = (String)markedMessage + Messages.getString("StapGraphParser.CDirectives");
            }
            if (timeCheck) {
                markedMessage = (String)markedMessage + Messages.getString("StapGraphParser.TooFast");
            }
            markedMessage = (String)markedMessage + Messages.getString("StapGraphParser.TimeForThisNode");
            this.markedMap.put(this.firstNode, (String)markedMessage);
        }
    }

    private void parseMarked(String msg) {
        String[] parsed = msg.split(DELIM, 2);
        int key = Integer.parseInt(parsed[0]);
        List<Integer> idList = this.idMaps.get(key);
        if (idList == null || msg.length() < 1 || idList.size() < 1) {
            return;
        }
        int id = idList.get(idList.size() - 1);
        if (parsed[1].equals("<unknown>")) {
            parsed[1] = parsed[1] + Messages.getString("StapGraphParser.UnknownMarkers");
        }
        this.markedMap.put(id, (this.markedMap.get(id) == null ? "" : this.markedMap.get(id)) + parsed[1]);
    }

    private IStatus parse(String s) {
        try {
            if (s.length() < 1) {
                return Status.OK_STATUS;
            }
            switch (s.charAt(0)) {
                case '<': {
                    HashMap<Integer, ArrayList<Integer>> outNeighbours;
                    List<Integer> idList;
                    String[] args = s.substring(1, s.length()).split(DELIM);
                    int id = Integer.parseInt(args[1]);
                    long time = Long.parseLong(args[2]);
                    int tid = Integer.parseInt(args[3]);
                    String name = args[0];
                    if (!this.encounteredMain && !this.isFunctionNameClean(name) && name.contains("__")) {
                        this.skippedDirectives = true;
                        break;
                    }
                    List<String> nameList = this.nameMaps.get(tid);
                    if (nameList == null) {
                        nameList = new ArrayList<String>();
                    }
                    if ((idList = this.idMaps.get(tid)) == null) {
                        idList = new ArrayList<Integer>();
                    }
                    if ((outNeighbours = this.neighbourMaps.get(tid)) == null) {
                        outNeighbours = new HashMap();
                    }
                    if (this.startTime < 1L) {
                        this.startTime = time;
                    }
                    this.endingTimeInNS = time;
                    if ((name = this.cleanFunctionName(name)).equals("main")) {
                        this.encounteredMain = true;
                    }
                    if (this.firstNode == -1) {
                        this.firstNode = id;
                    }
                    this.serialMap.put(id, name);
                    this.timeMap.put(id, time);
                    if (this.aggregateTimeMap.get(name) == null) {
                        this.aggregateTimeMap.put(name, 0L);
                    }
                    if (nameList.indexOf(name) == -1) {
                        long cumulativeTime = this.aggregateTimeMap.get(name) - time;
                        this.aggregateTimeMap.put(name, cumulativeTime);
                        this.shouldGetEndingTimeForID.add(id);
                    }
                    if (this.countMap.get(name) == null) {
                        this.countMap.put(name, 0);
                    }
                    this.countMap.put(name, this.countMap.get(name) + 1);
                    nameList.add(name);
                    idList.add(id);
                    if (outNeighbours.get(id) == null) {
                        outNeighbours.put(id, new ArrayList());
                    }
                    if (idList.size() > 1) {
                        int parentID = idList.get(idList.size() - 2);
                        outNeighbours.get(parentID).add(id);
                    }
                    this.callOrderList.add(id);
                    this.lastFunctionMap.put(tid, id);
                    this.neighbourMaps.put(tid, outNeighbours);
                    this.nameMaps.put(tid, nameList);
                    this.idMaps.put(tid, idList);
                    break;
                }
                case '>': {
                    List<Integer> idList;
                    String[] args = s.substring(1, s.length()).split(DELIM);
                    String name = args[0];
                    int tid = Integer.parseInt(args[2]);
                    List<String> nameList = this.nameMaps.get(tid);
                    if (nameList == null) {
                        nameList = new ArrayList<String>();
                    }
                    if ((idList = this.idMaps.get(tid)) == null) {
                        idList = new ArrayList<Integer>();
                    }
                    if (!this.encounteredMain && !this.isFunctionNameClean(name) && name.contains("__")) {
                        this.skippedDirectives = true;
                        break;
                    }
                    int lastOccurance = nameList.lastIndexOf(name = this.cleanFunctionName(name));
                    if (lastOccurance < 0) {
                        this.parsingError(Messages.getString("StapGraphParser.RetMismatch") + name);
                        return Status.CANCEL_STATUS;
                    }
                    nameList.remove(lastOccurance);
                    int id = idList.remove(lastOccurance);
                    if (this.timeMap.get(id) == null) {
                        this.parsingError(Messages.getString("StapGraphParser.NoStartTime") + name);
                        return Status.CANCEL_STATUS;
                    }
                    this.endingTimeInNS = Long.parseLong(args[1]);
                    long time = this.endingTimeInNS - this.timeMap.get(id);
                    this.timeMap.put(id, time);
                    if (id == this.firstNode) {
                        this.showTime(id, time);
                    }
                    if (this.shouldGetEndingTimeForID.contains(id)) {
                        long cumulativeTime = this.aggregateTimeMap.get(name) + Long.parseLong(args[1]);
                        this.aggregateTimeMap.put(name, cumulativeTime);
                    }
                    this.nameMaps.put(tid, nameList);
                    this.idMaps.put(tid, idList);
                    break;
                }
                default: {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        catch (NumberFormatException e) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("StapGraphParser.BadSymbol"), Messages.getString("StapGraphParser.BadSymbol"), Messages.getString("StapGraphParser.BadSymbolMsg1") + Messages.getString("StapGraphParser.BadSymbolMsg2"));
            mess.schedule();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus parseDotFile() {
        BufferedReader buff = this.internalData;
        HashMap outNeighbours = new HashMap();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        this.endingTimeInNS = 0L;
        this.totalTime = 10000L;
        try {
            String line;
            while ((line = buff.readLine()) != null && !line.equals("}")) {
                if (this.monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (line.length() < 1) continue;
                String[] args = line.split(" ", 2);
                if (args[0].contains("->")) {
                    int[] ids = new int[2];
                    int called = 1;
                    try {
                        ids[0] = Integer.parseInt(args[0].split("->")[0]);
                        ids[1] = Integer.parseInt(args[0].split("->")[1]);
                        int index1 = args[1].indexOf("=\"");
                        int index2 = args[1].indexOf("\"]");
                        called = Integer.parseInt(args[1].substring(index1 + 2, index2));
                    }
                    catch (NumberFormatException e) {
                        SystemTapUIErrorMessages m = new SystemTapUIErrorMessages(Messages.getString("StapGraphParser.idOrLabel"), Messages.getString("StapGraphParser.idOrLabel"), Messages.getString("StapGraphParser.nonNumericLabel"));
                        m.schedule();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        try {
                            buff.close();
                            return iStatus;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return iStatus;
                    }
                    ArrayList<Integer> tmpList = (ArrayList<Integer>)outNeighbours.get(ids[0]);
                    if (tmpList == null) {
                        tmpList = new ArrayList<Integer>();
                    }
                    for (int i = 0; i < called; ++i) {
                        tmpList.add(ids[1]);
                    }
                    outNeighbours.put(ids[0], tmpList);
                    continue;
                }
                try {
                    int id = Integer.parseInt(args[0]);
                    if (this.firstNode == -1) {
                        this.firstNode = id;
                    }
                    int index = args[1].indexOf("=\"");
                    String name = args[1].substring(index + 2, args[1].indexOf(32, index));
                    double dtime = 0.0;
                    dtime = Double.parseDouble(args[1].substring(args[1].indexOf(32) + 1, args[1].indexOf(37)));
                    long time = (long)(dtime * 100.0);
                    nameList.add(name);
                    idList.add(id);
                    this.timeMap.put(id, time);
                    this.serialMap.put(id, name);
                    if (this.countMap.get(name) == null) {
                        this.countMap.put(name, 0);
                    }
                    this.countMap.put(name, this.countMap.get(name) + 1);
                    long cumulativeTime = (this.aggregateTimeMap.get(name) != null ? this.aggregateTimeMap.get(name) : 0L) + time;
                    this.aggregateTimeMap.put(name, cumulativeTime);
                }
                catch (NumberFormatException e) {
                    SystemTapUIErrorMessages m = new SystemTapUIErrorMessages(Messages.getString("StapGraphParser.idOrTime"), Messages.getString("StapGraphParser.idOrTime"), Messages.getString("StapGraphParser.nonNumericTime"));
                    m.schedule();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    try {
                        buff.close();
                        return iStatus;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return iStatus;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                buff.close();
            }
            catch (IOException e) {}
        }
        this.neighbourMaps.put(0, outNeighbours);
        this.nameMaps.put(0, nameList);
        this.idMaps.put(0, idList);
        try {
            this.view.update();
            return Status.OK_STATUS;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public IStatus realTimeParsing() {
        BufferedReader buff = this.internalData;
        boolean draw = false;
        boolean first = true;
        try {
            String line;
            while ((line = buff.readLine()) != null) {
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (line.length() < 1) continue;
                if (first && line.contains(Messages.getString("StapGraphParser.17"))) {
                    return this.parseDotFile();
                }
                first = false;
                draw = true;
                if (line.equals("PROBE_BEGIN")) {
                    buff.mark(100);
                    String tmp = buff.readLine();
                    if (tmp == null || tmp.length() <= 0) continue;
                    char tchar = tmp.charAt(0);
                    if (tchar != '-' && tchar != '+' && tchar != '?' && tchar != '>' && tchar != '<') {
                        this.project = CoreModel.getDefault().getCModel().getCProject(tmp);
                        continue;
                    }
                    buff.reset();
                    continue;
                }
                if (line.charAt(0) == '-') {
                    this.endingTimeInNS = Long.parseLong(line.substring(1));
                    continue;
                }
                if (line.charAt(0) == '+') {
                    this.totalTime = Long.parseLong(line.substring(1));
                    this.parseEnd();
                    continue;
                }
                if (line.charAt(0) == '?') {
                    if (line.length() <= 1) continue;
                    this.parseMarked(line.substring(1));
                    continue;
                }
                if (this.parse(line) != Status.CANCEL_STATUS) continue;
            }
            if (draw && this.view != null) {
                this.view.update();
                this.realTimeParsing();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private void showTime(int id, long time) {
        String tmp = this.markedMap.get(id);
        if (tmp == null) {
            tmp = "";
        }
        this.markedMap.put(id, tmp + Messages.getString("StapGraphParser.ActualTime") + time / 1000000L + Messages.getString("StapGraphParser.TimeUnits"));
    }
}

