/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.model.NodeDataModel;

public class Node {
    private double value;
    private int level;
    private String id;
    private String description = "";
    private NodeDataModel model;
    private List<Node> children;
    private Point angleBounds;
    private Color sliceColor;
    private boolean isVisible;
    private boolean isVisibleInLegend;
    private Node parent;
    private int maxSubTreeDepth;
    private Object data;

    public Node(String id, double value, NodeDataModel dataModel) {
        this.id = id;
        this.value = value;
        this.model = dataModel;
        this.level = 0;
        this.children = new ArrayList<Node>();
        this.isVisible = true;
        this.isVisibleInLegend = true;
    }

    public Node(String id, double value, Node parent) {
        this.id = id;
        this.value = value;
        this.children = new ArrayList<Node>();
        this.isVisible = parent.isVisible;
        this.isVisibleInLegend = parent.isVisibleInLegend;
        this.parent = parent;
        this.level = parent.level + 1;
        this.model = parent.model;
        this.setSliceColor(Display.getDefault().getSystemColor(3));
        this.model.getTree().put(id, this);
        this.getParent().getChildren().add(this);
    }

    public double getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description.isEmpty() ? this.id : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Point getAngleBounds() {
        return this.angleBounds;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public Color getSliceColor() {
        return this.sliceColor;
    }

    public void setSliceColor(Color sliceColor) {
        this.sliceColor = sliceColor;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisibleInLegend() {
        return this.isVisibleInLegend;
    }

    public void setVisibleInLegend(boolean isVisibleInLegend) {
        this.isVisibleInLegend = isVisibleInLegend;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxSubTreeDepth() {
        return this.maxSubTreeDepth;
    }

    public NodeDataModel getDataModel() {
        return this.model;
    }

    public void setValue(double value) {
        this.value = value;
        this.update();
    }

    public void setId(String label) {
        this.id = label;
    }

    public void setAngleBounds(Point point) {
        this.angleBounds = point;
    }

    public void changeParent(Node parent) {
        this.parent = parent;
    }

    public void setDataModel(NodeDataModel model) {
        this.model = model;
    }

    public void addChildren(String[] labels, double[] vals) {
        int length = labels.length;
        int cfr_ignored_0 = vals.length;
        int i = 0;
        while (i < length) {
            new Node(labels[i], vals[i], this);
            ++i;
        }
        this.update();
    }

    public void addChildren(Node[] nodes) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            String label = node.id;
            double value = node.value;
            new Node(label, value, this);
            ++n2;
        }
        this.update();
    }

    public Node addChild(String label, double value) {
        Node node = new Node(label, value, this);
        this.update();
        return node;
    }

    Node removeChild(String child) {
        Node node = null;
        for (Node nodes : this.children) {
            if (nodes.getId() != child) continue;
            node = nodes;
        }
        if (node == null) {
            return null;
        }
        this.children.remove(node);
        this.model.getTree().remove(child);
        this.update();
        return node;
    }

    public void updateValues() {
        if (this.children.isEmpty()) {
            this.maxSubTreeDepth = 1;
            return;
        }
        double total = 0.0;
        List<Node> nodes = this.children;
        for (Node node : nodes) {
            node.updateValues();
            total += node.value;
            this.maxSubTreeDepth = Math.max(this.maxSubTreeDepth, node.maxSubTreeDepth + 1);
        }
        if (total > this.value) {
            this.value = total;
        }
    }

    public void updateAngularBounds() {
        List<Node> nodes = this.children;
        if (nodes == null) {
            return;
        }
        int start = this.angleBounds.x;
        double diff = 0.0;
        double required = 0.0;
        for (Node node : nodes) {
            int angleCovered = (int)(node.getValue() * (double)this.angleBounds.y / this.getValue());
            if (angleCovered == 0 && node.getValue() != 0.0) {
                angleCovered = 1;
                required -= 1.0;
            } else {
                diff = node.getValue() * (double)this.angleBounds.y / this.value - (double)angleCovered;
                if ((required += diff) > 0.999) {
                    required -= 1.0;
                    ++angleCovered;
                }
            }
            node.setAngleBounds(new Point(start, angleCovered));
            this.model.getNodes()[node.getLevel() - this.model.getRootPointer().getLevel()].add(node);
            node.updateAngularBounds();
            start += angleCovered;
        }
    }

    public void update() {
        this.model.update();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

