/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.LogConfig;

final class ImmutableLogConfig
implements LogConfig {
    private final String logType;
    @Nullable
    private final Map<String, String> logOptions;

    private ImmutableLogConfig(String logType, @Nullable Map<String, String> logOptions) {
        this.logType = logType;
        this.logOptions = logOptions;
    }

    @Override
    @JsonProperty(value="Type")
    public String logType() {
        return this.logType;
    }

    @Override
    @JsonProperty(value="Config")
    @Nullable
    public Map<String, String> logOptions() {
        return this.logOptions;
    }

    public final ImmutableLogConfig withLogType(String value) {
        String newValue = Objects.requireNonNull(value, "logType");
        if (this.logType.equals(newValue)) {
            return this;
        }
        return new ImmutableLogConfig(newValue, this.logOptions);
    }

    public final ImmutableLogConfig withLogOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.logOptions == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableLogConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableLogConfig(this.logType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogConfig && this.equalsByValue((ImmutableLogConfig)another);
    }

    private boolean equalsByValue(ImmutableLogConfig another) {
        return this.logType.equals(another.logType) && Objects.equals(this.logOptions, another.logOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.logType.hashCode();
        h += (h << 5) + Objects.hashCode(this.logOptions);
        return h;
    }

    public String toString() {
        return "LogConfig{logType=" + this.logType + ", logOptions=" + String.valueOf(this.logOptions) + "}";
    }

    public static ImmutableLogConfig copyOf(LogConfig instance) {
        if (instance instanceof ImmutableLogConfig) {
            return (ImmutableLogConfig)instance;
        }
        return ImmutableLogConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements LogConfig.Builder {
        private static final long INIT_BIT_LOG_TYPE = 1L;
        private long initBits = 1L;
        private String logType;
        private Map<String, String> logOptions = null;

        private Builder() {
        }

        public final Builder from(LogConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.logType(instance.logType());
            Map<String, String> logOptionsValue = instance.logOptions();
            if (logOptionsValue != null) {
                this.putAllLogOptions(logOptionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Type")
        public final Builder logType(String logType) {
            this.logType = Objects.requireNonNull(logType, "logType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLogOption(String key, String value) {
            if (this.logOptions == null) {
                this.logOptions = new LinkedHashMap<String, String>();
            }
            this.logOptions.put(Objects.requireNonNull(key, "logOptions key"), Objects.requireNonNull(value, value == null ? "logOptions value for key: " + key : null));
            return this;
        }

        public final Builder addLogOption(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.logOptions == null) {
                this.logOptions = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.logOptions.put(Objects.requireNonNull(k, "logOptions key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "logOptions value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Config")
        public final Builder logOptions(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.logOptions = null;
                return this;
            }
            this.logOptions = new LinkedHashMap<String, String>();
            return this.putAllLogOptions(entries);
        }

        public final Builder putAllLogOptions(Map<String, ? extends String> entries) {
            if (this.logOptions == null) {
                this.logOptions = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.logOptions.put(Objects.requireNonNull(k, "logOptions key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "logOptions value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableLogConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogConfig(this.logType, this.logOptions == null ? null : ImmutableLogConfig.createUnmodifiableMap(false, false, this.logOptions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("logType");
            }
            return "Cannot build LogConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

