/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.exceptions.DockerTimeoutException;
import org.mandas.docker.client.messages.ProgressMessage;

class ProgressStream
implements Closeable {
    private final MappingIterator<ProgressMessage> iterator;
    private final JsonParser parser;

    ProgressStream(InputStream stream) throws IOException {
        this.parser = ObjectMapperProvider.objectMapper().getFactory().createParser(stream);
        this.iterator = ObjectMapperProvider.objectMapper().readValues(this.parser, ProgressMessage.class);
    }

    public boolean hasNextMessage(String method, URI uri) throws DockerException {
        try {
            return this.iterator.hasNextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public ProgressMessage nextMessage(String method, URI uri) throws DockerException {
        try {
            return (ProgressMessage)this.iterator.nextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public void tail(ProgressHandler handler, String method, URI uri) throws DockerException, InterruptedException {
        while (this.hasNextMessage(method, uri)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            handler.progress(this.nextMessage(method, uri));
        }
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

