/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.MultipleContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class LSPSAXParser
extends SAXParser {
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private final LSPXMLGrammarPool grammarPool;
    private final DOMDocument document;
    private XMLLocator locator;

    public LSPSAXParser(LSPErrorReporterForXML reporter, XMLParserConfiguration config, LSPXMLGrammarPool grammarPool, DOMDocument document) {
        super(config);
        this.grammarPool = grammarPool;
        this.document = document;
        super.setContentHandler((ContentHandler)new MultipleContentHandler());
        this.init(reporter);
    }

    private void init(LSPErrorReporterForXML reporter) {
        try {
            super.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        String publicId;
        String rootElement;
        XMLDTDDescription grammarDesc;
        DTDGrammar grammar;
        String systemId;
        DOMDocumentType docType;
        this.locator = locator;
        if (this.grammarPool != null && (docType = this.document.getDoctype()) != null && (systemId = this.document.getDoctype().getSystemIdWithoutQuotes()) != null && (grammar = (DTDGrammar)this.grammarPool.retrieveGrammar((XMLGrammarDescription)(grammarDesc = this.createGrammarDescription(rootElement = this.document.getDocumentElement().getTagName(), publicId = this.document.getDoctype().getPublicIdWithoutQuotes(), systemId)))) != null && this.grammarPool.setInternalSubset(grammarDesc, docType.getInternalSubset())) {
            this.grammarPool.removeGrammar((XMLGrammarDescription)grammarDesc);
        }
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (systemId != null && this.grammarPool != null) {
            XMLEntityManager entityManager = (XMLEntityManager)this.fConfiguration.getProperty(ENTITY_MANAGER);
            XMLDTDDescription grammarDesc = this.createGrammarDescription(rootElement, publicId, systemId);
            DTDGrammar grammar = (DTDGrammar)this.grammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc);
            if (grammar != null) {
                LSPSAXParser.fillEntities(grammar, entityManager);
            }
        }
        super.doctypeDecl(rootElement, publicId, systemId, augs);
    }

    private XMLDTDDescription createGrammarDescription(String rootElement, String publicId, String systemId) {
        String eid = null;
        try {
            eid = XMLEntityManager.expandSystemId((String)systemId, (String)this.locator.getExpandedSystemId(), (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new XMLDTDDescription(publicId, systemId, this.locator.getExpandedSystemId(), eid, rootElement);
    }

    private static void fillEntities(DTDGrammar grammar, final XMLEntityManager entityManager) {
        int index = 0;
        XMLEntityDecl entityDecl = new XMLEntityDecl(){

            public void setValues(String name, String publicId, String systemId, String baseSystemId, String notation, String value, boolean isPE, boolean inExternal) {
                if (systemId != null) {
                    if (notation != null) {
                        entityManager.addUnparsedEntity(name, publicId, systemId, baseSystemId, notation);
                    } else {
                        try {
                            entityManager.addExternalEntity(name, publicId, systemId, baseSystemId);
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    entityManager.addInternalEntity(name, value);
                }
            }
        };
        while (grammar.getEntityDecl(index, entityDecl)) {
            ++index;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        ((MultipleContentHandler)this.getContentHandler()).addContentHandler(contentHandler);
    }
}

