/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.helper;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.widget.MDERichtextWidgetEditorImpl;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditor;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditorInput;
import org.polarsys.kitalpha.richtext.widget.editor.intf.EditorInputFeatureContribution;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;

public class MDERichtextWidgetHelper {
    public static final String INPUT_FEATURE_CONTRIBUTION_EXTENSION_ID = "org.polarsys.kitalpha.richtext.widget.editorInputFeatureContribution";
    public static final String EDITOR_WIDGET_CONTRIBUTION_EXTENSION_ID = "org.polarsys.kitalpha.richtext.widget.editorWidgetContribution";
    public static final String CONTRIBUTION_CLASS_ATTR = "class";
    private static MDERichtextWidgetHelper instance;
    private List<EditorInputFeatureContribution> inputFeatureContributions;
    private MDERichtextWidgetEditorImpl contributedEditorWidget;

    private MDERichtextWidgetHelper() {
    }

    public static MDERichtextWidgetHelper getInstance() {
        if (instance == null) {
            instance = new MDERichtextWidgetHelper();
        }
        return instance;
    }

    public static boolean isRichtextEditor(IEditorReference editor) {
        return editor.getEditor(false) instanceof MDERichTextEditor;
    }

    public static List<MDERichTextEditor> getActiveMDERichTextEditors() {
        ArrayList<MDERichTextEditor> references = new ArrayList<MDERichTextEditor>();
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editor = iEditorReferenceArray[n6];
                    if (MDERichtextWidgetHelper.isRichtextEditor(editor)) {
                        references.add((MDERichTextEditor)editor.getEditor(false));
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return references;
    }

    public static List<MDERichTextEditor> getActiveMDERichTextEditors(TransactionalEditingDomain domain) {
        ArrayList<MDERichTextEditor> activeEditors = new ArrayList<MDERichTextEditor>();
        for (MDERichTextEditor richtextEditor : MDERichtextWidgetHelper.getActiveMDERichTextEditors()) {
            MDERichTextEditorInput input = (MDERichTextEditorInput)richtextEditor.getEditorInput();
            if (domain != TransactionUtil.getEditingDomain((EObject)input.getElement())) continue;
            activeEditors.add(richtextEditor);
        }
        return activeEditors;
    }

    public static List<MDERichTextEditor> getActiveMDERichTextEditors(EObject element) {
        ArrayList<MDERichTextEditor> activeEditors = new ArrayList<MDERichTextEditor>();
        for (MDERichTextEditor richtextEditor : MDERichtextWidgetHelper.getActiveMDERichTextEditors()) {
            MDERichTextEditorInput input = (MDERichTextEditorInput)richtextEditor.getEditorInput();
            if (element != input.getElement()) continue;
            activeEditors.add(richtextEditor);
        }
        return activeEditors;
    }

    public List<EditorInputFeatureContribution> getEditorInputFeatureContribution() {
        if (this.inputFeatureContributions == null) {
            this.inputFeatureContributions = new ArrayList<EditorInputFeatureContribution>();
            IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(INPUT_FEATURE_CONTRIBUTION_EXTENSION_ID);
            if (contributions != null && contributions.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = contributions;
                int n = contributions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement c = iConfigurationElementArray[n2];
                    try {
                        EditorInputFeatureContribution contribution = (EditorInputFeatureContribution)c.createExecutableExtension(CONTRIBUTION_CLASS_ATTR);
                        this.inputFeatureContributions.add(contribution);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                    ++n2;
                }
            }
        }
        return this.inputFeatureContributions;
    }

    public MDERichtextWidgetEditorImpl getEditorWidgetContribution(Composite parent, MDENebulaRichTextConfiguration configuration) {
        IConfigurationElement[] contributions;
        if (this.contributedEditorWidget == null && (contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_WIDGET_CONTRIBUTION_EXTENSION_ID)) != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    String contributorAttribute = c.getAttribute(CONTRIBUTION_CLASS_ATTR);
                    String contributorName = c.getDeclaringExtension().getContributor().getName();
                    Class javaClass = Platform.getBundle((String)contributorName).loadClass(contributorAttribute);
                    Constructor constructor = javaClass.getDeclaredConstructor(Composite.class, MDENebulaRichTextConfiguration.class);
                    return (MDERichtextWidgetEditorImpl)((Object)constructor.newInstance(parent, configuration));
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    ++n2;
                }
            }
        }
        return this.contributedEditorWidget;
    }

    public static void closeInvalidEditors(TransactionalEditingDomain editingDomain) {
        MDERichtextWidgetHelper.closeEditors(editingDomain, true, false);
    }

    public static void closeEditors(TransactionalEditingDomain editingDomain) {
        MDERichtextWidgetHelper.closeEditors(editingDomain, false, true);
    }

    private static void closeEditors(TransactionalEditingDomain editingDomain, boolean onlyInvalid, boolean desactivateEditors) {
        for (MDERichTextEditor editor : MDERichtextWidgetHelper.getActiveMDERichTextEditors()) {
            MDERichTextEditorInput editorInput = (MDERichTextEditorInput)editor.getEditorInput();
            EObject element = editorInput.getElement();
            TransactionalEditingDomain eltEditingDomain = TransactionUtil.getEditingDomain((EObject)element);
            if (desactivateEditors) {
                editor.switchDeactivateState();
            }
            if (eltEditingDomain == null) {
                MDERichtextWidgetHelper.close((IEditorPart)editor);
                continue;
            }
            if (onlyInvalid && element.eResource() == null) {
                MDERichtextWidgetHelper.close((IEditorPart)editor);
                continue;
            }
            if (onlyInvalid || eltEditingDomain != editingDomain) continue;
            MDERichtextWidgetHelper.close((IEditorPart)editor);
        }
    }

    private static void close(final IEditorPart editor) {
        if (editor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = editor.getEditorSite().getPage();
                    if (page != null) {
                        page.closeEditor(editor, false);
                    }
                }
            });
        }
    }
}

