/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.polarsys.kitalpha.report.ui.Activator;
import org.polarsys.kitalpha.report.ui.description.ColumnDescription;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;
import org.polarsys.kitalpha.report.ui.views.MenuCreatorAction;
import org.polarsys.kitalpha.report.ui.views.ReportsView;

public class ManageColumnsAction
extends MenuCreatorAction {
    private final ReportsView view;

    public ManageColumnsAction(ReportsView view) {
        this.view = view;
        this.setToolTipText("Manage columns");
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/manageColumns.gif"));
    }

    @Override
    protected void fillMenu(Control parent) {
        Set<String> displayedColumns = ReportsUI.getDisplayedColumns();
        for (ColumnDescription desc : ReportsUI.getAvailableColumns()) {
            ColumnAction action = new ColumnAction(desc);
            action.setChecked(displayedColumns.contains(desc.getId()));
            this.addActionToMenu(this.menu, action);
        }
    }

    class ColumnAction
    extends Action {
        private final ColumnDescription desc;

        public ColumnAction(ColumnDescription desc) {
            super(desc.getLabel(), 2);
            this.desc = desc;
        }

        public void run() {
            String id = this.desc.getId();
            if (ReportsUI.getDisplayedColumns().contains(id)) {
                ReportsUI.getDisplayedColumns().remove(id);
                ManageColumnsAction.this.view.deleteColumn(id);
            } else {
                ReportsUI.getDisplayedColumns().add(id);
                ManageColumnsAction.this.view.createColumn(id);
            }
            ManageColumnsAction.this.view.refreshView();
        }
    }
}

