/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.Maths;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MathsComplexAbsFunctionParameterizeTest {
    @Parameterized.Parameter
    public Class<? extends CompoundDataset> classType;
    private static final double ABSERRD = 1.0E-8;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(ComplexFloatDataset.class, ComplexDoubleDataset.class);
    }

    @Test
    public void test() throws Exception {
        Class<? extends CompoundDataset> class1 = this.classType;
        double[] ds = new double[]{0.0, 1.0, 2.0, -3.0, 4.0, 5.0};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)ds);
        Dataset output = DatasetFactory.createFromObject(class1, (Object)new double[]{0.0, 4.0, 0.0, 0.0, 0.0, 0.0});
        int size = ds.length;
        double[] c = new double[size];
        int i = 0;
        while (i < size) {
            double val;
            c[i] = val = Math.hypot(ds[i], ds[i + 1]);
            c[i + 1] = 0.0;
            i += 2;
        }
        Dataset expectedResult = DatasetFactory.createFromObject(class1, (Object)c);
        Dataset actualResult = Maths.abs((Object)input, (Dataset)output);
        TestUtils.assertDatasetEquals((Dataset)expectedResult, (Dataset)actualResult, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }
}

