/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class AbstractCompoundDatasetTest {
    long[] ldata;
    int[] idata;
    short[] sdata;
    byte[] bdata;
    double[] ddata;
    float[] fdata;

    public AbstractCompoundDatasetTest() {
        long[] lArray = new long[6];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        this.ldata = lArray;
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.idata = nArray;
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 5;
        this.sdata = sArray;
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        this.bdata = byArray;
        this.ddata = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        this.fdata = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    }

    @Test
    public void testSlice() {
        int isize = 5;
        int size = 1024;
        this.testSliceND(isize, size, CompoundDoubleDataset.class);
        this.testSliceND(2, size, ComplexDoubleDataset.class);
        this.testSliceND(size, DoubleDataset.class);
        this.testSliceND(size, ShortDataset.class);
    }

    private void testSliceND(int isize, int size, Class<? extends CompoundDataset> clazz) {
        CompoundDataset ta = DatasetFactory.createRange((int)isize, clazz, (double)0.0, (double)size, (double)1.0);
        this.testSlicedDataset(ta);
        ta = DatasetFactory.createRange((int)isize, clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, size / 16});
        System.out.println(" Shape: " + Arrays.toString(ta.getShape()));
        this.testSlicedDataset(ta);
        ta = DatasetFactory.createRange((int)isize, clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 32, 32});
        System.out.println(" Shape: " + Arrays.toString(ta.getShape()));
        this.testSlicedDataset(ta);
        ta = DatasetFactory.createRange((int)isize, clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, 8, size / 128});
        System.out.println(" Shape: " + Arrays.toString(ta.getShape()));
        this.testSlicedDataset(ta);
        ta = DatasetFactory.createRange((int)isize, clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 128, 16, 8});
        System.out.println(" Shape: " + Arrays.toString(ta.getShape()));
        this.testSlicedDataset(ta);
    }

    private void testSliceND(int size, Class<? extends Dataset> clazz) {
        CompoundDataset ta = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)DatasetFactory.createRange(clazz, (double)size).reshape(new int[]{size / 16, 16}), (boolean)true);
        this.testSlicedDataset(ta);
        this.testElementViews(ta);
        ta = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)DatasetFactory.createRange(clazz, (double)size).reshape(new int[]{size / 128, 16, 8}), (boolean)true);
        this.testSlicedDataset(ta);
        this.testElementViews(ta);
        ta = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)DatasetFactory.createRange(clazz, (double)size).reshape(new int[]{size / 128, 8, 8, 2}), (boolean)true);
        this.testSlicedDataset(ta);
        this.testElementViews(ta);
    }

    private void testSlicedDataset(CompoundDataset ta) {
        int[] stop = ta.getShape();
        int n = stop.length - 1;
        stop[n] = stop[n] - 1;
        CompoundDataset sa = ta.getSliceView(null, stop, null);
        PositionIterator it = new PositionIterator(sa.getShape());
        int[] pos = it.getPos();
        double[] expected = new double[ta.getElementsPerItem()];
        double[] actual = new double[expected.length];
        while (it.hasNext()) {
            ta.getDoubleArray(actual, pos);
            sa.getDoubleArray(expected, pos);
            Assert.assertArrayEquals((double[])expected, (double[])actual, (double)1.0E-14);
        }
    }

    private void testElementViews(CompoundDataset ta) {
        int isize = ta.getElementsPerItem();
        int e = isize > 1 ? isize - 2 : isize - 1;
        Dataset va = ta.getElementsView(e);
        Assert.assertArrayEquals((int[])ta.getShapeRef(), (int[])va.getShapeRef());
        IndexIterator it = ta.getIterator(true);
        int[] pos = it.getPos();
        while (it.hasNext()) {
            Assert.assertEquals((double)ta.getElementDoubleAbs(it.index + e), (double)va.getDouble(pos), (double)1.0E-14);
        }
        va.setSlice((Object)0, new Slice[0]);
        it.reset();
        while (it.hasNext()) {
            Assert.assertEquals((double)0.0, (double)va.getDouble(pos), (double)1.0E-14);
            Assert.assertEquals((double)0.0, (double)ta.getElementDoubleAbs(it.index + e), (double)1.0E-14);
        }
    }

    @Test
    public void testToDoubleArray() {
        double[] d = DTypeUtils.toDoubleArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toDoubleArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toDoubleArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toDoubleArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toDoubleArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toDoubleArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testToFloatArray() {
        float[] d = DTypeUtils.toFloatArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toFloatArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toFloatArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toFloatArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toFloatArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toFloatArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testToLongArray() {
        long[] d = DTypeUtils.toLongArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toLongArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toLongArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toLongArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toLongArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toLongArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testToIntegerArray() {
        int[] d = DTypeUtils.toIntegerArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toIntegerArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toIntegerArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toIntegerArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toIntegerArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toIntegerArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testToShortArray() {
        short[] d = DTypeUtils.toShortArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toShortArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toShortArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toShortArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toShortArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toShortArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testToByteArray() {
        byte[] d = DTypeUtils.toByteArray((Object)this.ddata, (int)this.idata.length);
        int i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toByteArray((Object)this.fdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toByteArray((Object)this.ldata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toByteArray((Object)this.idata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toByteArray((Object)this.sdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
        d = DTypeUtils.toByteArray((Object)this.bdata, (int)this.idata.length);
        i = 0;
        while (i < this.idata.length) {
            Assert.assertEquals((double)this.ddata[i], (double)d[i], (double)1.0E-10);
            ++i;
        }
    }

    @Test
    public void testSum() {
        IntegerDataset d = Random.randint((int)0, (int)255, (int[])new int[]{5, 2});
        CompoundDataset dc = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        Dataset dd = DatasetUtils.createDatasetFromCompoundDataset((CompoundDataset)dc, (boolean)true);
        double[] dcsum = (double[])dc.sum(new boolean[0]);
        double dsum = ((Number)d.sum(new boolean[0])).doubleValue();
        double ddsum = ((Number)dd.sum(new boolean[0])).doubleValue();
        Assert.assertEquals((double)dsum, (double)(dcsum[0] + dcsum[1]), (double)1.0E-10);
        Assert.assertEquals((double)dsum, (double)ddsum, (double)1.0E-10);
        d = Random.randint((int)0, (int)255, (int[])new int[]{5, 3, 2});
        dc = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        Dataset dca = DatasetUtils.createDatasetFromCompoundDataset((CompoundDataset)dc.sum(0, new boolean[0]), (boolean)true);
        Dataset da = d.sum(0, new boolean[0]);
        IndexIterator it = da.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)da.getElementDoubleAbs(it.index), (double)dca.getElementDoubleAbs(it.index), (double)1.0E-15);
        }
        Dataset dcb = DatasetUtils.createDatasetFromCompoundDataset((CompoundDataset)dc.sum(1, new boolean[0]), (boolean)true);
        Dataset db = d.sum(1, new boolean[0]);
        it = db.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)db.getElementDoubleAbs(it.index), (double)dcb.getElementDoubleAbs(it.index), (double)1.0E-15);
        }
    }

    @Test
    public void testCompoundIntegerCreators() {
        int j;
        int iz = 3;
        CompoundIntegerDataset z = CompoundIntegerDataset.createFromObject((Object)iz);
        Assert.assertEquals((long)0L, (long)z.getRank());
        Assert.assertEquals((long)1L, (long)z.getSize());
        Assert.assertEquals((long)1L, (long)z.getElementsPerItem());
        Assert.assertEquals((long)iz, (long)z.getElementLongAbs(0));
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] ia = nArray;
        CompoundIntegerDataset a = CompoundIntegerDataset.createFromObject((Object)ia);
        int is = a.getElementsPerItem();
        Assert.assertEquals((long)6L, (long)is);
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)1L, (long)a.getSize());
        Assert.assertEquals((long)1L, (long)a.getShapeRef()[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            j = 0;
            while (j < is) {
                Assert.assertEquals((long)i, (long)a.getElementLongAbs(it.index + j));
                ++j;
                ++i;
            }
        }
        a = CompoundIntegerDataset.createFromObject((int)ia.length, (Object)ia);
        is = a.getElementsPerItem();
        Assert.assertEquals((long)6L, (long)is);
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)1L, (long)a.getSize());
        Assert.assertEquals((long)1L, (long)a.getShapeRef()[0]);
        it = a.getIterator();
        i = 0;
        while (it.hasNext()) {
            j = 0;
            while (j < is) {
                Assert.assertEquals((long)i, (long)a.getElementLongAbs(it.index + j));
                ++j;
                ++i;
            }
        }
    }

    @Test
    public void testCompoundCreators() {
        double dz = 0.5;
        CompoundDoubleDataset z = CompoundDoubleDataset.createFromObject((Object)dz);
        Assert.assertEquals((long)0L, (long)z.getRank());
        Assert.assertEquals((long)1L, (long)z.getSize());
        Assert.assertEquals((long)1L, (long)z.getElementsPerItem());
        Assert.assertEquals((double)dz, (double)z.getElementDoubleAbs(0), (double)1.0E-14);
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        CompoundDoubleDataset a = CompoundDoubleDataset.createFromObject((Object)da);
        int is = a.getElementsPerItem();
        Assert.assertEquals((long)6L, (long)is);
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)1L, (long)a.getSize());
        Assert.assertEquals((long)1L, (long)a.getShapeRef()[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i));
                ++j;
                ++i;
            }
        }
        double[][] db = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        CompoundDoubleDataset b = CompoundDoubleDataset.createFromObject((Object)db);
        is = b.getElementsPerItem();
        Assert.assertEquals((long)3L, (long)is);
        Assert.assertEquals((long)1L, (long)b.getRank());
        Assert.assertEquals((long)2L, (long)b.getSize());
        Assert.assertEquals((long)2L, (long)b.getShapeRef()[0]);
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i2));
                ++j;
                ++i2;
            }
        }
        b.hashCode();
        double[] mb = (double[])b.mean(new boolean[0]);
        double[] rb = new double[]{1.5, 2.5, 3.5};
        int j = 0;
        while (j < is) {
            Assert.assertEquals((double)rb[j], (double)mb[j], (double)1.0E-15);
            ++j;
        }
        double[][] dc = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        CompoundDoubleDataset c = CompoundDoubleDataset.createFromObject((Object)dc);
        is = c.getElementsPerItem();
        Assert.assertEquals((long)4L, (long)is);
        Assert.assertEquals((long)1L, (long)c.getRank());
        Assert.assertEquals((long)2L, (long)c.getSize());
        Assert.assertEquals((long)2L, (long)c.getShapeRef()[0]);
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            int j2 = 0;
            while (j2 < is) {
                if (i3 < 7) {
                    Assert.assertEquals((double)i3, (double)c.getElementDoubleAbs(it.index + j2), (double)(1.0E-15 * (double)i3));
                } else {
                    Assert.assertEquals((double)0.0, (double)c.getElementDoubleAbs(it.index + j2), (double)1.0E-15);
                }
                ++j2;
                ++i3;
            }
        }
        double[][] dd = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        CompoundDoubleDataset d = CompoundDoubleDataset.createFromObject((Object)dd);
        is = d.getElementsPerItem();
        Assert.assertEquals((long)4L, (long)is);
        Assert.assertEquals((long)1L, (long)d.getRank());
        Assert.assertEquals((long)2L, (long)d.getSize());
        Assert.assertEquals((long)2L, (long)d.getShapeRef()[0]);
        it = d.getIterator();
        int i4 = 0;
        while (it.hasNext()) {
            int j3 = 0;
            while (j3 < is) {
                if (i4 != 3) {
                    Assert.assertEquals((double)i4, (double)d.getElementDoubleAbs(it.index + j3), (double)(1.0E-15 * (double)i4));
                } else {
                    Assert.assertEquals((double)0.0, (double)d.getElementDoubleAbs(it.index + j3), (double)1.0E-15);
                }
                ++j3;
                ++i4;
            }
        }
    }

    @Test
    public void testCompoundCreatorsWithNonContiguousDatasets() {
        double[][] db = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset b = DoubleDataset.createFromObject((Object)db);
        CompoundDoubleDataset cb = CompoundDoubleDataset.createCompoundDatasetWithLastDimension((Dataset)b, (boolean)true);
        int is = cb.getElementsPerItem();
        Assert.assertEquals((long)3L, (long)is);
        Assert.assertEquals((long)1L, (long)cb.getRank());
        Assert.assertEquals((long)2L, (long)cb.getSize());
        Assert.assertEquals((long)2L, (long)cb.getShapeRef()[0]);
        IndexIterator it = cb.getIterator();
        int i = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                Assert.assertEquals((double)i, (double)cb.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i));
                ++j;
                ++i;
            }
        }
        double[][] dc = new double[][]{{0.0, 2.0, 4.0}, {1.0, 3.0, 5.0}};
        b = DoubleDataset.createFromObject((Object)dc);
        cb = CompoundDoubleDataset.createCompoundDatasetWithLastDimension((Dataset)b.getTransposedView(new int[0]), (boolean)true);
        is = cb.getElementsPerItem();
        it = cb.getIterator();
        Assert.assertEquals((long)2L, (long)is);
        Assert.assertEquals((long)1L, (long)cb.getRank());
        Assert.assertEquals((long)3L, (long)cb.getSize());
        Assert.assertEquals((long)3L, (long)cb.getShapeRef()[0]);
        int i2 = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                Assert.assertEquals((double)i2, (double)cb.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i2));
                ++j;
                ++i2;
            }
        }
        CompoundDataset cc = cb.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        Dataset c = cc.asNonCompoundDataset(true);
        double[][] dd = new double[][]{{0.0, 1.0}, {4.0, 5.0}};
        b = DoubleDataset.createFromObject((Object)dd);
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)b.getElementDoubleAbs(i3), (double)c.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i3));
            ++i3;
        }
    }

    @Test
    public void testRGB() {
        IntegerDataset r = Random.randint((int)0, (int)255, (int[])new int[]{128, 128});
        IntegerDataset g = Random.randint((int)0, (int)255, (int[])r.getShapeRef());
        IntegerDataset b = Random.randint((int)0, (int)255, (int[])r.getShapeRef());
        RGBDataset c = new RGBDataset((Dataset)r, (Dataset)g, (Dataset)b);
        System.out.println("" + c.hashCode());
        double[] mc = (double[])c.mean(new boolean[0]);
        double[] rc = new double[]{((Number)r.mean(new boolean[0])).doubleValue(), ((Number)g.mean(new boolean[0])).doubleValue(), ((Number)b.mean(new boolean[0])).doubleValue()};
        int j = 0;
        while (j < 3) {
            Assert.assertEquals((double)rc[j], (double)mc[j], (double)1.0E-15);
            ++j;
        }
    }

    @Test
    public void testTake() {
        Dataset a = DatasetFactory.createRange(ComplexDoubleDataset.class, (double)12.0);
        System.out.println(a);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        Dataset t = DatasetUtils.take((Dataset)a, (int[])nArray, (Integer)0);
        System.out.println(t);
        a.setShape(new int[]{3, 4});
        System.out.println(a);
        t = DatasetUtils.take((Dataset)a, (int[])new int[1], (Integer)0);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{1}, (Integer)0);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{2}, (Integer)0);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[1], (Integer)1);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{1}, (Integer)1);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{2}, (Integer)1);
        System.out.println(t);
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{3}, (Integer)1);
        System.out.println(t);
    }

    @Test
    public void test1DErrors() {
        Dataset[] aa = new Dataset[5];
        int i = 0;
        while (i < 5) {
            aa[i] = DatasetFactory.createRange(IntegerDataset.class, (double)100.0);
            ++i;
        }
        CompoundIntegerDataset a = new CompoundIntegerDataset(aa);
        a.setErrors((Serializable)Integer.valueOf(5));
        Assert.assertTrue((boolean)a.hasErrors());
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(99)[4], (double)0.001);
        CompoundDataset error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)error.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(0).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(4).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getElements(4).getDouble(99), (double)0.001);
        a.setErrors((Serializable)Maths.multiply((Object)error, (Object)2));
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getErrorArray(99)[4], (double)0.001);
        CompoundDataset error2 = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error2);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)error2.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(0).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(4).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getElements(4).getDouble(99), (double)0.001);
        a.setErrors((Serializable)new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Assert.assertEquals((double)1.0, (double)a.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)a.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)1.0, (double)a.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)a.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)1.0, (double)a.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)a.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getErrorArray(99)[4], (double)0.001);
        CompoundDataset error3 = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error3);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)1.0, (double)error3.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)2.0, (double)error3.getElements(1).getDouble(50), (double)0.001);
        Assert.assertEquals((double)1.0, (double)error3.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)2.0, (double)error3.getElements(1).getDouble(0), (double)0.001);
        Assert.assertEquals((double)3.0, (double)error3.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)4.0, (double)error3.getElements(3).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error3.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)4.0, (double)error3.getElements(3).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error3.getElements(4).getDouble(99), (double)0.001);
    }

    @Test
    public void testInternalErrors() {
        Dataset[] aa = new Dataset[5];
        int i = 0;
        while (i < 5) {
            aa[i] = DatasetFactory.createRange(IntegerDataset.class, (double)100.0);
            ++i;
        }
        CompoundIntegerDataset a = new CompoundIntegerDataset(aa);
        a.setErrors((Serializable)new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        CompoundDataset e = (CompoundDataset)a.getErrorBuffer();
        double[] ea = e.getDoubleArray(0);
        Assert.assertEquals((double)1.0, (double)ea[0], (double)0.001);
        Assert.assertEquals((double)4.0, (double)ea[1], (double)0.001);
        Assert.assertEquals((double)9.0, (double)ea[2], (double)0.001);
        Assert.assertEquals((double)16.0, (double)ea[3], (double)0.001);
        Assert.assertEquals((double)25.0, (double)ea[4], (double)0.001);
        CompoundDataset error = a.getErrors();
        a.setErrors((Serializable)error);
        CompoundDataset ae = (CompoundDataset)a.getErrorBuffer();
        Assert.assertEquals((double)1.0, (double)ae.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)4.0, (double)ae.getElements(1).getDouble(0), (double)0.001);
        Assert.assertEquals((double)9.0, (double)ae.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)16.0, (double)ae.getElements(3).getDouble(0), (double)0.001);
        Assert.assertEquals((double)25.0, (double)ae.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)1.0, (double)ae.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)4.0, (double)ae.getElements(1).getDouble(99), (double)0.001);
        Assert.assertEquals((double)9.0, (double)ae.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)16.0, (double)ae.getElements(3).getDouble(99), (double)0.001);
        Assert.assertEquals((double)25.0, (double)ae.getElements(4).getDouble(99), (double)0.001);
    }

    @Test
    public void testSlicing() {
        CompoundDataset a = ((CompoundIntegerDataset)DatasetFactory.createRange((int)3, CompoundIntegerDataset.class, (double)12.0)).reshape(new int[]{3, 4});
        a.setSlice((Object)new short[]{-1, -2, -3}, new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(3)), new Slice(Integer.valueOf(3), Integer.valueOf(4))});
        Assert.assertArrayEquals((int[])new int[3], (int[])a.getIntArray(0, 0));
        int[] nArray = new int[3];
        nArray[0] = 8;
        Assert.assertArrayEquals((int[])nArray, (int[])a.getIntArray(2, 0));
        Assert.assertArrayEquals((int[])new int[]{-1, -2, -3}, (int[])a.getIntArray(2, 3));
    }

    @Test
    public void testBroadcastElements() {
        CompoundDataset a = DatasetFactory.createCompoundDataset((Object[])new Object[]{1, 2, 3}).getBroadcastView(new int[]{2});
        Dataset b = a.getElements(0);
        Assert.assertEquals((long)1L, (long)b.getInt(0));
        Assert.assertEquals((long)1L, (long)b.getInt(1));
        b = a.getElements(2);
        Assert.assertEquals((long)3L, (long)b.getInt(0));
        Assert.assertEquals((long)3L, (long)b.getInt(1));
        a = ((CompoundIntegerDataset)DatasetFactory.createRange((int)3, CompoundIntegerDataset.class, (double)4.0)).getBroadcastView(new int[]{5, 4});
        b = a.getElements(0);
        Assert.assertEquals((long)0L, (long)b.getInt(0, 0));
        Assert.assertEquals((long)1L, (long)b.getInt(0, 1));
        Assert.assertEquals((long)2L, (long)b.getInt(0, 2));
        Assert.assertEquals((long)3L, (long)b.getInt(0, 3));
        Assert.assertEquals((long)0L, (long)b.getInt(1, 0));
        Assert.assertEquals((long)1L, (long)b.getInt(2, 1));
        Assert.assertEquals((long)2L, (long)b.getInt(3, 2));
        Assert.assertEquals((long)3L, (long)b.getInt(4, 3));
        b = a.getElements(1);
        Assert.assertEquals((long)0L, (long)b.getInt(0, 0));
        Assert.assertEquals((long)0L, (long)b.getInt(0, 1));
        Assert.assertEquals((long)0L, (long)b.getInt(0, 2));
        Assert.assertEquals((long)0L, (long)b.getInt(0, 3));
        Assert.assertEquals((long)0L, (long)b.getInt(1, 0));
        Assert.assertEquals((long)0L, (long)b.getInt(2, 1));
        Assert.assertEquals((long)0L, (long)b.getInt(3, 2));
        Assert.assertEquals((long)0L, (long)b.getInt(4, 3));
    }

    @Test
    public void testBroadcastSliceView() {
        CompoundDataset a = DatasetFactory.createRange((int)3, CompoundIntegerDataset.class, (double)12.0);
        Dataset b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(5), Integer.valueOf(8))}).getBroadcastView(new int[]{2, 3});
        CompoundDataset r = ((CompoundIntegerDataset)DatasetFactory.createRange((int)3, CompoundIntegerDataset.class, (double)5.0, (double)8.0, (double)1.0)).reshape(new int[]{1, 3});
        Dataset c = DatasetUtils.concatenate((IDataset[])new Dataset[]{r, r}, (int)0);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(5), Integer.valueOf(6))}).getBroadcastView(new int[]{3, 3});
        int[] nArray = new int[3];
        nArray[0] = 5;
        c = ((CompoundIntegerDataset)DatasetFactory.zeros((int)3, CompoundIntegerDataset.class, (int[])new int[]{3, 3})).fill((Object)nArray);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
    }
}

