/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype.ZipCode;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void embeddableTest() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    this.logTrace("Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                this.logTrace("Received expected result:" + name);
                                continue;
                            }
                            this.logErr("Received unexpected result:" + name);
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("embeddable() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("embeddableTest failed");
        }
    }

    public void getAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Attribute attrib = eType.getAttribute("street");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("street")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: street, actual:" + name);
                    }
                } else {
                    this.logErr("getAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                try {
                    eType.getAttribute("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    public void getAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Set set = eType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    public void getCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClass failed");
        }
    }

    public void getCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode");
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionString failed");
        }
    }

    public void getCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Attribute attrib = eType.getDeclaredAttribute("cZipcode");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("cZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    public void getDeclaredAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredAttribute("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Set set = eType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes:");
                            this.logErr("Expected (" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getDeclaredAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    public void getDeclaredCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClass failed");
        }
    }

    public void getDeclaredCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionString failed");
        }
    }

    public void getDeclaredCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClass failed");
        }
    }

    public void getDeclaredListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode");
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListString failed");
        }
    }

    public void getDeclaredListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClass failed");
        }
    }

    public void getDeclaredMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist", Address.class, String.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode");
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapString failed");
        }
    }

    public void getDeclaredMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClass failed");
        }
    }

    public void getDeclaredSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode");
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetString failed");
        }
    }

    public void getDeclaredSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("city", String.class);
                if (singAttrib != null) {
                    this.logTrace("attribute city = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("city")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: name, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClass failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value", Integer.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("street");
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: street, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeString failed");
        }
    }

    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Set set = eType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getDeclaredSingularAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    public void getListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClass failed");
        }
    }

    public void getListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getList("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentException failed");
        }
    }

    public void getListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode");
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListString failed");
        }
    }

    public void getListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentException failed");
        }
    }

    public void getMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClass failed");
        }
    }

    public void getMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist", Address.class, String.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode");
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapString failed");
        }
    }

    public void getMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentException failed");
        }
    }

    public void getPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Set set = eType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received Unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getPluralAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getPluralAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    public void getSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClass failed");
        }
    }

    public void getSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentException failed");
        }
    }

    public void getSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode");
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sZipcode, actual:" + name);
                    }
                } else {
                    this.logErr("getSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetString failed");
        }
    }

    public void getSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street", String.class);
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: street, actual:" + name);
                    }
                } else {
                    this.logErr("getSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClass failed");
        }
    }

    public void getSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street");
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: street, actual:" + name);
                    }
                } else {
                    this.logErr("getSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeString failed");
        }
    }

    public void getSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null Entity Address");
                Set set = eType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received Unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getSingularAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getSingularAttributes(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                Set set = eType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received Unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getPluralAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getPluralAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

