/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.listener.AbstractStepListener;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named(value="metricsStepListener")
public class MetricsStepListener
extends AbstractStepListener {
    @Inject
    StepContext stepCtx;
    @Inject
    JobContext JobCtx;
    @Inject
    @BatchProperty(name="numberOfSkips")
    String skipNumberString;
    @Inject
    @BatchProperty(name="ReadProcessWrite")
    String RPWString;
    private static final String sourceClass = MetricsStepListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public static final String GOOD_EXIT_STATUS_READ = "GOOD READ METRICS RESULT";
    public static final String GOOD_EXIT_STATUS_PROCESS = "GOOD PROCESS METRICS RESULT";
    public static final String GOOD_EXIT_STATUS_WRITE = "GOOD PROCESS METRICS RESULT";
    public static final String GOOD_EXIT_STATUS = "GOOD METRICS RESULT";
    public static final String BAD_EXIT_STATUS = "BAD RESULT";
    int skipNum;

    public void beforeStep() {
        logger.finer("In before()");
        this.skipNum = Integer.parseInt(this.skipNumberString);
    }

    public void afterStep() {
        logger.finer("In after()");
        Metric[] metrics = this.stepCtx.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (this.RPWString.equals("READ")) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) continue;
                if (metrics[i].getValue() == 30L) {
                    this.JobCtx.setExitStatus(GOOD_EXIT_STATUS_READ);
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (this.RPWString.equals("READ_SKIP")) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) continue;
                if (metrics[i].getValue() == (long)this.skipNum) {
                    this.JobCtx.setExitStatus(GOOD_EXIT_STATUS_READ);
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (this.RPWString.equals("PROCESS")) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) continue;
                if (metrics[i].getValue() == (long)this.skipNum) {
                    this.JobCtx.setExitStatus("GOOD PROCESS METRICS RESULT");
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (this.RPWString.equals("WRITE")) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) continue;
                if (metrics[i].getValue() == (long)(30 - this.skipNum)) {
                    this.JobCtx.setExitStatus(GOOD_EXIT_STATUS);
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (!this.RPWString.equals("WRITE_SKIP") || !metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            if (metrics[i].getValue() == (long)this.skipNum) {
                this.JobCtx.setExitStatus(GOOD_EXIT_STATUS);
                continue;
            }
            this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
        }
    }
}

