/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.Decider;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@Named
public class DeciderTestsDecider
implements Decider,
StatusConstants {
    public static final String SPECIAL_EXIT_STATUS = "SpecialExitStatus";
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="SpecialExitStatus")
    String specialExitStatus;

    public String decide(StepExecution[] stepExecutions) throws Exception {
        if (stepExecutions.length != 1) {
            throw new IllegalStateException("Expecting stepExecutions array of size 1, found one of size = " + stepExecutions.length);
        }
        for (StepExecution stepExec : stepExecutions) {
            if (stepExec == null) {
                throw new Exception("Null StepExecution from split.");
            }
            if (stepExec.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) continue;
            throw new Exception("All step executions must be compelete before transitioning to a decider.");
        }
        StepExecution stepExec = stepExecutions[0];
        String coreExitStatus = this.coreExitStatus(stepExec);
        Integer count = (Integer)this.jobCtx.getTransientUserData();
        String retVal = count.toString() + ":" + coreExitStatus;
        return retVal;
    }

    private String coreExitStatus(StepExecution stepExec) {
        String action = (String)((Object)stepExec.getPersistentUserData());
        String currentExitStatus = stepExec.getExitStatus();
        if (currentExitStatus.equals("STEP:ES:Good")) {
            return action;
        }
        return this.specialExitStatus;
    }
}

