/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public interface ICoreTextFileBufferProvider {
    public void connect(IProgressMonitor var1) throws CoreException;

    public void disconnect(IProgressMonitor var1) throws CoreException;

    public ITextFileBuffer getBuffer();

    public ITextFileBufferManager getBufferManager();

    public static ICoreTextFileBufferProvider forLocation(final IPath location, final LocationKind locationKind, final ITextFileBufferManager bufferManager) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (locationKind == null) {
            throw new IllegalArgumentException();
        }
        if (bufferManager == null) {
            throw new IllegalArgumentException();
        }
        return new ICoreTextFileBufferProvider(){

            @Override
            public void connect(IProgressMonitor monitor) throws CoreException {
                bufferManager.connect(location, locationKind, monitor);
            }

            @Override
            public void disconnect(IProgressMonitor monitor) throws CoreException {
                bufferManager.disconnect(location, locationKind, monitor);
            }

            @Override
            public ITextFileBuffer getBuffer() {
                return bufferManager.getTextFileBuffer(location, locationKind);
            }

            @Override
            public ITextFileBufferManager getBufferManager() {
                return bufferManager;
            }
        };
    }

    public static ICoreTextFileBufferProvider forFileStore(final IFileStore fileStore, final ITextFileBufferManager bufferManager) {
        if (fileStore == null) {
            throw new IllegalArgumentException();
        }
        if (bufferManager == null) {
            throw new IllegalArgumentException();
        }
        return new ICoreTextFileBufferProvider(){

            @Override
            public void connect(IProgressMonitor monitor) throws CoreException {
                bufferManager.connectFileStore(fileStore, monitor);
            }

            @Override
            public void disconnect(IProgressMonitor monitor) throws CoreException {
                bufferManager.disconnectFileStore(fileStore, monitor);
            }

            @Override
            public ITextFileBuffer getBuffer() {
                return bufferManager.getFileStoreTextFileBuffer(fileStore);
            }

            @Override
            public ITextFileBufferManager getBufferManager() {
                return bufferManager;
            }
        };
    }
}

