/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.BezierSpline;
import de.cau.cs.kieler.core.math.CubicSplineInterpolator;
import de.cau.cs.kieler.core.math.ISplineInterpolator;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplineEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final double LAYER_SPACE_FAC = 0.2;
    private static final double MINIMAL_ANGLE = 1.0471975511965976;
    private static final int HIGH_LIMIT = 7;
    private static final int MID_LIMIT = 5;
    private static final int SMALL_OFFSET = 2;
    private static final int BIG_OFFSET = 3;
    private static final double VERTICAL_CHANGE = 4.0;
    private static final int MINIMAL_POINTS_HANDLES = 4;
    private static final double SMOOTHNESS_FACTOR = 0.3;
    private static final double MAX_DISTANCE = 0.75;
    private ISplineInterpolator interpolator = new CubicSplineInterpolator();

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return null;
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Spline edge routing", 1.0f);
        double spacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        float edgeSpaceFac = ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double xpos = 0.0;
        double layerSpacing = 0.0;
        for (Layer layer : layeredGraph) {
            layer.placeNodes(xpos);
            double maxVertDiff = 0.0;
            for (LNode node : layer) {
                for (LPort port : node.getPorts(PortType.OUTPUT)) {
                    double sourcePos = port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
                    for (LPort targetPort : port.getSuccessorPorts()) {
                        if (targetPort.getNode().getLayer() == node.getLayer()) continue;
                        double targetPos = targetPort.getNode().getPosition().y + targetPort.getPosition().y + targetPort.getAnchor().y;
                        maxVertDiff = KielerMath.maxd((double[])new double[]{maxVertDiff, targetPos - sourcePos, sourcePos - targetPos});
                    }
                }
            }
            layerSpacing = spacing + 0.2 * (double)edgeSpaceFac * maxVertDiff;
            xpos += layer.getSize().x + layerSpacing;
        }
        layeredGraph.getSize().x = xpos - layerSpacing;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (node.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) continue;
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (edge.getTarget().getNode().getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
                            this.processLongEdge(edge);
                            continue;
                        }
                        this.processShortEdge(edge);
                    }
                }
            }
        }
        this.getMonitor().done();
    }

    private void processShortEdge(LEdge edge) {
        LPort start = edge.getSource();
        LPort end = edge.getTarget();
        KVector startVec = start.getAbsoluteAnchor();
        KVector endVec = end.getAbsoluteAnchor();
        KVector startToEnd = KVector.diff((KVector)endVec, (KVector)startVec);
        double radians = startToEnd.toRadians();
        if (radians < 1.0471975511965976 || radians > 2.0943951023931957) {
            BezierSpline spline = this.generateShortSpline(startVec, endVec);
            KVector[] kVectorArray = spline.getInnerPoints();
            int n = kVectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                KVector v = kVectorArray[n2];
                edge.getBendPoints().add((Object)v);
                ++n2;
            }
        }
    }

    private void processLongEdge(LEdge edge) {
        LEdge intermediateEdge = edge;
        KVectorChain points = new KVectorChain();
        points.add((Object)edge.getSource().getAbsoluteAnchor());
        KVector startTangent = edge.getTarget().getAbsoluteAnchor().sub((KVector)points.getFirst()).normalize();
        do {
            LPort targetPort = intermediateEdge.getTarget();
            for (LPort iterPort : targetPort.getNode().getPorts()) {
                if (iterPort.getOutgoingEdges().size() <= 0) continue;
                intermediateEdge = iterPort.getOutgoingEdges().get(0);
                break;
            }
            points.add((Object)targetPort.getAbsoluteAnchor());
        } while (intermediateEdge.getTarget().getNode().getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE);
        points.add((Object)intermediateEdge.getTarget().getAbsoluteAnchor());
        KVector endTangent = intermediateEdge.getSource().getAbsoluteAnchor().sub((KVector)points.getLast()).normalize();
        BezierSpline spline = this.generateSpline((LinkedList<KVector>)points, startTangent, endTangent.negate());
        spline = this.optimizeSpline(spline);
        KVector[] kVectorArray = spline.getInnerPoints();
        int n = kVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            KVector v = kVectorArray[n2];
            edge.getBendPoints().add((Object)v);
            ++n2;
        }
    }

    private BezierSpline optimizeSpline(BezierSpline spline) {
        if (spline.getBasePoints().length >= 4 && this.isLongStraightSpline(spline)) {
            int offset;
            KVector[] basePoints = spline.getBasePoints();
            int n = basePoints.length - 1;
            int n2 = offset = n >= 7 ? 3 : 2;
            if (n < 5) {
                offset = 1;
            }
            KVector start = spline.getStartPoint();
            KVector end = spline.getEndPoint();
            LinkedList<KVector> newPoints = new LinkedList<KVector>();
            newPoints.add(start);
            if (n >= 5) {
                KVector intermediateLeft = basePoints[1].clone();
                intermediateLeft.y += (start.y - intermediateLeft.y) / 4.0;
                newPoints.add(intermediateLeft);
            }
            KVector bendLeft = null;
            if (n >= 5) {
                bendLeft = basePoints[offset].clone();
                newPoints.add(bendLeft);
            }
            KVector bendRight = basePoints[n - offset].clone();
            newPoints.add(bendRight);
            if (n >= 5) {
                KVector intermediateRight = basePoints[n - 1].clone();
                intermediateRight.y += (end.y - intermediateRight.y) / 4.0;
                newPoints.add(intermediateRight);
            }
            newPoints.add(end);
            KVector test = null;
            if (bendLeft == null) {
                test = bendRight.clone();
            }
            KVector startTangent = KVector.diff((KVector)(bendLeft == null ? test : bendLeft), (KVector)start).normalize();
            KVector endTangent = KVector.diff((KVector)bendRight, (KVector)end).normalize().negate();
            return this.generateSpline(newPoints, startTangent, endTangent);
        }
        return spline;
    }

    private boolean isLongStraightSpline(BezierSpline spline) {
        KVector start = spline.getStartPoint();
        KVector end = spline.getEndPoint();
        Integer y = null;
        KVector[] kVectorArray = spline.getBasePoints();
        int n = kVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            KVector pt = kVectorArray[n2];
            if (pt != start && pt != end) {
                if (y == null) {
                    y = (int)pt.y;
                } else if ((int)pt.y != y) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public BezierSpline generateSpline(LinkedList<KVector> pArray, KVector vectorQ, KVector vectorS) {
        BezierSpline spline = vectorQ == null || vectorS == null ? this.interpolator.interpolatePoints(pArray) : this.interpolator.interpolatePoints(pArray, vectorQ, vectorS, true);
        if (pArray.size() > 2) {
            this.removeFunnyCycles(spline);
        }
        return spline;
    }

    private void removeFunnyCycles(BezierSpline spline) {
        ListIterator listIt = spline.getCurves().listIterator();
        while (listIt.hasNext()) {
            KVector v1;
            BezierSpline.BezierCurve tempCurve;
            KVector v;
            BezierSpline.BezierCurve curve = (BezierSpline.BezierCurve)listIt.next();
            double dist = KVector.distance((KVector)curve.start, (KVector)curve.end);
            double distFst = KVector.distance((KVector)curve.start, (KVector)curve.fstControlPnt);
            double distSnd = KVector.distance((KVector)curve.end, (KVector)curve.sndControlPnt);
            if (distFst > dist * 0.75) {
                v = KVector.diff((KVector)curve.fstControlPnt, (KVector)curve.start);
                v.scaleToLength(dist * 0.3);
                curve.fstControlPnt = KVector.sum((KVector[])new KVector[]{curve.start, v});
                if (listIt.hasPrevious()) {
                    listIt.previous();
                    if (listIt.hasPrevious()) {
                        tempCurve = (BezierSpline.BezierCurve)listIt.previous();
                        v1 = KVector.diff((KVector)tempCurve.sndControlPnt, (KVector)tempCurve.end);
                        v1.scaleToLength(dist * 0.3);
                        tempCurve.sndControlPnt = KVector.sum((KVector[])new KVector[]{tempCurve.end, v1});
                        listIt.next();
                    }
                    listIt.next();
                }
            }
            if (!(distSnd > dist * 0.75)) continue;
            v = KVector.diff((KVector)curve.sndControlPnt, (KVector)curve.end);
            v.scaleToLength(dist * 0.3);
            curve.sndControlPnt = KVector.sum((KVector[])new KVector[]{curve.end, v});
            if (!listIt.hasNext()) continue;
            tempCurve = (BezierSpline.BezierCurve)listIt.next();
            v1 = KVector.diff((KVector)tempCurve.fstControlPnt, (KVector)tempCurve.start);
            v1.scaleToLength(dist * 0.3);
            tempCurve.fstControlPnt = KVector.sum((KVector[])new KVector[]{tempCurve.start, v1});
            listIt.previous();
        }
    }

    public BezierSpline generateShortSpline(KVector q, KVector s) {
        double widthdiff = Math.abs(q.x - s.x);
        KVector startTan = new KVector(widthdiff, 0.0);
        KVector endTan = new KVector(widthdiff, 0.0);
        BezierSpline spline = this.interpolator.interpolatePoints(new KVector[]{q, s}, startTan, endTan, false);
        return spline;
    }
}

