/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearSegmentsNodePlacer
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(4, LayoutProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private static final Property<Integer> INPUT_PRIO = new Property("linearSegments.inputPrio", (Object)0);
    private static final Property<Integer> OUTPUT_PRIO = new Property("linearSegments.outputPrio", (Object)0);
    private LinearSegment[] linearSegments;
    private static final double THRESHOLD_FACTOR = 20.0;
    private static final int PENDULUM_ITERS = 4;
    private static final int FINAL_ITERS = 3;
    private static final double DEFLECTION_DAMP = 0.3;
    private static final double OVERLAP_DETECT = 0.01;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(Properties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Linear segments node placement", 1.0f);
        this.sortLinearSegments(layeredGraph);
        this.createUnbalancedPlacement(layeredGraph);
        this.balancePlacement(layeredGraph);
        this.postProcess(layeredGraph);
        double minY = 0.0;
        double maxY = 0.0;
        for (Layer layer : layeredGraph) {
            KVector layerSize = layer.getSize();
            LNode firstNode = layer.getNodes().get(0);
            double top = firstNode.getPosition().y - firstNode.getMargin().top;
            LNode lastNode = layer.getNodes().get(layer.getNodes().size() - 1);
            double bottom = lastNode.getPosition().y + lastNode.getSize().y + lastNode.getMargin().bottom;
            layerSize.y = bottom - top;
            minY = Math.min(minY, top);
            maxY = Math.max(maxY, bottom);
        }
        layeredGraph.getSize().y = maxY - minY;
        layeredGraph.getOffset().y -= minY;
        this.linearSegments = null;
        this.getMonitor().done();
    }

    private LinearSegment[] sortLinearSegments(LGraph layeredGraph) {
        LinkedList<LinearSegment> segmentList = new LinkedList<LinearSegment>();
        for (Layer layer : layeredGraph) {
            for (Object node : layer) {
                ((LNode)node).id = -1;
                int inprio = Integer.MIN_VALUE;
                int outprio = Integer.MIN_VALUE;
                for (LPort port : ((LNode)node).getPorts()) {
                    int prio;
                    for (LEdge edge : port.getIncomingEdges()) {
                        prio = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                        inprio = Math.max(inprio, prio);
                    }
                    for (LEdge edge : port.getOutgoingEdges()) {
                        prio = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                        outprio = Math.max(outprio, prio);
                    }
                }
                node.setProperty(INPUT_PRIO, (Object)inprio);
                node.setProperty(OUTPUT_PRIO, (Object)outprio);
            }
        }
        int nextLinearSegmentID = 0;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (node.id >= 0) continue;
                LinearSegment segment = new LinearSegment();
                segment.id = nextLinearSegmentID++;
                this.fillSegment(node, segment);
                segmentList.add(segment);
            }
        }
        ArrayList<List<LinearSegment>> outgoingList = new ArrayList<List<LinearSegment>>(segmentList.size());
        ArrayList<Integer> incomingCountList = new ArrayList<Integer>(segmentList.size());
        int i = 0;
        while (i < segmentList.size()) {
            outgoingList.add(new LinkedList());
            incomingCountList.add(0);
            ++i;
        }
        this.createDependencyGraphEdges(layeredGraph, segmentList, outgoingList, incomingCountList);
        LinearSegment[] segments = segmentList.toArray(new LinearSegment[segmentList.size()]);
        List[] outgoing = outgoingList.toArray(new List[outgoingList.size()]);
        int[] incomingCount = new int[incomingCountList.size()];
        int i2 = 0;
        while (i2 < incomingCount.length) {
            incomingCount[i2] = (Integer)incomingCountList.get(i2);
            ++i2;
        }
        int nextRank = 0;
        LinkedList<LinearSegment> noIncoming = new LinkedList<LinearSegment>();
        int i3 = 0;
        while (i3 < segments.length) {
            if (incomingCount[i3] == 0) {
                noIncoming.add(segments[i3]);
            }
            ++i3;
        }
        int[] newRanks = new int[segments.length];
        while (!noIncoming.isEmpty()) {
            LinearSegment segment = (LinearSegment)noIncoming.remove(0);
            newRanks[((LinearSegment)segment).id] = nextRank++;
            while (!outgoing[segment.id].isEmpty()) {
                LinearSegment target = (LinearSegment)outgoing[segment.id].remove(0);
                int n = target.id;
                incomingCount[n] = incomingCount[n] - 1;
                if (incomingCount[target.id] != 0) continue;
                noIncoming.add(target);
            }
        }
        this.linearSegments = new LinearSegment[segments.length];
        int i4 = 0;
        while (i4 < segments.length) {
            assert (outgoing[i4].isEmpty());
            LinearSegment ls = segments[i4];
            int rank = newRanks[i4];
            this.linearSegments[rank] = ls;
            ls.id = rank;
            for (LNode node : ls.nodes) {
                node.id = rank;
            }
            ++i4;
        }
        return this.linearSegments;
    }

    private void createDependencyGraphEdges(LGraph layeredGraph, List<LinearSegment> segmentList, List<List<LinearSegment>> outgoingList, List<Integer> incomingCountList) {
        int nextLinearSegmentID = segmentList.size();
        int layerIndex = 0;
        for (Layer layer : layeredGraph) {
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            Iterator<LNode> nodeIter = nodes.iterator();
            int indexInLayer = 0;
            LNode previousNode = null;
            LNode currentNode = nodeIter.next();
            LinearSegment currentSegment = null;
            while (currentNode != null) {
                currentSegment = segmentList.get(currentNode.id);
                if (currentSegment.indexInLastLayer >= 0) {
                    LinearSegment cycleSegment = null;
                    ListIterator<LNode> cycleNodesIter = layer.getNodes().listIterator(indexInLayer + 1);
                    while (cycleNodesIter.hasNext()) {
                        LNode cycleNode = (LNode)cycleNodesIter.next();
                        cycleSegment = segmentList.get(cycleNode.id);
                        if (cycleSegment.lastLayer == currentSegment.lastLayer && cycleSegment.indexInLastLayer < currentSegment.indexInLastLayer) break;
                        cycleSegment = null;
                    }
                    if (cycleSegment != null) {
                        if (previousNode != null) {
                            incomingCountList.set(currentNode.id, incomingCountList.get(currentNode.id) - 1);
                            outgoingList.get(previousNode.id).remove(currentSegment);
                        }
                        currentSegment = currentSegment.split(currentNode, nextLinearSegmentID++);
                        segmentList.add(currentSegment);
                        outgoingList.add(new LinkedList());
                        if (previousNode != null) {
                            outgoingList.get(previousNode.id).add(currentSegment);
                            incomingCountList.add(1);
                        } else {
                            incomingCountList.add(0);
                        }
                    }
                }
                LNode nextNode = null;
                if (nodeIter.hasNext()) {
                    nextNode = nodeIter.next();
                    LinearSegment nextSegment = segmentList.get(nextNode.id);
                    outgoingList.get(currentNode.id).add(nextSegment);
                    incomingCountList.set(nextNode.id, incomingCountList.get(nextNode.id) + 1);
                }
                currentSegment.lastLayer = layerIndex;
                currentSegment.indexInLastLayer = indexInLayer++;
                previousNode = currentNode;
                currentNode = nextNode;
            }
            ++layerIndex;
        }
        if (((Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE)).booleanValue()) {
            LinearSegmentsNodePlacer.writeDebugGraph(layeredGraph, segmentList, outgoingList);
        }
    }

    private boolean fillSegment(LNode node, LinearSegment segment) {
        if (node.id >= 0) {
            return false;
        }
        node.id = segment.id;
        segment.nodes.add(node);
        NodeType nodeType = (NodeType)((Object)node.getProperty(Properties.NODE_TYPE));
        if (nodeType == NodeType.LONG_EDGE || nodeType == NodeType.NORTH_SOUTH_PORT || nodeType == NodeType.COMPOUND_SIDE) {
            for (LPort sourcePort : node.getPorts()) {
                for (LPort targetPort : sourcePort.getSuccessorPorts()) {
                    LNode targetNode = targetPort.getNode();
                    NodeType targetNodeType = (NodeType)((Object)targetNode.getProperty(Properties.NODE_TYPE));
                    if (node.getLayer() == targetNode.getLayer() || targetNodeType != NodeType.LONG_EDGE && targetNodeType != NodeType.NORTH_SOUTH_PORT && targetNodeType != NodeType.COMPOUND_SIDE || !this.fillSegment(targetNode, segment)) continue;
                    return true;
                }
            }
        }
        return true;
    }

    private void createUnbalancedPlacement(LGraph layeredGraph) {
        float normalSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        float smallSpacing = normalSpacing * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        int[] nodeCount = new int[layeredGraph.getLayers().size()];
        boolean[] recentNodeNormal = new boolean[layeredGraph.getLayers().size()];
        LinearSegment[] linearSegmentArray = this.linearSegments;
        int n = this.linearSegments.length;
        int n2 = 0;
        while (n2 < n) {
            LinearSegment segment = linearSegmentArray[n2];
            double uppermostPlace = 0.0;
            for (LNode node : segment.nodes) {
                int layerIndex;
                int n3 = layerIndex = node.getLayer().getIndex();
                nodeCount[n3] = nodeCount[n3] + 1;
                float space = 0.0f;
                if (nodeCount[layerIndex] > 0) {
                    space = recentNodeNormal[layerIndex] && node.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL ? normalSpacing : smallSpacing;
                }
                uppermostPlace = Math.max(uppermostPlace, node.getLayer().getSize().y + (double)space);
            }
            for (LNode node : segment.nodes) {
                node.getPosition().y = uppermostPlace + node.getMargin().top;
                Layer layer = node.getLayer();
                layer.getSize().y = uppermostPlace + node.getMargin().top + node.getSize().y + node.getMargin().bottom;
                if (!((Boolean)node.getProperty(LayoutOptions.HYPERNODE)).booleanValue()) {
                    layer.getSize().x = Math.max(layer.getSize().x, node.getSize().x + node.getMargin().left + node.getMargin().right);
                }
                boolean bl = recentNodeNormal[layer.getIndex()] = node.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
            }
            ++n2;
        }
    }

    private void balancePlacement(LGraph layeredGraph) {
        float spacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        float smallSpacing = spacing * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        int thoroughness = (Integer)layeredGraph.getProperty(Properties.THOROUGHNESS);
        int pendulumIters = 4;
        int finalIters = 3;
        double threshold = 20.0 / (double)thoroughness;
        boolean ready = false;
        Mode mode = Mode.FORW_PENDULUM;
        double lastTotalDeflection = 2.147483647E9;
        do {
            boolean merged;
            boolean incoming = mode != Mode.BACKW_PENDULUM;
            boolean outgoing = mode != Mode.FORW_PENDULUM;
            double totalDeflection = 0.0;
            LinearSegment[] linearSegmentArray = this.linearSegments;
            int n = this.linearSegments.length;
            int n2 = 0;
            while (n2 < n) {
                LinearSegment segment = linearSegmentArray[n2];
                segment.refSegment = null;
                this.calcDeflection(segment, incoming, outgoing);
                totalDeflection += Math.abs(segment.deflection);
                ++n2;
            }
            while (merged = this.mergeRegions(layeredGraph, spacing, smallSpacing)) {
            }
            LinearSegment[] linearSegmentArray2 = this.linearSegments;
            int n3 = this.linearSegments.length;
            n = 0;
            while (n < n3) {
                LinearSegment segment = linearSegmentArray2[n];
                double deflection = segment.region().deflection;
                if (deflection != 0.0) {
                    for (LNode node : segment.nodes) {
                        node.getPosition().y += deflection;
                    }
                }
                ++n;
            }
            if (mode == Mode.FORW_PENDULUM || mode == Mode.BACKW_PENDULUM) {
                if (--pendulumIters <= 0 && (totalDeflection < lastTotalDeflection || -pendulumIters > thoroughness)) {
                    mode = Mode.RUBBER;
                    lastTotalDeflection = 2.147483647E9;
                    continue;
                }
                if (mode == Mode.FORW_PENDULUM) {
                    mode = Mode.BACKW_PENDULUM;
                    lastTotalDeflection = totalDeflection;
                    continue;
                }
                mode = Mode.FORW_PENDULUM;
                lastTotalDeflection = totalDeflection;
                continue;
            }
            ready = totalDeflection >= lastTotalDeflection || lastTotalDeflection - totalDeflection < threshold;
            lastTotalDeflection = totalDeflection;
            if (!ready) continue;
            --finalIters;
        } while (!ready || finalIters > 0);
    }

    private void calcDeflection(LinearSegment segment, boolean incoming, boolean outgoing) {
        double segmentDeflection = 0.0;
        int nodeWeightSum = 0;
        for (LNode node : segment.nodes) {
            double nodeDeflection = 0.0;
            int edgeWeightSum = 0;
            int inputPrio = incoming ? (Integer)node.getProperty((IProperty)INPUT_PRIO) : Integer.MIN_VALUE;
            int outputPrio = outgoing ? (Integer)node.getProperty((IProperty)OUTPUT_PRIO) : Integer.MIN_VALUE;
            int minPrio = Math.max(inputPrio, outputPrio);
            for (LPort port : node.getPorts()) {
                int prio;
                int otherPrio;
                LNode otherNode;
                LPort otherPort;
                double portpos = node.getPosition().y + port.getPosition().y + port.getAnchor().y;
                if (outgoing) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        otherPort = edge.getTarget();
                        otherNode = otherPort.getNode();
                        if (segment == this.linearSegments[otherNode.id]) continue;
                        otherPrio = Math.max((Integer)otherNode.getProperty((IProperty)INPUT_PRIO), (Integer)otherNode.getProperty((IProperty)OUTPUT_PRIO));
                        prio = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                        if (prio < minPrio || prio < otherPrio) continue;
                        nodeDeflection += otherNode.getPosition().y + otherPort.getPosition().y + otherPort.getAnchor().y - portpos;
                        ++edgeWeightSum;
                    }
                }
                if (!incoming) continue;
                for (LEdge edge : port.getIncomingEdges()) {
                    otherPort = edge.getSource();
                    otherNode = otherPort.getNode();
                    if (segment == this.linearSegments[otherNode.id]) continue;
                    otherPrio = Math.max((Integer)otherNode.getProperty((IProperty)INPUT_PRIO), (Integer)otherNode.getProperty((IProperty)OUTPUT_PRIO));
                    prio = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                    if (prio < minPrio || prio < otherPrio) continue;
                    nodeDeflection += otherNode.getPosition().y + otherPort.getPosition().y + otherPort.getAnchor().y - portpos;
                    ++edgeWeightSum;
                }
            }
            if (edgeWeightSum <= 0) continue;
            segmentDeflection += nodeDeflection / (double)edgeWeightSum;
            ++nodeWeightSum;
        }
        if (nodeWeightSum > 0) {
            segment.deflection = 0.3 * segmentDeflection / (double)nodeWeightSum;
            segment.weight = nodeWeightSum;
        } else {
            segment.deflection = 0.0;
            segment.weight = 0;
        }
    }

    private boolean mergeRegions(LGraph layeredGraph, float normalSpacing, float smallSpacing) {
        boolean changed = false;
        double threshold = 0.01 * (double)normalSpacing;
        for (Layer layer : layeredGraph) {
            Iterator<LNode> nodeIter = layer.getNodes().iterator();
            LNode node1 = nodeIter.next();
            LinearSegment region1 = this.linearSegments[node1.id].region();
            boolean isNode1Normal = node1.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
            while (nodeIter.hasNext()) {
                boolean isNode2Normal;
                LNode node2 = nodeIter.next();
                LinearSegment region2 = this.linearSegments[node2.id].region();
                boolean bl = isNode2Normal = node2.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
                if (region1 != region2) {
                    double node2Extent;
                    double spacing = isNode1Normal && isNode2Normal ? normalSpacing : smallSpacing;
                    double node1Extent = node1.getPosition().y + node1.getSize().y + node1.getMargin().bottom + region1.deflection + spacing;
                    if (node1Extent > (node2Extent = node2.getPosition().y - node2.getMargin().top + region2.deflection) + threshold) {
                        int weightSum = region1.weight + region2.weight;
                        assert (weightSum > 0);
                        region2.deflection = ((double)region2.weight * region2.deflection + (double)region1.weight * region1.deflection) / (double)weightSum;
                        region2.weight = weightSum;
                        region1.refSegment = region2;
                        changed = true;
                    }
                }
                node1 = node2;
                region1 = region2;
                isNode1Normal = isNode2Normal;
            }
        }
        return changed;
    }

    private void postProcess(LGraph layeredGraph) {
        float normalSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        float smallSpacing = normalSpacing * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        LinearSegment[] linearSegmentArray = this.linearSegments;
        int n = this.linearSegments.length;
        int n2 = 0;
        while (n2 < n) {
            LinearSegment segment = linearSegmentArray[n2];
            double minRoomAbove = 2.147483647E9;
            double minRoomBelow = 2.147483647E9;
            for (LNode node : segment.nodes) {
                double roomBelow;
                double roomAbove;
                float spacing;
                boolean isNeighborNormal;
                LNode neighbor;
                boolean isNodeNormal;
                int index = node.getIndex();
                boolean bl = isNodeNormal = node.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
                if (index > 0) {
                    neighbor = node.getLayer().getNodes().get(index - 1);
                    isNeighborNormal = neighbor.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
                    spacing = isNodeNormal && isNeighborNormal ? normalSpacing : smallSpacing;
                    roomAbove = node.getPosition().y - node.getMargin().top - (neighbor.getPosition().y + neighbor.getSize().y + neighbor.getMargin().bottom + (double)spacing);
                } else {
                    roomAbove = node.getPosition().y - node.getMargin().top;
                }
                minRoomAbove = Math.min(roomAbove, minRoomAbove);
                if (index < node.getLayer().getNodes().size() - 1) {
                    neighbor = node.getLayer().getNodes().get(index + 1);
                    isNeighborNormal = neighbor.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL;
                    spacing = isNodeNormal && isNeighborNormal ? normalSpacing : smallSpacing;
                    roomBelow = neighbor.getPosition().y - neighbor.getMargin().top - (node.getPosition().y + node.getSize().y + node.getMargin().bottom + (double)spacing);
                } else {
                    roomBelow = 2.0 * node.getPosition().y;
                }
                minRoomBelow = Math.min(roomBelow, minRoomBelow);
            }
            double minDisplacement = 2.147483647E9;
            boolean foundPlace = false;
            LNode firstNode = (LNode)segment.nodes.get(0);
            for (LPort target : firstNode.getPorts()) {
                double pos = firstNode.getPosition().y + target.getPosition().y + target.getAnchor().y;
                for (LEdge edge : target.getIncomingEdges()) {
                    LPort source = edge.getSource();
                    double d = source.getNode().getPosition().y + source.getPosition().y + source.getAnchor().y - pos;
                    if (!(Math.abs(d) < Math.abs(minDisplacement))) continue;
                    double d2 = Math.abs(d);
                    double d3 = d < 0.0 ? minRoomAbove : minRoomBelow;
                    if (!(d2 < d3)) continue;
                    minDisplacement = d;
                    foundPlace = true;
                }
            }
            LNode lastNode = (LNode)segment.nodes.get(segment.nodes.size() - 1);
            for (LPort source : lastNode.getPorts()) {
                double pos = lastNode.getPosition().y + source.getPosition().y + source.getAnchor().y;
                for (LEdge edge : source.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double d = target.getNode().getPosition().y + target.getPosition().y + target.getAnchor().y - pos;
                    if (!(Math.abs(d) < Math.abs(minDisplacement))) continue;
                    double d4 = Math.abs(d);
                    double d5 = d < 0.0 ? minRoomAbove : minRoomBelow;
                    if (!(d4 < d5)) continue;
                    minDisplacement = d;
                    foundPlace = true;
                }
            }
            if (foundPlace && minDisplacement != 0.0) {
                for (LNode node : segment.nodes) {
                    node.getPosition().y += minDisplacement;
                }
            }
            ++n2;
        }
    }

    private static void writeDebugGraph(LGraph layeredGraph, List<LinearSegment> segmentList, List<List<LinearSegment>> outgoingList) {
        try {
            Writer writer = LinearSegmentsNodePlacer.createWriter(layeredGraph);
            writer.write("digraph {\n");
            Iterator<LinearSegment> segmentIterator = segmentList.iterator();
            Iterator<List<LinearSegment>> successorsIterator = outgoingList.iterator();
            while (segmentIterator.hasNext()) {
                LinearSegment segment = segmentIterator.next();
                List<LinearSegment> successors = successorsIterator.next();
                writer.write("  " + segment.hashCode() + "[label=\"" + segment + "\"]\n");
                for (LinearSegment successor : successors) {
                    writer.write("  " + segment.hashCode() + "->" + successor.hashCode() + "\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Writer createWriter(LGraph layeredGraph) throws IOException {
        String path = Util.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(Util.getDebugOutputFileBaseName(layeredGraph)) + "linseg-dep";
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinearSegment
    implements Comparable<LinearSegment> {
        private List<LNode> nodes = new LinkedList<LNode>();
        private int id;
        private int indexInLastLayer = -1;
        private int lastLayer = -1;
        private double deflection;
        private int weight;
        private LinearSegment refSegment;

        private LinearSegment() {
        }

        LinearSegment region() {
            LinearSegment seg = this;
            while (seg.refSegment != null) {
                seg = seg.refSegment;
            }
            return seg;
        }

        LinearSegment split(LNode node, int newId) {
            int nodeIndex = this.nodes.indexOf(node);
            LinearSegment newSegment = new LinearSegment();
            newSegment.id = newId;
            ListIterator<LNode> iterator = this.nodes.listIterator(nodeIndex);
            while (iterator.hasNext()) {
                LNode movedNode = iterator.next();
                movedNode.id = newId;
                newSegment.nodes.add(movedNode);
                iterator.remove();
            }
            return newSegment;
        }

        public String toString() {
            return "ls" + this.nodes.toString();
        }

        @Override
        public int compareTo(LinearSegment other) {
            return this.id - other.id;
        }

        public boolean equals(Object object) {
            if (object instanceof LinearSegment) {
                LinearSegment other = (LinearSegment)object;
                return this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        FORW_PENDULUM,
        BACKW_PENDULUM,
        RUBBER;

    }
}

