/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BKNodePlacer
extends AbstractAlgorithm
implements ILayoutPhase {
    private List<LEdge> markedEdges;
    private float normalSpacing;
    private float smallSpacing;
    private boolean debug = false;
    private static final double NORTH_SOUTH_SPACING = 10.0;
    private boolean addBalancedLayout = false;
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(4, LayoutProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(Properties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Brandes & Koepf node placement", 1.0f);
        this.markedEdges = new LinkedList<LEdge>();
        int nodeCount = 0;
        for (Layer layer : layeredGraph) {
            nodeCount += layer.getNodes().size();
        }
        BKAlignedLayout lefttop = new BKAlignedLayout(nodeCount, VDirection.LEFT, HDirection.TOP);
        BKAlignedLayout righttop = new BKAlignedLayout(nodeCount, VDirection.RIGHT, HDirection.TOP);
        BKAlignedLayout leftbottom = new BKAlignedLayout(nodeCount, VDirection.LEFT, HDirection.BOTTOM);
        BKAlignedLayout rightbottom = new BKAlignedLayout(nodeCount, VDirection.RIGHT, HDirection.BOTTOM);
        this.normalSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        this.smallSpacing = this.normalSpacing * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        this.debug = (Boolean)layeredGraph.getProperty(Properties.DEBUG_MODE);
        this.addBalancedLayout = (Boolean)layeredGraph.getProperty(Properties.EDGE_BENDS) == false;
        this.markConflicts(layeredGraph);
        this.verticalAlignment(layeredGraph, lefttop);
        this.verticalAlignment(layeredGraph, righttop);
        this.verticalAlignment(layeredGraph, leftbottom);
        this.verticalAlignment(layeredGraph, rightbottom);
        this.insideBlockShift(layeredGraph, lefttop);
        this.insideBlockShift(layeredGraph, righttop);
        this.insideBlockShift(layeredGraph, leftbottom);
        this.insideBlockShift(layeredGraph, rightbottom);
        this.horizontalCompaction(layeredGraph, lefttop);
        this.horizontalCompaction(layeredGraph, righttop);
        this.horizontalCompaction(layeredGraph, leftbottom);
        this.horizontalCompaction(layeredGraph, rightbottom);
        if (this.debug) {
            System.out.println("lefttop size is " + lefttop.layoutSize());
            System.out.println("righttop size is " + righttop.layoutSize());
            System.out.println("leftbottom size is " + leftbottom.layoutSize());
            System.out.println("rightbottom size is " + rightbottom.layoutSize());
        }
        BKAlignedLayout chosenLayout = null;
        LinkedList<BKAlignedLayout> layouts = new LinkedList<BKAlignedLayout>();
        layouts.add(lefttop);
        layouts.add(righttop);
        layouts.add(leftbottom);
        layouts.add(rightbottom);
        BKAlignedLayout balanced = new BKAlignedLayout(nodeCount, null, null);
        if (this.addBalancedLayout) {
            chosenLayout = balanced = this.createBalancedLayout(layouts, nodeCount);
        }
        if (!this.addBalancedLayout || !this.checkOrderConstraint(layeredGraph, balanced)) {
            chosenLayout = null;
            for (BKAlignedLayout bal : layouts) {
                if (!this.checkOrderConstraint(layeredGraph, bal)) continue;
                if (chosenLayout == null) {
                    chosenLayout = bal;
                    continue;
                }
                if (!(bal.layoutSize() < chosenLayout.layoutSize())) continue;
                chosenLayout = bal;
            }
        }
        if (chosenLayout == null) {
            chosenLayout = lefttop;
        }
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                node.getPosition().y = chosenLayout.getY().get(node) + chosenLayout.getInnerShift().get(node);
                if (((Boolean)node.getProperty(LayoutOptions.HYPERNODE)).booleanValue()) continue;
                layer.getSize().x = Math.max(layer.getSize().x, node.getSize().x + node.getMargin().left + node.getMargin().right);
            }
        }
        double minY = 0.0;
        double maxY = 0.0;
        for (Layer layer : layeredGraph) {
            KVector layerSize = layer.getSize();
            LNode firstNode = layer.getNodes().get(0);
            double top = firstNode.getPosition().y - firstNode.getMargin().top;
            LNode lastNode = layer.getNodes().get(layer.getNodes().size() - 1);
            double bottom = lastNode.getPosition().y + lastNode.getSize().y + lastNode.getMargin().bottom;
            layerSize.y = bottom - top;
            minY = Math.min(minY, top);
            maxY = Math.max(maxY, bottom);
        }
        layeredGraph.getSize().y = maxY - minY;
        layeredGraph.getOffset().y -= minY;
        if (this.debug) {
            System.out.println(this.getBlocks(chosenLayout));
        }
        this.getMonitor().done();
    }

    private void markConflicts(LGraph layeredGraph) {
        int i = 1;
        while (i <= layeredGraph.getLayers().size() - 2) {
            int k_0 = 0;
            int l = 0;
            int l_1 = 0;
            while (l_1 < this.layerSize(layeredGraph, i + 1)) {
                LNode v_l_i = this.nodeByPosition(layeredGraph, i + 1, l_1);
                if (l_1 == this.layerSize(layeredGraph, i + 1) || this.incidentToInnerSegment(v_l_i, i, i + 1)) {
                    int k_1 = this.layerSize(layeredGraph, i);
                    if (this.incidentToInnerSegment(v_l_i, i, i + 1)) {
                        k_1 = this.allUpperNeighbors(v_l_i).get(0).getIndex();
                    }
                    while (l <= l_1) {
                        LNode v_l = this.nodeByPosition(layeredGraph, i + 1, l);
                        for (LNode upperNeighbor : this.allUpperNeighbors(v_l)) {
                            int k = upperNeighbor.getIndex();
                            if (k >= k_0 && k <= k_1) continue;
                            this.markedEdges.add(this.getEdge(upperNeighbor, v_l));
                        }
                        ++l;
                    }
                    k_0 = k_1;
                }
                ++l_1;
            }
            ++i;
        }
    }

    private void verticalAlignment(LGraph layeredGraph, BKAlignedLayout bal) {
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode v : layer.getNodes()) {
                bal.getRoot().put(v, v);
                bal.getAlign().put(v, v);
                bal.getInnerShift().put(v, 0.0);
                if (v.getProperty(Properties.NODE_TYPE) == NodeType.NORTH_SOUTH_PORT) {
                    bal.getBlockContainsNorthSouth().put(v, true);
                } else {
                    bal.getBlockContainsNorthSouth().put(v, false);
                }
                if (v.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL) {
                    bal.getBlockContainsRegularNode().put(v, true);
                    continue;
                }
                bal.getBlockContainsRegularNode().put(v, false);
            }
        }
        List<Layer> layers = layeredGraph.getLayers();
        if (bal.getHDir() == HDirection.BOTTOM) {
            layers = Arrays.asList(new Layer[layeredGraph.getLayers().size()]);
            Collections.copy(layers, layeredGraph.getLayers());
            Collections.reverse(layers);
        }
        for (Layer layer : layers) {
            int r = -1;
            List<LNode> nodes = layer.getNodes();
            if (bal.getVDir() == VDirection.RIGHT) {
                r = Integer.MAX_VALUE;
                nodes = Arrays.asList(new LNode[layer.getNodes().size()]);
                Collections.copy(nodes, layer.getNodes());
                Collections.reverse(nodes);
            }
            for (LNode v_i_k : nodes) {
                int m;
                List<LNode> neighbors = null;
                neighbors = bal.getHDir() == HDirection.BOTTOM ? this.allLowerNeighbors(v_i_k) : this.allUpperNeighbors(v_i_k);
                if (neighbors.size() <= 0) continue;
                int d = neighbors.size();
                int low = (int)Math.floor(((double)d + 1.0) / 2.0) - 1;
                int high = (int)Math.ceil(((double)d + 1.0) / 2.0) - 1;
                if (bal.getVDir() == VDirection.RIGHT) {
                    m = high;
                    while (m >= low) {
                        LNode u_m;
                        if (bal.getAlign().get(v_i_k).equals(v_i_k) && !this.markedEdges.contains(this.getEdge(u_m = neighbors.get(m), v_i_k)) && r > u_m.getIndex()) {
                            bal.getAlign().put(u_m, v_i_k);
                            bal.getRoot().put(v_i_k, bal.getRoot().get(u_m));
                            bal.getAlign().put(v_i_k, bal.getRoot().get(v_i_k));
                            if (bal.getBlockContainsNorthSouth().get(v_i_k).booleanValue()) {
                                bal.getBlockContainsNorthSouth().put(bal.getRoot().get(v_i_k), true);
                            }
                            if (bal.getBlockContainsRegularNode().get(v_i_k).booleanValue()) {
                                bal.getBlockContainsRegularNode().put(bal.getRoot().get(v_i_k), true);
                            }
                            r = u_m.getIndex();
                        }
                        --m;
                    }
                    continue;
                }
                m = low;
                while (m <= high) {
                    LNode um;
                    if (bal.getAlign().get(v_i_k).equals(v_i_k) && !this.markedEdges.contains(this.getEdge(um = neighbors.get(m), v_i_k)) && r < um.getIndex()) {
                        bal.getAlign().put(um, v_i_k);
                        bal.getRoot().put(v_i_k, bal.getRoot().get(um));
                        bal.getAlign().put(v_i_k, bal.getRoot().get(v_i_k));
                        if (bal.getBlockContainsNorthSouth().get(v_i_k).booleanValue()) {
                            bal.getBlockContainsNorthSouth().put(bal.getRoot().get(v_i_k), true);
                        }
                        if (bal.getBlockContainsRegularNode().get(v_i_k).booleanValue()) {
                            bal.getBlockContainsRegularNode().put(bal.getRoot().get(v_i_k), true);
                        }
                        r = um.getIndex();
                    }
                    ++m;
                }
            }
        }
    }

    private void insideBlockShift(LGraph layeredGraph, BKAlignedLayout bal) {
        HashMap<LNode, List<LNode>> blocks = this.getBlocks(bal);
        for (LNode root : blocks.keySet()) {
            double maximumNodeSize = root.getMargin().top + root.getSize().y + root.getMargin().bottom;
            double lowerBound = root.getMargin().top;
            double upperBound = root.getMargin().top + root.getSize().y + root.getMargin().bottom;
            double postShift = lowerBound;
            LNode current = root;
            LNode next = bal.getAlign().get(root);
            double rootPortPos = root.getMargin().top;
            double rootUpperBound = 0.0;
            LEdge rootEdge = this.getEdge(current, next);
            if (rootEdge != null) {
                rootPortPos = bal.getHDir() == HDirection.BOTTOM ? rootEdge.getTarget().getPosition().y + rootEdge.getTarget().getAnchor().y + current.getMargin().top : rootEdge.getSource().getPosition().y + rootEdge.getSource().getAnchor().y + current.getMargin().top;
                rootUpperBound = current.getMargin().top + current.getSize().y + current.getMargin().bottom - rootPortPos;
                lowerBound = rootPortPos;
                upperBound = rootUpperBound;
            }
            while (next != root) {
                LEdge edge = this.getEdge(current, next);
                double difference = 0.0;
                double portPos = 0.0;
                if (bal.getHDir() == HDirection.BOTTOM) {
                    difference = edge.getTarget().getPosition().y + edge.getTarget().getAnchor().y - edge.getSource().getPosition().y - edge.getSource().getAnchor().y + bal.getInnerShift().get(current);
                    portPos = edge.getSource().getPosition().y + edge.getSource().getAnchor().y + next.getMargin().top;
                } else {
                    difference = edge.getSource().getPosition().y + edge.getSource().getAnchor().y - edge.getTarget().getPosition().y - edge.getTarget().getAnchor().y + bal.getInnerShift().get(current);
                    portPos = edge.getTarget().getPosition().y + edge.getTarget().getAnchor().y + next.getMargin().top;
                }
                double currentLowerBound = portPos;
                double currentUpperBound = next.getMargin().top + next.getSize().y + next.getMargin().bottom - currentLowerBound;
                bal.getInnerShift().put(next, difference);
                if (currentLowerBound > lowerBound) {
                    lowerBound = currentLowerBound;
                }
                if (currentUpperBound > upperBound) {
                    upperBound = currentUpperBound;
                }
                current = next;
                next = bal.getAlign().get(next);
            }
            if (bal.getAlign().get(root) != root) {
                maximumNodeSize = upperBound + lowerBound;
            }
            if (lowerBound > rootPortPos) {
                postShift = lowerBound - rootPortPos;
            }
            bal.getPostShift().put(root, postShift);
            bal.getInnerShift().put(root, bal.getInnerShift().get(root) + postShift);
            current = root;
            next = bal.getAlign().get(root);
            while (next != root) {
                bal.getInnerShift().put(next, bal.getInnerShift().get(next) + postShift);
                current = next;
                next = bal.getAlign().get(next);
            }
            bal.getBlockSize().put(root, maximumNodeSize);
        }
    }

    private void horizontalCompaction(LGraph layeredGraph, BKAlignedLayout bal) {
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                bal.getSink().put(node, node);
                if (bal.getVDir() == VDirection.RIGHT) {
                    bal.getShift().put(node, Double.NEGATIVE_INFINITY);
                    continue;
                }
                bal.getShift().put(node, Double.POSITIVE_INFINITY);
            }
        }
        List<Layer> layers = layeredGraph.getLayers();
        if (bal.getHDir() == HDirection.BOTTOM) {
            layers = Arrays.asList(new Layer[layeredGraph.getLayers().size()]);
            Collections.copy(layers, layeredGraph.getLayers());
            Collections.reverse(layers);
        }
        for (Layer layer : layers) {
            List<LNode> nodes = layer.getNodes();
            if (bal.getVDir() == VDirection.RIGHT) {
                nodes = Arrays.asList(new LNode[layer.getNodes().size()]);
                Collections.copy(nodes, layer.getNodes());
                Collections.reverse(nodes);
            }
            for (LNode v : nodes) {
                if (!bal.getRoot().get(v).equals(v)) continue;
                this.placeBlock(v, bal);
            }
        }
        for (Layer layer : layers) {
            for (LNode v : layer.getNodes()) {
                bal.getY().put(v, bal.getY().get(bal.getRoot().get(v)));
                if (bal.getVDir() == VDirection.RIGHT) {
                    if (!v.equals(bal.getRoot().get(v)) || !(bal.getShift().get(bal.getSink().get(v)) > Double.NEGATIVE_INFINITY)) continue;
                    bal.getY().put(v, bal.getY().get(v) + bal.getShift().get(bal.getSink().get(v)));
                    continue;
                }
                if (!v.equals(bal.getRoot().get(v)) || !(bal.getShift().get(bal.getSink().get(v)) < Double.POSITIVE_INFINITY)) continue;
                bal.getY().put(v, bal.getY().get(v) + bal.getShift().get(bal.getSink().get(v)));
            }
        }
    }

    private void placeBlock(LNode v, BKAlignedLayout bal) {
        if (!bal.getY().containsKey(v)) {
            bal.getY().put(v, 0.0);
            LNode w = v;
            do {
                double spacing;
                if ((bal.getVDir() != VDirection.LEFT || w.getIndex() <= 0) && (bal.getVDir() != VDirection.RIGHT || w.getIndex() >= w.getLayer().getNodes().size() - 1)) continue;
                LNode u = null;
                LNode x = null;
                if (bal.getVDir() == VDirection.RIGHT) {
                    x = w.getLayer().getNodes().get(w.getIndex() + 1);
                    u = bal.getRoot().get(x);
                } else {
                    x = w.getLayer().getNodes().get(w.getIndex() - 1);
                    u = bal.getRoot().get(x);
                }
                this.placeBlock(u, bal);
                if (bal.getSink().get(v).equals(v)) {
                    bal.getSink().put(v, bal.getSink().get(u));
                }
                if (!bal.getSink().get(v).equals(bal.getSink().get(u))) {
                    spacing = this.normalSpacing;
                    if (bal.getVDir() == VDirection.RIGHT) {
                        bal.getShift().put(bal.getSink().get(u), Math.max(bal.getShift().get(bal.getSink().get(u)), bal.getY().get(v) - bal.getY().get(u) + bal.getBlockSize().get(v) + spacing));
                        continue;
                    }
                    bal.getShift().put(bal.getSink().get(u), Math.min(bal.getShift().get(bal.getSink().get(u)), bal.getY().get(v) - bal.getY().get(u) - bal.getBlockSize().get(u) - spacing));
                    continue;
                }
                spacing = this.normalSpacing;
                double wSize = w.getSize().y + w.getMargin().bottom + bal.getInnerShift().get(w);
                double xSize = x.getSize().y + x.getMargin().bottom;
                if (w.getProperty(Properties.NODE_TYPE) == NodeType.NORTH_SOUTH_PORT) {
                    wSize += 10.0;
                }
                if (x.getProperty(Properties.NODE_TYPE) == NodeType.NORTH_SOUTH_PORT) {
                    xSize += 10.0;
                }
                if (!(this.blockContainsNorthSouthDummy(bal, v) && this.blockContainsRegularNode(bal, u) || this.blockContainsNorthSouthDummy(bal, u) && this.blockContainsRegularNode(bal, v) || bal.getBlockSize().get(v) != 0.0 && bal.getBlockSize().get(u) != 0.0)) {
                    spacing = this.smallSpacing;
                }
                if (bal.getVDir() == VDirection.RIGHT) {
                    bal.getY().put(v, Math.min(bal.getY().get(v), bal.getY().get(u) + bal.getInnerShift().get(x) - x.getMargin().top - spacing - wSize));
                    continue;
                }
                bal.getY().put(v, Math.max(bal.getY().get(v), bal.getY().get(u) + bal.getInnerShift().get(x) + x.getMargin().top + spacing + xSize));
            } while ((w = bal.getAlign().get(w)) != v);
        }
    }

    private BKAlignedLayout createBalancedLayout(List<BKAlignedLayout> layouts, int nodeCount) {
        int noOfLayouts = layouts.size();
        BKAlignedLayout balanced = new BKAlignedLayout(nodeCount, null, null);
        double[] width = new double[noOfLayouts];
        double[] min = new double[noOfLayouts];
        double[] max = new double[noOfLayouts];
        int minWidthLayout = 0;
        int i = 0;
        while (i < noOfLayouts) {
            min[i] = 2.147483647E9;
            max[i] = -2.147483648E9;
            ++i;
        }
        i = 0;
        while (i < noOfLayouts) {
            BKAlignedLayout current = layouts.get(i);
            for (double y : current.getY().values()) {
                if (min[i] > y) {
                    min[i] = y;
                }
                if (!(max[i] < y)) continue;
                max[i] = y;
            }
            width[i] = max[i] - min[i];
            if (width[minWidthLayout] > width[i]) {
                minWidthLayout = i;
            }
            ++i;
        }
        double[] shift = new double[noOfLayouts];
        int i2 = 0;
        while (i2 < noOfLayouts) {
            shift[i2] = layouts.get(i2).vdir == VDirection.LEFT ? min[minWidthLayout] - min[i2] : max[minWidthLayout] - max[i2];
            ++i2;
        }
        double[] calculatedYs = new double[noOfLayouts];
        for (LNode node : layouts.get(0).getY().keySet()) {
            int i3 = 0;
            while (i3 < noOfLayouts) {
                calculatedYs[i3] = layouts.get(i3).getY().get(node) + shift[i3];
                ++i3;
            }
            Arrays.sort(calculatedYs);
            balanced.getY().put(node, (calculatedYs[1] + calculatedYs[2]) / 2.0);
            balanced.getInnerShift().put(node, layouts.get(minWidthLayout).getInnerShift().get(node));
        }
        return balanced;
    }

    private int layerSize(LGraph layeredGraph, int layer) {
        return layeredGraph.getLayers().get(layer).getNodes().size();
    }

    private LNode nodeByPosition(LGraph layeredGraph, int layer, int position) {
        return layeredGraph.getLayers().get(layer).getNodes().get(position);
    }

    private boolean incidentToInnerSegment(LNode node, int layer1, int layer2) {
        if (node.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
            for (LEdge edge : node.getIncomingEdges()) {
                if (edge.getSource().getNode().getProperty(Properties.NODE_TYPE) != NodeType.LONG_EDGE && edge.getSource().getNode().getProperty(Properties.NODE_TYPE) != NodeType.COMPOUND_SIDE || edge.getSource().getNode().getLayer().getIndex() != layer1 || node.getLayer().getIndex() != layer2) continue;
                return true;
            }
        }
        return false;
    }

    private List<LNode> allUpperNeighbors(LNode node) {
        LinkedList<LNode> result = new LinkedList<LNode>();
        int maxPriority = 0;
        for (LEdge edge : node.getIncomingEdges()) {
            if ((Integer)edge.getProperty((IProperty)Properties.PRIORITY) <= maxPriority) continue;
            maxPriority = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
        }
        for (LEdge edge : node.getIncomingEdges()) {
            if (node.getLayer() == edge.getSource().getNode().getLayer() || (Integer)edge.getProperty((IProperty)Properties.PRIORITY) != maxPriority) continue;
            result.add(edge.getSource().getNode());
        }
        Collections.sort(result, new NeighborComparator());
        return result;
    }

    private List<LNode> allLowerNeighbors(LNode node) {
        LinkedList<LNode> result = new LinkedList<LNode>();
        int maxPriority = 0;
        for (LEdge edge : node.getOutgoingEdges()) {
            if ((Integer)edge.getProperty((IProperty)Properties.PRIORITY) <= maxPriority) continue;
            maxPriority = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
        }
        for (LEdge edge : node.getOutgoingEdges()) {
            if (node.getLayer() == edge.getTarget().getNode().getLayer() || (Integer)edge.getProperty((IProperty)Properties.PRIORITY) != maxPriority) continue;
            result.add(edge.getTarget().getNode());
        }
        Collections.sort(result, new NeighborComparator());
        return result;
    }

    private LEdge getEdge(LNode source, LNode target) {
        for (LEdge edge : source.getConnectedEdges()) {
            if (!edge.getTarget().getNode().equals(target) && !edge.getSource().getNode().equals(target)) continue;
            return edge;
        }
        return null;
    }

    private HashMap<LNode, List<LNode>> getBlocks(BKAlignedLayout bal) {
        HashMap<LNode, List<LNode>> blocks = new HashMap<LNode, List<LNode>>();
        for (LNode key : bal.getRoot().keySet()) {
            if (!blocks.containsKey(bal.getRoot().get(key))) {
                blocks.put(bal.getRoot().get(key), new LinkedList());
            }
            blocks.get(bal.getRoot().get(key)).add(key);
        }
        return blocks;
    }

    private boolean blockContainsNorthSouthDummy(BKAlignedLayout bal, LNode root) {
        return bal.getBlockContainsNorthSouth().get(root);
    }

    private boolean blockContainsRegularNode(BKAlignedLayout bal, LNode root) {
        return bal.getBlockContainsRegularNode().get(root);
    }

    private boolean checkOrderConstraint(LGraph layeredGraph, BKAlignedLayout bal) {
        if (bal.getY().isEmpty()) {
            return false;
        }
        boolean layoutIsSane = true;
        for (Layer layer : layeredGraph.getLayers()) {
            double pos = Double.NEGATIVE_INFINITY;
            LNode previous = new LNode(layeredGraph);
            for (LNode node : layer.getNodes()) {
                if (bal.getY().get(node) + bal.getInnerShift().get(node) + node.getSize().y > pos) {
                    previous = node;
                    pos = bal.getY().get(node) + bal.getInnerShift().get(node) + node.getSize().y;
                    continue;
                }
                layoutIsSane = false;
                if (!this.debug) break;
                System.out.println("breaks on " + node + " which should have been after " + previous);
                break;
            }
            if (!layoutIsSane) break;
        }
        if (this.debug) {
            System.out.println(bal + " is correct: " + layoutIsSane);
        }
        return layoutIsSane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BKAlignedLayout {
        private HashMap<LNode, LNode> root;
        private HashMap<LNode, Double> blockSize;
        private HashMap<LNode, LNode> align;
        private HashMap<LNode, Double> innerShift;
        private HashMap<LNode, Double> postShift;
        private HashMap<LNode, LNode> sink;
        private HashMap<LNode, Double> shift;
        private HashMap<LNode, Double> y;
        private HashMap<LNode, Boolean> blockContainsNorthSouth;
        private HashMap<LNode, Boolean> blockContainsRegularNode;
        private VDirection vdir;
        private HDirection hdir;

        public BKAlignedLayout(int nodeCount, VDirection vdir, HDirection hdir) {
            this.root = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.blockSize = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.align = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.innerShift = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.postShift = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.sink = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.shift = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.y = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.blockContainsNorthSouth = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.blockContainsRegularNode = Maps.newHashMapWithExpectedSize((int)nodeCount);
            this.vdir = vdir;
            this.hdir = hdir;
        }

        public HashMap<LNode, LNode> getRoot() {
            return this.root;
        }

        public HashMap<LNode, Double> getBlockSize() {
            return this.blockSize;
        }

        public HashMap<LNode, LNode> getAlign() {
            return this.align;
        }

        public HashMap<LNode, Double> getInnerShift() {
            return this.innerShift;
        }

        public HashMap<LNode, Double> getPostShift() {
            return this.postShift;
        }

        public HashMap<LNode, LNode> getSink() {
            return this.sink;
        }

        public HashMap<LNode, Double> getShift() {
            return this.shift;
        }

        public HashMap<LNode, Double> getY() {
            return this.y;
        }

        public HashMap<LNode, Boolean> getBlockContainsNorthSouth() {
            return this.blockContainsNorthSouth;
        }

        public HashMap<LNode, Boolean> getBlockContainsRegularNode() {
            return this.blockContainsRegularNode;
        }

        public VDirection getVDir() {
            return this.vdir;
        }

        public HDirection getHDir() {
            return this.hdir;
        }

        public double layoutSize() {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (double i : this.y.values()) {
                if (i < min) {
                    min = i;
                }
                if (!(i > max)) continue;
                max = i;
            }
            min = Math.abs(min);
            return max + min;
        }

        public String toString() {
            String result = "";
            result = this.vdir == VDirection.LEFT ? String.valueOf(result) + "LEFT" : (this.vdir == VDirection.RIGHT ? String.valueOf(result) + "RIGHT" : String.valueOf(result) + "BALANCED");
            if (this.hdir == HDirection.TOP) {
                result = String.valueOf(result) + "TOP";
            } else if (this.hdir == HDirection.BOTTOM) {
                result = String.valueOf(result) + "BOTTOM";
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HDirection {
        TOP,
        BOTTOM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NeighborComparator
    implements Comparator<LNode>,
    Serializable {
        private static final long serialVersionUID = 7540379553811800233L;

        private NeighborComparator() {
        }

        @Override
        public int compare(LNode o1, LNode o2) {
            int result = 0;
            if (o1.getIndex() < o2.getIndex()) {
                result = -1;
            } else if (o1.getIndex() > o2.getIndex()) {
                result = 1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VDirection {
        LEFT,
        RIGHT;

    }
}

