/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundGraphLayerCrossingMinimizer {
    private LGraph layeredGraph;
    private ICrossingMinimizationHeuristic crossminHeuristic;

    public CompoundGraphLayerCrossingMinimizer(LGraph layeredGraph, ICrossingMinimizationHeuristic heuristic) {
        this.layeredGraph = layeredGraph;
        this.crossminHeuristic = heuristic;
    }

    public void compoundMinimizeCrossings(NodeGroup[] layer, int layerIndex, boolean forward, boolean preOrdered, boolean randomize) {
        if (layer.length == 0) {
            return;
        }
        boolean isCompound = (Boolean)this.layeredGraph.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        if (!isCompound) {
            LinkedList<NodeGroup> nodeGroups = new LinkedList<NodeGroup>();
            NodeGroup[] nodeGroupArray = layer;
            int n = layer.length;
            int n2 = 0;
            while (n2 < n) {
                NodeGroup ng = nodeGroupArray[n2];
                nodeGroups.add(ng);
                ++n2;
            }
            this.crossminHeuristic.minimizeCrossings(nodeGroups, layerIndex, preOrdered, randomize, forward);
            this.applyNodeGroupOrderingToNodeArray(nodeGroups, layer);
        } else {
            HashMap<LNode, LinkedList<NodeGroup>> compoundNodesMap = new HashMap<LNode, LinkedList<NodeGroup>>();
            LinkedList<LNode> compoundNodesMapKeys = new LinkedList<LNode>();
            int maximalDepth = 0;
            LNode graphKey = new LNode(this.layeredGraph);
            graphKey.setProperty(Properties.ORIGIN, this.layeredGraph);
            NodeGroup[] nodeGroupArray = layer;
            int n = layer.length;
            int n3 = 0;
            while (n3 < n) {
                LinkedList<NodeGroup> relatedList;
                NodeGroup nodeGroup = nodeGroupArray[n3];
                LNode key = Util.getRelatedCompoundNode(nodeGroup.getNode(), this.layeredGraph);
                if (key == null) {
                    key = graphKey;
                }
                if ((relatedList = (LinkedList<NodeGroup>)compoundNodesMap.get(key)) == null) {
                    relatedList = new LinkedList<NodeGroup>();
                    compoundNodesMap.put(key, relatedList);
                    compoundNodesMapKeys.add(key);
                }
                relatedList.add(nodeGroup);
                int keydepth = (Integer)key.getProperty(Properties.DEPTH);
                if (keydepth > maximalDepth) {
                    maximalDepth = keydepth;
                }
                ++n3;
            }
            LinkedList compoundNodesPerDepthLevel = new LinkedList();
            int i = 0;
            while (i <= maximalDepth) {
                LinkedList depthList = new LinkedList();
                compoundNodesPerDepthLevel.add(depthList);
                ++i;
            }
            for (LNode compoundNode : compoundNodesMapKeys) {
                ((LinkedList)compoundNodesPerDepthLevel.get((Integer)compoundNode.getProperty(Properties.DEPTH))).add(compoundNode);
            }
            HashMap elemMap = (HashMap)this.layeredGraph.getProperty(Properties.ELEMENT_MAP);
            while (!compoundNodesPerDepthLevel.isEmpty()) {
                LinkedList actualList = (LinkedList)compoundNodesPerDepthLevel.removeLast();
                for (LNode keyNode : actualList) {
                    LinkedList compoundContent = (LinkedList)compoundNodesMap.get(keyNode);
                    this.crossminHeuristic.minimizeCrossings(compoundContent, layerIndex, preOrdered, randomize, forward);
                    if (keyNode != graphKey) {
                        LNode parentKey;
                        NodeGroup aggregatedNodeGroup;
                        if (compoundContent.size() == 1) {
                            aggregatedNodeGroup = (NodeGroup)compoundContent.getFirst();
                        } else {
                            aggregatedNodeGroup = new NodeGroup((NodeGroup)compoundContent.removeFirst(), (NodeGroup)compoundContent.removeLast());
                            while (!compoundContent.isEmpty()) {
                                aggregatedNodeGroup = new NodeGroup(aggregatedNodeGroup, (NodeGroup)compoundContent.removeFirst());
                            }
                        }
                        KNode keyNodeParent = (KNode)keyNode.getProperty(Properties.K_PARENT);
                        LGraphElement parentRepresentative = (LGraphElement)elemMap.get(keyNodeParent);
                        if (parentRepresentative instanceof LGraph) {
                            parentKey = graphKey;
                        } else {
                            assert (parentRepresentative instanceof LNode);
                            parentKey = (LNode)parentRepresentative;
                        }
                        LinkedList<NodeGroup> parentContents = (LinkedList<NodeGroup>)compoundNodesMap.get(parentKey);
                        if (parentContents == null) {
                            parentContents = new LinkedList<NodeGroup>();
                            compoundNodesMap.put(parentKey, parentContents);
                            compoundNodesMapKeys.add(parentKey);
                        }
                        parentContents.add(aggregatedNodeGroup);
                        LinkedList parentList = (LinkedList)compoundNodesPerDepthLevel.get((Integer)parentKey.getProperty(Properties.DEPTH));
                        if (parentList.contains(parentKey)) continue;
                        parentList.add(parentKey);
                        continue;
                    }
                    this.applyNodeGroupOrderingToNodeArray(compoundContent, layer);
                }
            }
        }
    }

    private void applyNodeGroupOrderingToNodeArray(List<NodeGroup> nodeGroups, NodeGroup[] freeLayer) {
        int index = 0;
        for (NodeGroup nodeGroup : nodeGroups) {
            LNode[] lNodeArray = nodeGroup.getNodes();
            int n = lNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                freeLayer[index++] = (NodeGroup)node.getProperty(Properties.NODE_GROUP);
                ++n2;
            }
        }
    }
}

