/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p1cycles.GreedyCycleBreaker;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubgraphOrderingProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    private HashMap<Layer, HashMap<LNode, LinkedList<LNode>>> reorderedLayers;
    private HashMap<LNode, LinkedList<LNode>> orderedLists;
    private HashMap<Layer, HashMap<LNode, LinkedList<LNode>>> compoundChildrenLists;

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Order subgraphs so that the relative position is the same on all layers", 1.0f);
        this.reorderedLayers = new HashMap();
        HashMap<LNode, LGraph> subgraphOrderingGraph = new HashMap<LNode, LGraph>();
        LNode graphKey = new LNode(layeredGraph);
        graphKey.copyProperties((IPropertyHolder)layeredGraph);
        HashMap<LNode, LNode> insertedNodes = new HashMap<LNode, LNode>();
        HashMap elemMap = (HashMap)layeredGraph.getProperty(Properties.ELEMENT_MAP);
        this.compoundChildrenLists = new HashMap();
        for (Layer layer : layeredGraph) {
            Random random = (Random)layeredGraph.getProperty(Properties.RANDOM);
            HashMap<LNode, LinkedList<LNode>> layerCompoundChildrenLists = new HashMap<LNode, LinkedList<LNode>>();
            HashMap<LNode, LinkedList<LNode>> layerCompoundContents = new HashMap<LNode, LinkedList<LNode>>();
            List<LNode> layerNodes = layer.getNodes();
            boolean reordered = false;
            int i = 0;
            while (i < layerNodes.size() - 1) {
                LNode currentNode = layerNodes.get(i);
                LNode relatedCompoundCurrent = Util.getRelatedCompoundNode(currentNode, layeredGraph);
                this.insertRelatedCompound(layerCompoundContents, currentNode, relatedCompoundCurrent, graphKey);
                this.recursiveInsert(layerCompoundChildrenLists, currentNode, relatedCompoundCurrent, graphKey);
                LNode nextNode = layerNodes.get(i + 1);
                LNode relatedCompoundNext = Util.getRelatedCompoundNode(nextNode, layeredGraph);
                this.insertRelatedCompound(layerCompoundContents, nextNode, relatedCompoundNext, graphKey);
                this.recursiveInsert(layerCompoundChildrenLists, nextNode, relatedCompoundNext, graphKey);
                if (relatedCompoundCurrent != null && relatedCompoundNext != null && relatedCompoundCurrent != relatedCompoundNext) {
                    reordered = true;
                    LinkedList<LNode> leftRightList = new LinkedList<LNode>();
                    leftRightList.add(currentNode);
                    leftRightList.add(nextNode);
                    Util.propagatePair(leftRightList, elemMap);
                    LNode propCompoundCurrent = leftRightList.getFirst();
                    LNode propCompoundNext = leftRightList.getLast();
                    if (propCompoundCurrent != propCompoundNext) {
                        LGraph partGraph;
                        LGraphElement parentRep = (LGraphElement)elemMap.get(propCompoundCurrent.getProperty(Properties.K_PARENT));
                        LNode key = parentRep instanceof LGraph ? graphKey : (LNode)parentRep;
                        if (subgraphOrderingGraph.containsKey(key)) {
                            partGraph = subgraphOrderingGraph.get(key);
                        } else {
                            partGraph = new LGraph(layeredGraph);
                            partGraph.setProperty(Properties.RANDOM, random);
                            subgraphOrderingGraph.put(key, partGraph);
                        }
                        List<LNode> nodeList = partGraph.getLayerlessNodes();
                        LNode currentRep = this.getNodeCopy(propCompoundCurrent, nodeList, insertedNodes);
                        LNode nextRep = this.getNodeCopy(propCompoundNext, nodeList, insertedNodes);
                        LEdge leftOfEdge = new LEdge(layeredGraph);
                        LPort sourcePort = new LPort(layeredGraph);
                        LPort targetPort = new LPort(layeredGraph);
                        leftOfEdge.setSource(sourcePort);
                        leftOfEdge.setTarget(targetPort);
                        sourcePort.setNode(currentRep);
                        targetPort.setNode(nextRep);
                    }
                }
                ++i;
            }
            if (!reordered) continue;
            this.reorderedLayers.put(layer, layerCompoundContents);
            this.compoundChildrenLists.put(layer, layerCompoundChildrenLists);
        }
        Set keys = subgraphOrderingGraph.keySet();
        this.orderedLists = new HashMap();
        GreedyCycleBreaker cycleBreaker = new GreedyCycleBreaker();
        boolean noProblems = true;
        for (LNode key : keys) {
            LGraph graphComponent = (LGraph)subgraphOrderingGraph.get(key);
            cycleBreaker.reset();
            cycleBreaker.process(graphComponent);
            if (!((Boolean)graphComponent.getProperty(Properties.CYCLIC)).booleanValue()) continue;
            noProblems = false;
            LinkedList<LNode> topologicalSorting = this.graphToList(graphComponent);
            this.orderedLists.put(key, topologicalSorting);
        }
        if (!noProblems) {
            this.applyOrder(layeredGraph, subgraphOrderingGraph, graphKey, elemMap);
        }
        this.getMonitor().done();
    }

    private void recursiveInsert(HashMap<LNode, LinkedList<LNode>> layerCompoundContents, LNode currentChild, LGraphElement currentParent, LNode graphKey) {
        if (currentParent instanceof LGraph) {
            LinkedList<LNode> currentAncestorNodesList = layerCompoundContents.get(graphKey);
            if (currentAncestorNodesList == null) {
                currentAncestorNodesList = new LinkedList();
                layerCompoundContents.put(graphKey, currentAncestorNodesList);
            }
            if (!currentAncestorNodesList.contains(currentChild)) {
                currentAncestorNodesList.add(currentChild);
            }
        } else if (currentParent instanceof LNode) {
            LNode nodeKey = (LNode)currentParent;
            LinkedList<LNode> currentAncestorNodesList = layerCompoundContents.get(nodeKey);
            if (currentAncestorNodesList == null) {
                currentAncestorNodesList = new LinkedList();
                layerCompoundContents.put(nodeKey, currentAncestorNodesList);
            }
            if (!currentAncestorNodesList.contains(currentChild)) {
                currentAncestorNodesList.add(currentChild);
            }
            this.recursiveInsert(layerCompoundContents, nodeKey, (LGraphElement)nodeKey.getProperty(Properties.PARENT), graphKey);
        }
    }

    private void insertRelatedCompound(HashMap<LNode, LinkedList<LNode>> layerCompoundContents, LNode node, LNode relatedCompound, LNode graphKey) {
        LinkedList<Object> nodeList;
        LNode key = relatedCompound;
        if (key == null) {
            key = graphKey;
        }
        if (layerCompoundContents.containsKey(key)) {
            nodeList = layerCompoundContents.get(key);
        } else {
            nodeList = new LinkedList();
            layerCompoundContents.put(key, nodeList);
        }
        if (!nodeList.contains(node)) {
            nodeList.addLast(node);
        }
    }

    private void applyOrder(LGraph layeredGraph, HashMap<LNode, LGraph> subgraphOrderingGraph, LNode graphKey, HashMap<KGraphElement, LGraphElement> elemMap) {
        HashMap<Layer, LinkedList<LNode>> layerOrders = new HashMap<Layer, LinkedList<LNode>>();
        for (Layer layer : this.reorderedLayers.keySet()) {
            LinkedList<LNode> layerOrder = new LinkedList<LNode>();
            this.recursiveApplyLayerOrder(layer, graphKey, layeredGraph, subgraphOrderingGraph, layerOrder, elemMap);
            layerOrders.put(layer, layerOrder);
        }
        for (Map.Entry entry : layerOrders.entrySet()) {
            List<LNode> nodes = ((Layer)entry.getKey()).getNodes();
            int sizeNodes = nodes.size();
            LinkedList orderNodes = (LinkedList)entry.getValue();
            int sizeOrderNodes = orderNodes.size();
            assert (sizeNodes == sizeOrderNodes);
            int i = 0;
            while (i < sizeNodes) {
                nodes.remove(0);
                ++i;
            }
            assert (nodes.isEmpty());
            for (LNode node : orderNodes) {
                nodes.add(node);
            }
            assert (nodes.size() == sizeOrderNodes);
        }
    }

    private void recursiveApplyLayerOrder(Layer layer, LNode key, LGraph layeredGraph, HashMap<LNode, LGraph> subgraphOrderingGraph, LinkedList<LNode> layerOrder, HashMap<KGraphElement, LGraphElement> elemMap) {
        LinkedList<LNode> assignedNodes;
        LinkedList<LNode> componentOrder = this.orderedLists.get(key);
        if (componentOrder == null) {
            LinkedList<LNode> childrenList = this.compoundChildrenLists.get(layer).get(key);
            if (childrenList != null) {
                for (LNode child : childrenList) {
                    if (child == key || !this.compoundChildrenLists.get(layer).containsKey(child)) continue;
                    this.recursiveApplyLayerOrder(layer, child, layeredGraph, subgraphOrderingGraph, layerOrder, elemMap);
                }
            }
        } else {
            componentOrder = this.merge(componentOrder, this.compoundChildrenLists.get(layer).get(key));
            for (LNode currentNode : componentOrder) {
                if (currentNode == key) continue;
                this.recursiveApplyLayerOrder(layer, currentNode, layeredGraph, subgraphOrderingGraph, layerOrder, elemMap);
            }
        }
        if ((assignedNodes = this.reorderedLayers.get(layer).get(key)) != null) {
            for (LNode assignedNode : assignedNodes) {
                if (layerOrder.contains(assignedNode)) continue;
                layerOrder.add(assignedNode);
            }
        }
    }

    private LinkedList<LNode> merge(LinkedList<LNode> componentOrder, LinkedList<LNode> layerOrder) {
        LinkedList<LNode> retList = new LinkedList<LNode>();
        if (layerOrder.isEmpty()) {
            for (LNode lnode : componentOrder) {
                LNode origin = (LNode)lnode.getProperty(Properties.ORIGIN);
                retList.add(origin);
            }
            return retList;
        }
        LinkedList<LNode> trimmedComponentOrder = new LinkedList<LNode>();
        for (LNode repNode : componentOrder) {
            LNode origin = (LNode)repNode.getProperty(Properties.ORIGIN);
            if (!layerOrder.contains(origin)) continue;
            trimmedComponentOrder.add(origin);
        }
        int i = 0;
        for (LNode node : layerOrder) {
            if (!trimmedComponentOrder.contains(node)) {
                retList.add(node);
                continue;
            }
            assert (i < trimmedComponentOrder.size());
            retList.add((LNode)trimmedComponentOrder.get(i));
            ++i;
        }
        assert (retList.size() == layerOrder.size());
        return retList;
    }

    private LinkedList<LNode> graphToList(LGraph graph) {
        boolean acyclic = true;
        LinkedList<LNode> retList = new LinkedList<LNode>();
        List<LNode> nodes = graph.getLayerlessNodes();
        LinkedList<LNode> sources = new LinkedList<LNode>();
        for (LNode node : nodes) {
            if (node.getIncomingEdges().iterator().hasNext()) continue;
            sources.add(node);
        }
        while (!sources.isEmpty()) {
            LNode currentSource = (LNode)sources.getFirst();
            sources.removeFirst();
            retList.add(currentSource);
            Iterator<LEdge> outEdgesIterator = currentSource.getOutgoingEdges().iterator();
            HashSet<LNode> targets = new HashSet<LNode>();
            while (outEdgesIterator.hasNext()) {
                LEdge edge = outEdgesIterator.next();
                LNode edgeTarget = edge.getTarget().getNode();
                if (targets.contains(edgeTarget)) continue;
                targets.add(edgeTarget);
            }
            for (LNode target : targets) {
                boolean isNewSource = true;
                Iterator<LEdge> inEdgesIterator = target.getIncomingEdges().iterator();
                LinkedList<LEdge> removableEdges = new LinkedList<LEdge>();
                while (inEdgesIterator.hasNext()) {
                    LEdge edge = inEdgesIterator.next();
                    LNode source = edge.getSource().getNode();
                    if (source == currentSource) {
                        removableEdges.add(edge);
                        continue;
                    }
                    isNewSource = false;
                }
                int edgesSize = removableEdges.size();
                int i = 0;
                while (i < edgesSize) {
                    LEdge edge = (LEdge)removableEdges.removeFirst();
                    edge.getSource().getNode().getPorts().remove(edge.getSource());
                    edge.getTarget().getNode().getPorts().remove(edge.getTarget());
                    ++i;
                }
                if (!isNewSource) continue;
                sources.add(target);
            }
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                if (!port.getConnectedEdges().iterator().hasNext()) continue;
                acyclic = false;
            }
        }
        assert (acyclic);
        return retList;
    }

    private LNode getNodeCopy(LNode node, List<LNode> layerlessNodes, HashMap<LNode, LNode> insertedNodes) {
        LNode retNode;
        if (insertedNodes.containsKey(node)) {
            retNode = insertedNodes.get(node);
        } else {
            retNode = new LNode(node.getLayer().getGraph());
            retNode.setProperty(Properties.ORIGIN, node);
            insertedNodes.put(node, retNode);
            layerlessNodes.add(retNode);
        }
        return retNode;
    }
}

