/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.EdgeConstraint;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class EdgeAndLayerConstraintEdgeReverser
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Edge and layer constraint edge reversal", 1.0f);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            LayerConstraint layerConstraint = (LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT));
            switch (layerConstraint) {
                case FIRST: 
                case FIRST_SEPARATE: {
                    node.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                    break;
                }
                case LAST: 
                case LAST_SEPARATE: {
                    node.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                }
            }
            EdgeConstraint edgeConstraint = (EdgeConstraint)((Object)node.getProperty(Properties.EDGE_CONSTRAINT));
            if (edgeConstraint == EdgeConstraint.INCOMING_ONLY) {
                this.reverseEdges(layeredGraph, node, PortType.OUTPUT);
                continue;
            }
            if (edgeConstraint == EdgeConstraint.OUTGOING_ONLY) {
                this.reverseEdges(layeredGraph, node, PortType.INPUT);
                continue;
            }
            if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed() || node.getPorts().isEmpty()) continue;
            boolean allPortsReversed = true;
            for (LPort port : node.getPorts()) {
                if (port.getSide() == PortSide.EAST && port.getNetFlow() > 0 || port.getSide() == PortSide.WEST && port.getNetFlow() < 0) continue;
                allPortsReversed = false;
                break;
            }
            if (!allPortsReversed) continue;
            this.reverseEdges(layeredGraph, node, PortType.UNDEFINED);
        }
        this.getMonitor().done();
    }

    private void reverseEdges(LGraph layeredGraph, LNode node, PortType type) {
        LPort[] ports;
        LPort[] lPortArray = ports = node.getPorts().toArray(new LPort[node.getPorts().size()]);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge edge;
            int n3;
            int n4;
            LEdge[] lEdgeArray;
            LPort port = lPortArray[n2];
            if (type != PortType.INPUT) {
                LEdge[] outgoing;
                lEdgeArray = outgoing = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                n4 = outgoing.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    if (!((Boolean)edge.getProperty(Properties.REVERSED)).booleanValue()) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            if (type != PortType.OUTPUT) {
                LEdge[] incoming = port.getIncomingEdges().toArray(new LEdge[port.getIncomingEdges().size()]);
                lEdgeArray = incoming;
                n4 = incoming.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    if (!((Boolean)edge.getProperty(Properties.REVERSED)).booleanValue()) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }
}

