/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.klay.layered.components.AbstractGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.ComponentGroup;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentGroupGraphPlacer
extends AbstractGraphPlacer {
    private final List<ComponentGroup> componentGroups = Lists.newLinkedList();

    ComponentGroupGraphPlacer() {
    }

    @Override
    public LGraph combine(List<LGraph> components) {
        if (components.isEmpty()) {
            return new LGraph();
        }
        LGraph firstComponent = components.get(0);
        LGraph result = new LGraph(firstComponent);
        result.copyProperties((IPropertyHolder)firstComponent);
        result.getInsets().copy(firstComponent.getInsets());
        for (LGraph component : components) {
            this.addComponent(component);
        }
        KVector offset = new KVector();
        float spacing = 2.0f * ((Float)components.get(0).getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        for (ComponentGroup group : this.componentGroups) {
            KVector groupSize = this.placeComponents(group, spacing);
            this.moveGraphs(result, group.getComponents(), offset.x, offset.y);
            offset.x += groupSize.x;
            offset.y += groupSize.y;
        }
        result.getSize().x = offset.x;
        result.getSize().y = offset.y;
        return result;
    }

    private void addComponent(LGraph component) {
        for (ComponentGroup group : this.componentGroups) {
            if (!group.add(component)) continue;
            return;
        }
        this.componentGroups.add(new ComponentGroup(component));
    }

    private KVector placeComponents(ComponentGroup group, double spacing) {
        KVector sizeC = this.placeComponentsInRows(group.getComponents(ComponentGroup.CONN_C), spacing);
        KVector sizeN = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_N), spacing);
        KVector sizeS = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_S), spacing);
        KVector sizeW = this.placeComponentsVertically(group.getComponents(ComponentGroup.CONN_W), spacing);
        KVector sizeE = this.placeComponentsVertically(group.getComponents(ComponentGroup.CONN_E), spacing);
        KVector sizeNW = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_NW), spacing);
        KVector sizeNE = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_NE), spacing);
        KVector sizeSW = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_SW), spacing);
        KVector sizeSE = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_SE), spacing);
        KVector sizeWE = this.placeComponentsVertically(group.getComponents(ComponentGroup.CONN_WE), spacing);
        KVector sizeNS = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_NS), spacing);
        KVector sizeNWE = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_NWE), spacing);
        KVector sizeSWE = this.placeComponentsHorizontally(group.getComponents(ComponentGroup.CONN_SWE), spacing);
        KVector sizeWNS = this.placeComponentsVertically(group.getComponents(ComponentGroup.CONN_WNS), spacing);
        KVector sizeENS = this.placeComponentsVertically(group.getComponents(ComponentGroup.CONN_ENS), spacing);
        double colLeftWidth = KielerMath.maxd((double[])new double[]{sizeNW.x, sizeW.x, sizeSW.x, sizeWNS.x});
        double colMidWidth = KielerMath.maxd((double[])new double[]{sizeN.x, sizeC.x, sizeS.x});
        double colNsWidth = sizeNS.x;
        double colRightWidth = KielerMath.maxd((double[])new double[]{sizeNE.x, sizeE.x, sizeSE.x, sizeENS.x});
        double rowTopHeight = KielerMath.maxd((double[])new double[]{sizeNW.y, sizeN.y, sizeNE.y, sizeNWE.y});
        double rowMidHeight = KielerMath.maxd((double[])new double[]{sizeW.y, sizeC.y, sizeE.y});
        double rowWeHeight = sizeWE.y;
        double rowBottomHeight = KielerMath.maxd((double[])new double[]{sizeSW.y, sizeS.y, sizeSE.y, sizeSWE.y});
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_C), colLeftWidth + colNsWidth, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_N), colLeftWidth + colNsWidth, 0.0);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_S), colLeftWidth + colNsWidth, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_W), 0.0, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_E), colLeftWidth + colNsWidth + colMidWidth, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_NE), colLeftWidth + colNsWidth + colMidWidth, 0.0);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_SW), 0.0, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_SE), colLeftWidth + colNsWidth + colMidWidth, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_WE), 0.0, rowTopHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_NS), colLeftWidth, 0.0);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_SWE), 0.0, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(ComponentGroup.CONN_ENS), colLeftWidth + colNsWidth + colMidWidth, 0.0);
        KVector componentSize = new KVector();
        componentSize.x = KielerMath.maxd((double[])new double[]{colLeftWidth + colMidWidth + colNsWidth + colRightWidth, sizeWE.x, sizeNWE.x, sizeSWE.x});
        componentSize.y = KielerMath.maxd((double[])new double[]{rowTopHeight + rowMidHeight + rowWeHeight + rowBottomHeight, sizeNS.y, sizeWNS.y, sizeENS.y});
        return componentSize;
    }

    private KVector placeComponentsHorizontally(Collection<LGraph> components, double spacing) {
        KVector size = new KVector();
        for (LGraph component : components) {
            this.offsetGraph(component, size.x, 0.0);
            size.x += component.getSize().x + spacing;
            size.y = Math.max(size.y, component.getSize().y);
        }
        if (size.y > 0.0) {
            size.y += spacing;
        }
        return size;
    }

    private KVector placeComponentsVertically(Collection<LGraph> components, double spacing) {
        KVector size = new KVector();
        for (LGraph component : components) {
            this.offsetGraph(component, 0.0, size.y);
            size.y += component.getSize().y + spacing;
            size.x = Math.max(size.x, component.getSize().x);
        }
        if (size.x > 0.0) {
            size.x += spacing;
        }
        return size;
    }

    private KVector placeComponentsInRows(Collection<LGraph> components, double spacing) {
        if (components.isEmpty()) {
            return new KVector();
        }
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LGraph component : components) {
            KVector componentSize = component.getSize();
            maxRowWidth = Math.max(maxRowWidth, componentSize.x);
            totalArea += componentSize.x * componentSize.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)components.iterator().next().getProperty((IProperty)Properties.ASPECT_RATIO)).floatValue()));
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.offsetGraph(graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        return new KVector(broadestRow + spacing, ypos + highestBox + spacing);
    }
}

