/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.graph;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.klay.force.graph.FBendpoint;
import de.cau.cs.kieler.klay.force.graph.FEdge;
import de.cau.cs.kieler.klay.force.graph.FLabel;
import de.cau.cs.kieler.klay.force.graph.FNode;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import de.cau.cs.kieler.klay.force.properties.Properties;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FGraph
extends MapPropertyHolder {
    private static final long serialVersionUID = -2396315570561498425L;
    private LinkedList<FNode> nodes = new LinkedList();
    private LinkedList<FEdge> edges = new LinkedList();
    private LinkedList<FLabel> labels = new LinkedList();
    private LinkedList<FBendpoint> bendPoints = new LinkedList();
    private int[][] adjacency;

    public List<FEdge> getEdges() {
        return this.edges;
    }

    public List<FNode> getNodes() {
        return this.nodes;
    }

    public List<FLabel> getLabels() {
        return this.labels;
    }

    public List<FBendpoint> getBendpoints() {
        return this.bendPoints;
    }

    public Iterable<FParticle> getParticles() {
        return Iterables.concat(this.nodes, this.labels, this.bendPoints);
    }

    public int getConnection(FParticle particle1, FParticle particle2) {
        if (particle1 instanceof FNode && particle2 instanceof FNode) {
            FNode node1 = (FNode)particle1;
            FNode node2 = (FNode)particle2;
            return this.adjacency[node1.id][node2.id] + this.adjacency[node2.id][node1.id];
        }
        if (particle1 instanceof FBendpoint && particle2 instanceof FBendpoint) {
            FBendpoint bpoint1 = (FBendpoint)particle1;
            FBendpoint bpoint2 = (FBendpoint)particle2;
            if (bpoint1.getEdge() == bpoint2.getEdge()) {
                return (Integer)bpoint2.getEdge().getProperty((IProperty)Properties.PRIORITY);
            }
        }
        return 0;
    }

    public void calcAdjacency() {
        int n = this.nodes.size();
        this.adjacency = new int[n][n];
        for (FEdge edge : this.edges) {
            int[] nArray = this.adjacency[edge.getSource().id];
            int n2 = edge.getTarget().id;
            nArray[n2] = nArray[n2] + (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
        }
    }
}

