/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.ui.diagram.DiagramLayoutEngine;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutConfig;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.service.LayoutOptionManager;
import de.cau.cs.kieler.kiml.ui.views.LayoutPropertySource;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class LayoutPropertySourceProvider
implements IPropertySourceProvider {
    private final Map<Object, LayoutPropertySource> propertySources = Maps.newHashMap();
    private IWorkbenchPart workbenchPart;

    public void resetContext() {
        this.propertySources.clear();
    }

    public void resetContext(IWorkbenchPart theworkbenchPart) {
        this.workbenchPart = theworkbenchPart;
        this.resetContext();
    }

    public IPropertySource getPropertySource(Object object) {
        if (this.propertySources.containsKey(object)) {
            return this.propertySources.get(object);
        }
        IDiagramLayoutManager<?> manager = EclipseLayoutInfoService.getInstance().getManager(this.workbenchPart, object);
        if (manager != null) {
            LayoutOptionManager optionManager = DiagramLayoutEngine.INSTANCE.getOptionManager();
            Object diagramPart = manager.getAdapter(object, manager.getAdapterList()[0]);
            EObject domainElement = (EObject)manager.getAdapter(object, EObject.class);
            ILayoutConfig elc = (ILayoutConfig)manager.getAdapter(null, ILayoutConfig.class);
            TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)manager.getAdapter(object, TransactionalEditingDomain.class);
            if (diagramPart != null) {
                IMutableLayoutConfig layoutConfig = elc == null ? optionManager.createConfig(domainElement, new ILayoutConfig[0]) : optionManager.createConfig(domainElement, elc);
                LayoutContext context = new LayoutContext();
                context.setProperty(EclipseLayoutConfig.WORKBENCH_PART, (Object)this.workbenchPart);
                context.setProperty(LayoutContext.DOMAIN_MODEL, (Object)domainElement);
                context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
                LayoutPropertySource propSource = new LayoutPropertySource(layoutConfig, context, editingDomain);
                this.propertySources.put(object, propSource);
                return propSource;
            }
        }
        return null;
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public LayoutContext getContext() {
        Collection<LayoutPropertySource> sources = this.propertySources.values();
        LayoutContext context = new LayoutContext();
        for (LayoutPropertySource s : sources) {
            context.copyProperties((IPropertyHolder)s.getContext());
        }
        return context;
    }

    public boolean hasContent() {
        return !this.propertySources.isEmpty();
    }
}

