/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.util.KimlUiUtil;
import de.cau.cs.kieler.kiml.ui.views.LayoutPropertySource;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class DiagramTypeDefaultAction
extends Action {
    public static final String ACTION_ID = "kieler.diagram.type.default";
    private static ImageDescriptor icon = KimlUiPlugin.getImageDescriptor("icons/menu16/apply2diagramType.gif");
    private LayoutViewPart layoutView;
    private String diagramType;

    public DiagramTypeDefaultAction(LayoutViewPart thelayoutView, String text) {
        super(text, icon);
        this.layoutView = thelayoutView;
    }

    public void setDiagramType(String thediagramType) {
        this.diagramType = thediagramType;
    }

    public void run() {
        Object diagramPart = this.layoutView.getCurrentDiagramPart();
        if (diagramPart != null && this.diagramType != null) {
            for (IPropertySheetEntry entry : this.layoutView.getSelection()) {
                this.setDefault(entry);
            }
        }
    }

    private void setDefault(IPropertySheetEntry entry) {
        LayoutOptionData<?> optionData = KimlUiUtil.getOptionData(this.layoutView.getCurrentLayouterData(), entry.getDisplayName());
        if (optionData != null) {
            String valueString = entry.getValueAsString();
            if (optionData.equals((Object)LayoutOptions.ALGORITHM)) {
                valueString = LayoutPropertySource.getLayoutHint(valueString);
            }
            EclipseLayoutInfoService.getInstance().storeOption(this.diagramType, optionData, valueString);
        }
    }
}

