/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.preferences;

import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.preferences.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class OptionsTableProvider
extends LabelProvider
implements ITableLabelProvider,
IStructuredContentProvider {
    private static final int COL_ELEMENT = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_OPTION = 2;
    private static final int COL_VALUE = 3;

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof DataEntry && columnIndex == 3) {
            DataEntry entry = (DataEntry)element;
            KimlUiPlugin.Images images = KimlUiPlugin.getDefault().getImages();
            switch (entry.optionData.getType()) {
                case STRING: {
                    return images.getPropText();
                }
                case BOOLEAN: {
                    if (((Boolean)entry.value).booleanValue()) {
                        return images.getPropTrue();
                    }
                    return images.getPropFalse();
                }
                case ENUM: 
                case REMOTE_ENUM: {
                    return images.getPropChoice();
                }
                case INT: {
                    return images.getPropInt();
                }
                case FLOAT: {
                    return images.getPropFloat();
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof DataEntry) {
            DataEntry entry = (DataEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.elementName;
                }
                case 1: {
                    return entry.type.getDescription();
                }
                case 2: {
                    return entry.optionData.getName();
                }
                case 3: {
                    if (entry.optionData.getType() == LayoutOptionData.Type.ENUM && entry.value instanceof Integer) {
                        return entry.optionData.getEnumValue(((Integer)entry.value).intValue()).toString();
                    }
                    return entry.value.toString();
                }
            }
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            ArrayList list = new ArrayList((List)inputElement);
            ListIterator listIter = list.listIterator();
            while (listIter.hasNext()) {
                DataEntry next = (DataEntry)listIter.next();
                if (next.value != null) continue;
                listIter.remove();
            }
            return list.toArray();
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataEntry {
        private String elementName;
        private String elementId;
        private ElementType type;
        private LayoutOptionData<?> optionData;
        private Object value;

        public DataEntry(String name, String id, ElementType thetype, LayoutOptionData<?> theoptionData, Object thevalue) {
            this.elementName = name;
            this.elementId = id;
            this.type = thetype;
            this.optionData = theoptionData;
            this.value = thevalue;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getElementId() {
            return this.elementId;
        }

        public ElementType getType() {
            return this.type;
        }

        public LayoutOptionData<?> getOptionData() {
            return this.optionData;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object thevalue) {
            this.value = thevalue;
        }

        public boolean equals(Object object) {
            if (object instanceof DataEntry) {
                DataEntry other = (DataEntry)object;
                return this.elementId.equals(other.elementId) && this.optionData.equals(other.optionData);
            }
            return false;
        }

        public int hashCode() {
            return this.elementId.hashCode() + this.optionData.hashCode();
        }
    }
}

