/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.preferences;

import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.LayoutOptionValidator;
import de.cau.cs.kieler.kiml.ui.LayouterHintDialog;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.preferences.ElementType;
import de.cau.cs.kieler.kiml.ui.preferences.NewOptionDialog;
import de.cau.cs.kieler.kiml.ui.preferences.OptionsTableProvider;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button animationCheckBox;
    private Button zoomCheckBox;
    private Button progressCheckBox;
    private Button obliqueCheckBox;
    private List<OptionsTableProvider.DataEntry> optionEntries;
    private TableViewer optionTableViewer;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 5;
    private static final int OPTIONS_TABLE_HEIGHT = 300;

    public LayoutPreferencePage() {
        this.setDescription(Messages.getString("kiml.ui.0"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group generalGroup = this.createGeneralGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group optionsGroup = this.createOptionsGroup(composite);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        return composite;
    }

    private Group createGeneralGroup(Composite parent) {
        Group generalGroup = new Group(parent, 0);
        generalGroup.setText(Messages.getString("kiml.ui.35"));
        this.animationCheckBox = new Button((Composite)generalGroup, 16416);
        this.animationCheckBox.setText(Messages.getString("kiml.ui.64"));
        this.animationCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.animation"));
        this.zoomCheckBox = new Button((Composite)generalGroup, 16416);
        this.zoomCheckBox.setText(Messages.getString("kiml.ui.65"));
        this.zoomCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.zoomToFit"));
        this.progressCheckBox = new Button((Composite)generalGroup, 16416);
        this.progressCheckBox.setText(Messages.getString("kiml.ui.66"));
        this.progressCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.progressDialog"));
        this.obliqueCheckBox = new Button((Composite)generalGroup, 16416);
        this.obliqueCheckBox.setText(Messages.getString("kiml.ui.36"));
        this.obliqueCheckBox.setSelection(this.getPreferenceStore().getBoolean("kiml.oblique.route"));
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        generalGroup.setLayout((Layout)layout);
        return generalGroup;
    }

    private Group createOptionsGroup(Composite parent) {
        Group elementGroup = new Group(parent, 0);
        elementGroup.setText(Messages.getString("kiml.ui.28"));
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        LayoutDataService dataService = LayoutDataService.getInstance();
        Collection layoutOptionData = dataService.getOptionData();
        this.optionEntries = new LinkedList<OptionsTableProvider.DataEntry>();
        Set<String> elements = EclipseLayoutInfoService.getInstance().getRegisteredElements();
        for (String element : elements) {
            for (LayoutOptionData data : layoutOptionData) {
                ElementType type;
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName(element, data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                int dotIndex = element.lastIndexOf(46);
                String partName = element.substring(dotIndex + 1);
                ElementType elementType = type = partName.endsWith("EditPart") ? ElementType.EDIT_PART : ElementType.MODEL_ELEM;
                if (partName.endsWith("Impl")) {
                    partName = partName.substring(0, partName.length() - "Impl".length());
                }
                this.optionEntries.add(new OptionsTableProvider.DataEntry(partName, element, type, data, value));
            }
        }
        List diagramTypeList = EclipseLayoutInfoService.getInstance().getDiagramTypes();
        for (Pair diagramType : diagramTypeList) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName((String)diagramType.getFirst(), data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.optionEntries.add(new OptionsTableProvider.DataEntry((String)diagramType.getSecond(), (String)diagramType.getFirst(), ElementType.DIAG_TYPE, data, value));
            }
        }
        this.addOptionTable((Composite)elementGroup, this.optionEntries);
        elementGroup.setLayout((Layout)new GridLayout(2, false));
        return elementGroup;
    }

    private void addOptionTable(final Composite parent, final List<OptionsTableProvider.DataEntry> entries) {
        final Table table = new Table(parent, 2048);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString("kiml.ui.29"));
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString("kiml.ui.9"));
        final TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.getString("kiml.ui.19"));
        final TableColumn column4 = new TableColumn(table, 0);
        column4.setText(Messages.getString("kiml.ui.20"));
        table.setHeaderVisible(true);
        final TableViewer tableViewer = new TableViewer(table);
        OptionsTableProvider optionsTableProvider = new OptionsTableProvider();
        tableViewer.setContentProvider((IContentProvider)optionsTableProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)optionsTableProvider);
        tableViewer.setInput(entries);
        this.optionTableViewer = tableViewer;
        column1.pack();
        column2.pack();
        column3.pack();
        column4.pack();
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)tableLayoutData);
        table.pack();
        tableLayoutData.heightHint = 300;
        Composite composite = new Composite(parent, 0);
        Button newButton = new Button(composite, 0x1000008);
        newButton.setText(Messages.getString("kiml.ui.41"));
        final Button editButton = new Button(composite, 0x1000008);
        editButton.setText(Messages.getString("kiml.ui.21"));
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OptionsTableProvider.DataEntry entry = LayoutPreferencePage.this.getEntry(entries, table.getSelectionIndex());
                if (entry != null) {
                    LayoutPreferencePage.this.showEditDialog(parent.getShell(), entry);
                    tableViewer.refresh();
                }
            }
        });
        final Button removeButton = new Button(composite, 0x1000008);
        removeButton.setText(Messages.getString("kiml.ui.22"));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OptionsTableProvider.DataEntry entry = LayoutPreferencePage.this.getEntry(entries, table.getSelectionIndex());
                if (entry != null) {
                    entry.setValue(null);
                    tableViewer.refresh();
                    int count = 0;
                    for (OptionsTableProvider.DataEntry e : entries) {
                        if (e.getValue() == null) continue;
                        ++count;
                    }
                    if (count == 0) {
                        editButton.setEnabled(false);
                        removeButton.setEnabled(false);
                    }
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!entries.isEmpty() && event.item != null) {
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                } else {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                }
            }
        });
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int newIndex = LayoutPreferencePage.this.showNewDialog(parent.getShell(), entries);
                if (newIndex >= 0) {
                    tableViewer.refresh();
                    tableViewer.setSelection((ISelection)new StructuredSelection(entries.get(newIndex)));
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                    column1.pack();
                    column2.pack();
                    column3.pack();
                    column4.pack();
                }
            }
        });
        composite.setLayout((Layout)new FillLayout(512));
        GridData compositeLayoutData = new GridData(16384, 128, false, false, 1, 1);
        composite.setLayoutData((Object)compositeLayoutData);
    }

    private OptionsTableProvider.DataEntry getEntry(List<OptionsTableProvider.DataEntry> entries, int index) {
        ListIterator<OptionsTableProvider.DataEntry> entryIter = entries.listIterator();
        int i = 0;
        while (entryIter.hasNext()) {
            OptionsTableProvider.DataEntry entry = entryIter.next();
            if (entry.getValue() == null) continue;
            if (i == index) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private void showEditDialog(Shell shell, OptionsTableProvider.DataEntry entry) {
        LayoutOptionData<?> optionData = entry.getOptionData();
        if (entry.getValue() != null) {
            if (optionData.equals((Object)LayoutOptions.ALGORITHM)) {
                String result;
                LayouterHintDialog dialog = new LayouterHintDialog(shell, null);
                if (dialog.open() == 0 && (result = dialog.getSelectedHint()) != null) {
                    entry.setValue(result);
                }
            } else {
                String value = entry.getValue().toString();
                InputDialog dialog = new InputDialog(shell, Messages.getString("kiml.ui.23"), Messages.getString("kiml.ui.24"), value, (IInputValidator)new LayoutOptionValidator(optionData));
                if (dialog.open() == 0) {
                    String result = dialog.getValue().trim();
                    switch (optionData.getType()) {
                        case ENUM: 
                        case REMOTE_ENUM: {
                            entry.setValue(optionData.parseValue(result.toUpperCase()));
                            break;
                        }
                        default: {
                            entry.setValue(optionData.parseValue(result));
                        }
                    }
                }
            }
        }
    }

    private int showNewDialog(Shell shell, List<OptionsTableProvider.DataEntry> entries) {
        NewOptionDialog dialog = new NewOptionDialog(shell);
        if (dialog.open() == 0) {
            OptionsTableProvider.DataEntry newEntry = dialog.createDataEntry();
            if (newEntry == null) {
                MessageDialog.openError((Shell)shell, (String)Messages.getString("kiml.ui.51"), (String)Messages.getString("kiml.ui.52"));
            } else {
                int oldIndex = 0;
                OptionsTableProvider.DataEntry oldEntry = null;
                for (OptionsTableProvider.DataEntry e : entries) {
                    if (e.getValue() == null) continue;
                    if (e.equals(newEntry)) {
                        oldEntry = e;
                        break;
                    }
                    ++oldIndex;
                }
                if (oldEntry != null) {
                    return oldIndex;
                }
                entries.add(newEntry);
                return entries.size() - 1;
            }
        }
        return -1;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(KimlUiPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.animationCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.animation"));
        this.zoomCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.zoomToFit"));
        this.progressCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.progressDialog"));
        this.obliqueCheckBox.setSelection(preferenceStore.getDefaultBoolean("kiml.oblique.route"));
        for (OptionsTableProvider.DataEntry entry : this.optionEntries) {
            entry.setValue(null);
        }
        this.optionTableViewer.refresh();
    }

    public boolean performOk() {
        EclipseLayoutInfoService infoService = EclipseLayoutInfoService.getInstance();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("de.cau.cs.kieler.kiml.animation", this.animationCheckBox.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.kiml.zoomToFit", this.zoomCheckBox.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.kiml.progressDialog", this.progressCheckBox.getSelection());
        preferenceStore.setValue("kiml.oblique.route", this.obliqueCheckBox.getSelection());
        for (OptionsTableProvider.DataEntry entry : this.optionEntries) {
            Object oldValue = infoService.getOptionValue(entry.getElementId(), entry.getOptionData().getId());
            Object newValue = entry.getValue();
            if ((oldValue != null || newValue == null) && oldValue.equals(newValue)) continue;
            String preference = EclipseLayoutInfoService.getPreferenceName(entry.getElementId(), entry.getOptionData().getId());
            if (newValue == null) {
                infoService.removeOptionValue(entry.getElementId(), entry.getOptionData().getId());
                preferenceStore.setToDefault(preference);
                infoService.getRegisteredElements().remove(entry.getElementId());
                continue;
            }
            infoService.addOptionValue(entry.getElementId(), entry.getOptionData().getId(), newValue);
            preferenceStore.setValue(preference, newValue.toString());
            if (entry.getType() == ElementType.DIAG_TYPE) continue;
            infoService.getRegisteredElements().add(entry.getElementId());
        }
        LayoutViewPart layoutView = LayoutViewPart.findView();
        if (layoutView != null) {
            layoutView.refresh();
        }
        return true;
    }
}

