/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.awt.geom.Rectangle2D;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSizeAnalysis
implements IAnalysis {
    public static final String ANALYSIS_ID = "de.cau.cs.kieler.kiml.grana.nodeSize";
    public static final int INDEX_MIN = 0;
    public static final int INDEX_AVG = 1;
    public static final int INDEX_MAX = 2;
    public static final int INDEX_NODES = 3;

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Node size analysis", 1.0f);
        NodeSizeAnalysisState state = new NodeSizeAnalysisState();
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        for (KNode node : parentNode.getChildren()) {
            this.computeNodeSizes(node, state, hierarchy);
        }
        progressMonitor.done();
        return new Object[]{(int)state.minSize, Float.valueOf(state.sumOfSize / (float)state.nodes), (int)state.maxSize, state.nodes};
    }

    private void computeNodeSizes(KNode node, NodeSizeAnalysisState state, boolean hierarchy) {
        if (!hierarchy || node.getChildren().isEmpty()) {
            Rectangle2D.Float nodeRect = NodeSizeAnalysis.computeNodeRect(node, true, true, true);
            float nodeSize = nodeRect.width * nodeRect.height;
            NodeSizeAnalysisState nodeSizeAnalysisState = state;
            nodeSizeAnalysisState.nodes = nodeSizeAnalysisState.nodes + 1;
            state.minSize = Math.min(state.minSize, nodeSize);
            state.maxSize = Math.max(state.maxSize, nodeSize);
            NodeSizeAnalysisState nodeSizeAnalysisState2 = state;
            nodeSizeAnalysisState2.sumOfSize = nodeSizeAnalysisState2.sumOfSize + nodeSize;
        } else {
            for (KNode child : node.getChildren()) {
                this.computeNodeSizes(child, state, hierarchy);
            }
        }
    }

    public static Rectangle2D.Float computeNodeRect(KNode node, boolean includeLabel, boolean includePorts, boolean includePortLabels) {
        float nodeTopLeftX = 0.0f;
        float nodeTopLeftY = 0.0f;
        float nodeBottomRightX = 0.0f;
        float nodeBottomRightY = 0.0f;
        KShapeLayout layoutData = (KShapeLayout)node.getData(KShapeLayout.class);
        nodeBottomRightX = layoutData.getWidth();
        nodeBottomRightY = layoutData.getHeight();
        if (includeLabel) {
            for (KLabel label : node.getLabels()) {
                KShapeLayout labelLayoutData = (KShapeLayout)label.getData(KShapeLayout.class);
                nodeTopLeftX = Math.min(nodeTopLeftX, labelLayoutData.getXpos());
                nodeTopLeftY = Math.min(nodeTopLeftY, labelLayoutData.getYpos());
                nodeBottomRightX = Math.max(nodeBottomRightX, labelLayoutData.getXpos() + labelLayoutData.getWidth());
                nodeBottomRightY = Math.max(nodeBottomRightY, labelLayoutData.getYpos() + labelLayoutData.getHeight());
            }
        }
        if (includePorts) {
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayoutData = (KShapeLayout)port.getData(KShapeLayout.class);
                nodeTopLeftX = Math.min(nodeTopLeftX, portLayoutData.getXpos());
                nodeTopLeftY = Math.min(nodeTopLeftY, portLayoutData.getYpos());
                nodeBottomRightX = Math.max(nodeBottomRightX, portLayoutData.getXpos() + portLayoutData.getWidth());
                nodeBottomRightY = Math.max(nodeBottomRightY, portLayoutData.getYpos() + portLayoutData.getHeight());
                if (!includePortLabels) continue;
                for (KLabel label : port.getLabels()) {
                    KShapeLayout labelLayoutData = (KShapeLayout)label.getData(KShapeLayout.class);
                    nodeTopLeftX = Math.min(nodeTopLeftX, portLayoutData.getXpos() + labelLayoutData.getXpos());
                    nodeTopLeftY = Math.min(nodeTopLeftY, portLayoutData.getYpos() + labelLayoutData.getYpos());
                    nodeBottomRightX = Math.max(nodeBottomRightX, portLayoutData.getXpos() + labelLayoutData.getXpos() + labelLayoutData.getWidth());
                    nodeBottomRightY = Math.max(nodeBottomRightY, portLayoutData.getYpos() + labelLayoutData.getYpos() + labelLayoutData.getHeight());
                }
            }
        }
        return new Rectangle2D.Float(nodeTopLeftX + layoutData.getXpos(), nodeTopLeftY + layoutData.getYpos(), nodeBottomRightX - nodeTopLeftX, nodeBottomRightY - nodeTopLeftY);
    }

    private static class NodeSizeAnalysisState {
        private int nodes = 0;
        private float maxSize = Float.NEGATIVE_INFINITY;
        private float minSize = Float.POSITIVE_INFINITY;
        private float sumOfSize = 0.0f;

        private NodeSizeAnalysisState() {
        }
    }
}

