/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersAnalysis
implements IAnalysis {
    private static void insert(List<Layer> layers, float start, float end) {
        Layer insertLayer = null;
        Iterator<Layer> layerIter = layers.iterator();
        while (layerIter.hasNext()) {
            Layer currentLayer = layerIter.next();
            if (!(start <= currentLayer.end) || !(end >= currentLayer.start)) continue;
            if (insertLayer == null) {
                insertLayer = currentLayer;
                insertLayer.start = Math.min(insertLayer.start, start);
                insertLayer.end = Math.max(insertLayer.end, end);
                continue;
            }
            layerIter.remove();
            insertLayer.start = Math.min(insertLayer.start, currentLayer.start);
            insertLayer.end = Math.max(insertLayer.end, currentLayer.end);
        }
        if (insertLayer == null) {
            Layer newLayer = new Layer(start, end);
            layers.add(newLayer);
        }
    }

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Layers Analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int[] count = this.countLayers(parentNode, hierarchy);
        progressMonitor.done();
        return new Object[]{count[0], count[1]};
    }

    public int[] countLayers(KNode parentNode, boolean hierarchy) {
        LinkedList<Layer> horizontalLayers = new LinkedList<Layer>();
        for (KNode node : parentNode.getChildren()) {
            Iterator nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            float start = nodeLayout.getYpos();
            float end = start + nodeLayout.getHeight();
            LayersAnalysis.insert(horizontalLayers, start, end);
        }
        LinkedList<Layer> verticalLayers = new LinkedList<Layer>();
        for (KNode node : parentNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            float start = nodeLayout.getXpos();
            float end = start + nodeLayout.getWidth();
            LayersAnalysis.insert(verticalLayers, start, end);
        }
        int[] count = new int[]{horizontalLayers.size(), verticalLayers.size()};
        if (hierarchy) {
            for (KNode child : parentNode.getChildren()) {
                if (child.getChildren().isEmpty()) continue;
                int[] childResult = this.countLayers(child, true);
                count[0] = count[0] + childResult[0];
                count[1] = count[1] + childResult[1];
            }
        }
        return count;
    }

    private static final class Layer {
        private float start;
        private float end;

        private Layer(float thestart, float theend) {
            this.start = thestart;
            this.end = theend;
        }
    }
}

