/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeLengthAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.edgeLength";

    public static float computeEdgeLength(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        float edgeLength = 0.0f;
        KPoint current = edgeLayout.getSourcePoint();
        for (KPoint point : edgeLayout.getBendPoints()) {
            float deltaX = current.getX() - point.getX();
            float deltaY = current.getY() - point.getY();
            edgeLength = (float)((double)edgeLength + Math.sqrt(deltaX * deltaX + deltaY * deltaY));
            current = point;
        }
        float deltaX = current.getX() - edgeLayout.getTargetPoint().getX();
        float deltaY = current.getY() - edgeLayout.getTargetPoint().getY();
        edgeLength = (float)((double)edgeLength + Math.sqrt(deltaX * deltaX + deltaY * deltaY));
        return edgeLength;
    }

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Edge length analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int numberOfEdges = 0;
        float overallEdgeLength = 0.0f;
        float minEdgeLength = Float.MAX_VALUE;
        float maxEdgeLength = 0.0f;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            for (KEdge edge : node.getOutgoingEdges()) {
                if (!hierarchy && edge.getTarget().getParent() != parentNode) continue;
                ++numberOfEdges;
                float edgeLength = EdgeLengthAnalysis.computeEdgeLength(edge);
                overallEdgeLength += edgeLength;
                if (edgeLength < minEdgeLength) {
                    minEdgeLength = edgeLength;
                }
                if (!(edgeLength > maxEdgeLength)) continue;
                maxEdgeLength = edgeLength;
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        progressMonitor.done();
        if (numberOfEdges > 0) {
            return new Object[]{Float.valueOf(minEdgeLength), Float.valueOf(overallEdgeLength / (float)numberOfEdges), Float.valueOf(maxEdgeLength)};
        }
        return new Object[]{0, Float.valueOf(0.0f), 0};
    }
}

