/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedCycleAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.directedCycles";
    private int[] indeg;
    private int[] outdeg;
    private int[] mark;
    private Map<KNode, Integer> idmap = new HashMap<KNode, Integer>();
    private final LinkedList<KNode> sources = new LinkedList();
    private final LinkedList<KNode> sinks = new LinkedList();

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        int count;
        progressMonitor.begin("Approximate directed cycle count", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        if (hierarchy) {
            LinkedList<KNode> nodes = new LinkedList<KNode>();
            LinkedList nodeQueue = new LinkedList();
            nodeQueue.addAll(parentNode.getChildren());
            while (!nodeQueue.isEmpty()) {
                KNode node = (KNode)nodeQueue.removeFirst();
                nodes.add(node);
                nodeQueue.addAll(node.getChildren());
            }
            count = this.process(nodes, true);
        } else {
            count = this.process((List<KNode>)parentNode.getChildren(), false);
        }
        progressMonitor.done();
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private int process(List<KNode> nodes, boolean hierarchy) {
        unprocessedNodes = nodes.size();
        this.indeg = new int[unprocessedNodes];
        this.outdeg = new int[unprocessedNodes];
        this.mark = new int[unprocessedNodes];
        index = 0;
        for (KNode node : nodes) {
            this.idmap.put(node, index);
            for (KEdge edge : node.getIncomingEdges()) {
                if (edge.getSource() == node || !hierarchy && edge.getSource().getParent() != node.getParent()) continue;
                v0 = index;
                this.indeg[v0] = this.indeg[v0] + 1;
            }
            for (KEdge edge : node.getOutgoingEdges()) {
                if (edge.getTarget() == node || !hierarchy && edge.getTarget().getParent() != node.getParent()) continue;
                v1 = index;
                this.outdeg[v1] = this.outdeg[v1] + 1;
            }
            if (this.outdeg[index] == 0) {
                this.sinks.add(node);
            } else if (this.indeg[index] == 0) {
                this.sources.add(node);
            }
            ++index;
        }
        nextRight = -1;
        nextLeft = 1;
        random = new Random(1L);
        maxNodes = new ArrayList<KNode>();
        ** GOTO lbl60
        {
            sink = this.sinks.removeFirst();
            this.mark[this.idmap.get((Object)sink).intValue()] = nextRight--;
            this.updateNeighbors(sink);
            --unprocessedNodes;
            do {
                if (!this.sinks.isEmpty()) continue block3;
                while (!this.sources.isEmpty()) {
                    source = this.sources.removeFirst();
                    this.mark[this.idmap.get((Object)source).intValue()] = nextLeft++;
                    this.updateNeighbors(source);
                    --unprocessedNodes;
                }
                if (unprocessedNodes <= 0) continue;
                maxOutflow = -2147483648;
                for (KNode node : nodes) {
                    id = this.idmap.get(node);
                    if (this.mark[id] != 0 || (outflow = this.outdeg[id] - this.indeg[id]) < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxNodes.clear();
                        maxOutflow = outflow;
                    }
                    maxNodes.add(node);
                }
                maxNode = (KNode)maxNodes.get(random.nextInt(maxNodes.size()));
                this.mark[this.idmap.get((Object)maxNode).intValue()] = nextLeft++;
                this.updateNeighbors(maxNode);
                --unprocessedNodes;
lbl60:
                // 3 sources

            } while (unprocessedNodes > 0);
        }
        shiftBase = nodes.size() + 1;
        index = 0;
        while (index < nodes.size()) {
            if (this.mark[index] < 0) {
                v2 = index;
                this.mark[v2] = this.mark[v2] + shiftBase;
            }
            ++index;
        }
        backEdgeCount = 0;
        for (KNode node : nodes) {
            sourceIx = this.idmap.get(node);
            for (KEdge edge : node.getOutgoingEdges()) {
                if (edge.getTarget() == node || !this.idmap.containsKey(edge.getTarget()) || this.mark[sourceIx] <= this.mark[targetIx = this.idmap.get(edge.getTarget()).intValue()]) continue;
                ++backEdgeCount;
            }
        }
        this.dispose();
        return backEdgeCount;
    }

    private void dispose() {
        this.indeg = null;
        this.outdeg = null;
        this.mark = null;
        this.sources.clear();
        this.sinks.clear();
        this.idmap.clear();
    }

    private void updateNeighbors(KNode node) {
        for (KEdge edge : Iterables.concat((Iterable)node.getOutgoingEdges(), (Iterable)node.getIncomingEdges())) {
            int index;
            KNode endpoint;
            KNode kNode = endpoint = edge.getSource() == node ? edge.getTarget() : edge.getSource();
            if (endpoint == node || !this.idmap.containsKey(endpoint) || this.mark[index = this.idmap.get(endpoint).intValue()] != 0) continue;
            if (edge.getTarget() == endpoint) {
                int n = index;
                this.indeg[n] = this.indeg[n] - 1;
                if (this.indeg[index] > 0 || this.outdeg[index] <= 0) continue;
                this.sources.add(endpoint);
                continue;
            }
            int n = index;
            this.outdeg[n] = this.outdeg[n] - 1;
            if (this.outdeg[index] > 0 || this.indeg[index] <= 0) continue;
            this.sinks.add(endpoint);
        }
    }
}

