/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import de.cau.cs.kieler.kiml.options.GraphFeature;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionLayoutDataService
extends LayoutDataService {
    public static final String EXTP_ID_LAYOUT_PROVIDERS = "de.cau.cs.kieler.kiml.layoutProviders";
    public static final String ELEMENT_LAYOUT_ALGORITHM = "layoutAlgorithm";
    public static final String ELEMENT_LAYOUT_TYPE = "layoutType";
    public static final String ELEMENT_CATEGORY = "category";
    public static final String ELEMENT_DEPENDENCY = "dependency";
    public static final String ELEMENT_KNOWN_OPTION = "knownOption";
    public static final String ELEMENT_LAYOUT_OPTION = "layoutOption";
    public static final String ELEMENT_SUPPORTED_DIAGRAM = "supportedDiagram";
    public static final String ELEMENT_SUPPORTED_FEATURE = "supportedFeature";
    public static final String ATTRIBUTE_ADVANCED = "advanced";
    public static final String ATTRIBUTE_APPLIESTO = "appliesTo";
    public static final String ATTRIBUTE_CATEGORY = "category";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_DEFAULT = "default";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_ENUMVALUES = "enumValues";
    public static final String ATTRIBUTE_FEATURE = "feature";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_IMPLEMENTATION = "implementation";
    public static final String ATTRIBUTE_LOWER_BOUND = "lowerBound";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_OPTION = "option";
    public static final String ATTRIBUTE_PARAMETER = "parameter";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_UPPER_BOUND = "upperBound";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_VARIANCE = "variance";
    private static final String PLUGIN_ID = "de.cau.cs.kieler.kiml";

    protected abstract void reportError(String var1, IConfigurationElement var2, String var3, Throwable var4);

    protected abstract void reportError(CoreException var1);

    protected IConfigurationElement[] getProviderExtensions() {
        IConfigurationElement[] result = null;
        IExtensionRegistry registry = null;
        try {
            registry = Platform.getExtensionRegistry();
        }
        catch (Exception exception) {}
        if (registry != null) {
            result = registry.getConfigurationElementsFor(EXTP_ID_LAYOUT_PROVIDERS);
        }
        return result;
    }

    protected void loadLayoutProviderExtensions() {
        LinkedList<String[]> knownOptions = new LinkedList<String[]>();
        LinkedList<String[]> dependencies = new LinkedList<String[]>();
        IConfigurationElement[] extensions = this.getProviderExtensions();
        if (extensions == null || extensions.length == 0) {
            return;
        }
        LayoutDataService.Registry registry = ExtensionLayoutDataService.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEMENT_LAYOUT_ALGORITHM.equals(element.getName())) {
                this.loadLayoutAlgorithm(element, knownOptions);
            } else if (ELEMENT_LAYOUT_OPTION.equals(element.getName())) {
                this.loadLayoutOption(element, dependencies);
            } else if (ELEMENT_LAYOUT_TYPE.equals(element.getName())) {
                id = element.getAttribute(ATTRIBUTE_ID);
                if (id == null || id.length() == 0) {
                    this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_ID, null);
                } else {
                    LayoutTypeData typeData = new LayoutTypeData();
                    typeData.setId(id);
                    typeData.setName(element.getAttribute(ATTRIBUTE_NAME));
                    typeData.setDescription(element.getAttribute(ATTRIBUTE_DESCRIPTION));
                    registry.addLayoutType(typeData);
                }
            } else if ("category".equals(element.getName())) {
                id = element.getAttribute(ATTRIBUTE_ID);
                String name = element.getAttribute(ATTRIBUTE_NAME);
                if (id == null || id.length() == 0) {
                    this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_ID, null);
                } else if (name == null) {
                    this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_NAME, null);
                } else {
                    registry.addCategory(id, name);
                }
            }
            ++n2;
        }
        for (String[] entry : knownOptions) {
            LayoutAlgorithmData algoData = this.getAlgorithmData(entry[0]);
            LayoutOptionData optionData = this.getOptionData(entry[1]);
            if (algoData == null || optionData == null) continue;
            try {
                Object defaultValue = optionData.parseValue(entry[2]);
                algoData.setOption(optionData, defaultValue);
            }
            catch (IllegalStateException exception) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, null, null, exception);
            }
        }
        for (String[] entry : dependencies) {
            LayoutOptionData sourceOption = this.getOptionData(entry[0]);
            LayoutOptionData targetOption = this.getOptionData(entry[1]);
            if (sourceOption == null || targetOption == null) continue;
            try {
                Object value = targetOption.parseValue(entry[2]);
                sourceOption.getDependencies().add(new Pair((Object)targetOption, value));
            }
            catch (IllegalStateException exception) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, null, null, exception);
            }
        }
    }

    protected LayoutAlgorithmData createLayoutAlgorithmData(IConfigurationElement element) {
        return new LayoutAlgorithmData();
    }

    protected IFactory<AbstractLayoutProvider> getLayoutProviderFactory(final IConfigurationElement element) {
        return new IFactory<AbstractLayoutProvider>(){

            public AbstractLayoutProvider create() {
                try {
                    AbstractLayoutProvider provider = (AbstractLayoutProvider)element.createExecutableExtension(ExtensionLayoutDataService.ATTRIBUTE_CLASS);
                    provider.initialize(element.getAttribute(ExtensionLayoutDataService.ATTRIBUTE_PARAMETER));
                    return provider;
                }
                catch (CoreException e) {
                    throw new WrappedException((Throwable)e);
                }
            }

            public void destroy(AbstractLayoutProvider provider) {
                provider.dispose();
            }
        };
    }

    protected Class<?> loadClass(IConfigurationElement element) {
        Bundle contributor;
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        if (className != null && className.length() > 0 && (contributor = Platform.getBundle((String)element.getContributor().getName())) != null) {
            try {
                Class clazz = contributor.loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException exception) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_CLASS, exception);
            }
        }
        return null;
    }

    private void loadLayoutAlgorithm(IConfigurationElement element, List<String[]> knownOptions) {
        try {
            LayoutTypeData typeData;
            String layouterId;
            IFactory<AbstractLayoutProvider> layoutProviderFactory = this.getLayoutProviderFactory(element);
            LayoutAlgorithmData algoData = this.createLayoutAlgorithmData(element);
            if (layoutProviderFactory != null) {
                algoData.createPool(layoutProviderFactory);
            }
            if ((layouterId = element.getAttribute(ATTRIBUTE_ID)) == null || layouterId.length() == 0) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_ID, null);
                return;
            }
            algoData.setId(layouterId);
            algoData.setName(element.getAttribute(ATTRIBUTE_NAME));
            algoData.setDescription(element.getAttribute(ATTRIBUTE_DESCRIPTION));
            algoData.setCategory(element.getAttribute("category"));
            String layoutType = element.getAttribute(ATTRIBUTE_TYPE);
            if (layoutType == null) {
                layoutType = "";
            }
            if ((typeData = this.getTypeData(layoutType)) == null) {
                typeData = new LayoutTypeData();
                typeData.setId(layoutType);
                ExtensionLayoutDataService.getRegistry().addLayoutType(typeData);
            }
            algoData.setType(layoutType);
            typeData.getLayouters().add(algoData);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String priority;
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (ELEMENT_KNOWN_OPTION.equals(child.getName())) {
                    String option = child.getAttribute(ATTRIBUTE_OPTION);
                    if (option != null && option.length() > 0) {
                        String defaultValue = child.getAttribute(ATTRIBUTE_DEFAULT);
                        knownOptions.add(new String[]{layouterId, option, defaultValue});
                    } else {
                        this.reportError(EXTP_ID_LAYOUT_PROVIDERS, child, ATTRIBUTE_OPTION, null);
                    }
                } else if (ELEMENT_SUPPORTED_DIAGRAM.equals(child.getName())) {
                    String type = child.getAttribute(ATTRIBUTE_TYPE);
                    if (type == null || type.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_PROVIDERS, child, ATTRIBUTE_TYPE, null);
                    } else {
                        priority = child.getAttribute(ATTRIBUTE_PRIORITY);
                        if (priority == null || priority.length() == 0) {
                            algoData.setDiagramSupport(type, 0);
                        }
                        try {
                            algoData.setDiagramSupport(type, Integer.parseInt(priority));
                        }
                        catch (NumberFormatException exception) {
                            this.reportError(EXTP_ID_LAYOUT_PROVIDERS, child, ATTRIBUTE_PRIORITY, exception);
                        }
                    }
                } else if (ELEMENT_SUPPORTED_FEATURE.equals(child.getName())) {
                    String featureString = child.getAttribute(ATTRIBUTE_FEATURE);
                    if (featureString == null || featureString.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_PROVIDERS, child, ATTRIBUTE_FEATURE, null);
                    } else {
                        priority = child.getAttribute(ATTRIBUTE_PRIORITY);
                        try {
                            GraphFeature feature = GraphFeature.valueOf((String)featureString.toUpperCase());
                            if (priority == null || priority.length() == 0) {
                                algoData.setFeatureSupport(feature, 0);
                            } else {
                                algoData.setFeatureSupport(feature, Integer.parseInt(priority));
                            }
                        }
                        catch (IllegalArgumentException exception) {
                            this.reportError(EXTP_ID_LAYOUT_PROVIDERS, child, ATTRIBUTE_FEATURE, exception);
                        }
                    }
                }
                ++n2;
            }
            ExtensionLayoutDataService.getRegistry().addLayoutProvider(algoData);
        }
        catch (Throwable throwable) {
            this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_CLASS, throwable);
        }
    }

    private void loadLayoutOption(IConfigurationElement element, List<String[]> dependencies) {
        String optionId;
        LayoutOptionData optionData;
        block17: {
            optionData = new LayoutOptionData();
            optionId = element.getAttribute(ATTRIBUTE_ID);
            if (optionId == null || optionId.length() == 0) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_ID, null);
                return;
            }
            optionData.setId(optionId);
            String optionType = element.getAttribute(ATTRIBUTE_TYPE);
            try {
                if (optionType.equals("remoteenum")) {
                    String implementation = element.getAttribute(ATTRIBUTE_IMPLEMENTATION);
                    if (implementation != null) {
                        try {
                            Class enumClass = Platform.getBundle((String)PLUGIN_ID).loadClass(implementation);
                            optionData.setType(LayoutOptionData.Type.ENUM);
                            optionData.setOptionClass(enumClass);
                        }
                        catch (Exception exception) {
                            optionData.setType(LayoutOptionData.Type.UNDEFINED);
                        }
                    }
                    if (optionData.getType().equals((Object)LayoutOptionData.Type.UNDEFINED)) {
                        optionData.setType(LayoutOptionData.Type.REMOTE_ENUM);
                        optionData.parseRemoteEnumValues(element.getAttribute(ATTRIBUTE_ENUMVALUES));
                    }
                    break block17;
                }
                optionData.setType(optionType);
                optionData.setOptionClass(this.loadClass(element));
            }
            catch (IllegalArgumentException exception) {
                this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_TYPE, exception);
                return;
            }
        }
        try {
            Object defaultValue = optionData.parseValue(element.getAttribute(ATTRIBUTE_DEFAULT));
            optionData.setDefault(defaultValue);
            Object lowerBound = optionData.parseValue(element.getAttribute(ATTRIBUTE_LOWER_BOUND));
            optionData.setLowerBound(lowerBound);
            Object upperBound = optionData.parseValue(element.getAttribute(ATTRIBUTE_UPPER_BOUND));
            optionData.setUpperBound(upperBound);
        }
        catch (IllegalStateException exception) {
            this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_CLASS, exception);
        }
        optionData.setName(element.getAttribute(ATTRIBUTE_NAME));
        optionData.setDescription(element.getAttribute(ATTRIBUTE_DESCRIPTION));
        optionData.setTargets(element.getAttribute(ATTRIBUTE_APPLIESTO));
        String advanced = element.getAttribute(ATTRIBUTE_ADVANCED);
        optionData.setAdvanced(advanced != null && advanced.equals("true"));
        try {
            String varianceString = element.getAttribute(ATTRIBUTE_VARIANCE);
            if (varianceString != null) {
                optionData.setVariance(Float.parseFloat(varianceString));
            }
        }
        catch (NumberFormatException exception) {
            this.reportError(EXTP_ID_LAYOUT_PROVIDERS, element, ATTRIBUTE_VARIANCE, exception);
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement childElement = iConfigurationElementArray[n2];
            if (ELEMENT_DEPENDENCY.equals(childElement.getName())) {
                String depId = childElement.getAttribute(ATTRIBUTE_OPTION);
                if (depId == null || depId.length() == 0) {
                    this.reportError(EXTP_ID_LAYOUT_PROVIDERS, childElement, ATTRIBUTE_OPTION, null);
                } else {
                    dependencies.add(new String[]{optionId, depId, childElement.getAttribute(ATTRIBUTE_VALUE)});
                }
            }
            ++n2;
        }
        ExtensionLayoutDataService.getRegistry().addLayoutOption(optionData);
    }
}

