/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphiti;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.graphiti.KimlGraphitiUtil;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KEdgeLayoutImpl;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KShapeLayoutImpl;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class GraphitiLayoutCommand
extends RecordingCommand {
    public static final IProperty<KInsets> INVIS_INSETS = new Property("graphiti.layout.invisibleInsets");
    private List<Pair<KGraphElement, PictogramElement>> elements = new LinkedList<Pair<KGraphElement, PictogramElement>>();
    private IFeatureProvider featureProvider;
    private Map<KEdgeLayout, KVectorChain> bendpointsMap = new HashMap<KEdgeLayout, KVectorChain>();

    public GraphitiLayoutCommand(TransactionalEditingDomain domain, IFeatureProvider thefeatureProvider) {
        super(domain, "Automatic Layout");
        this.featureProvider = thefeatureProvider;
    }

    protected IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void add(KGraphElement graphElement, PictogramElement pictogramElement) {
        boolean modified = false;
        if (graphElement instanceof KEdge) {
            KEdgeLayoutImpl edgeLayout = (KEdgeLayoutImpl)graphElement.getData(KEdgeLayoutImpl.class);
            modified = edgeLayout.isModified();
        } else {
            KShapeLayoutImpl shapeLayout = (KShapeLayoutImpl)graphElement.getData(KShapeLayoutImpl.class);
            modified = shapeLayout.isModified();
        }
        if (modified) {
            this.elements.add((Pair<KGraphElement, PictogramElement>)new Pair((Object)graphElement, (Object)pictogramElement));
        }
    }

    protected void doExecute() {
        for (Pair<KGraphElement, PictogramElement> entry : this.elements) {
            KGraphElement element = (KGraphElement)entry.getFirst();
            if (element instanceof KPort) {
                this.applyPortLayout((KPort)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof KNode) {
                this.applyNodeLayout((KNode)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof KEdge) {
                this.applyEdgeLayout((KEdge)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (!(element instanceof KLabel) || !(((KLabel)element).eContainer() instanceof KEdge)) continue;
            this.applyEdgeLabelLayout((KLabel)element, (PictogramElement)entry.getSecond());
        }
        this.bendpointsMap.clear();
    }

    protected void applyPortLayout(KPort kport, PictogramElement pelem) {
        KShapeLayout shapeLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        this.applyPortLayout(shapeLayout.getXpos(), shapeLayout.getYpos(), pelem, kport.getNode());
    }

    protected void applyPortLayout(double xpos, double ypos, PictogramElement pelem, KNode knode) {
        int offsetx = 0;
        int offsety = 0;
        if (pelem.getGraphicsAlgorithm() != null) {
            offsetx = pelem.getGraphicsAlgorithm().getX();
            offsety = pelem.getGraphicsAlgorithm().getY();
        }
        if (pelem instanceof BoxRelativeAnchor) {
            double relHeight;
            BoxRelativeAnchor anchor = (BoxRelativeAnchor)pelem;
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            double relWidth = (xpos - (double)offsetx) / (double)nodeLayout.getWidth();
            if (relWidth < 0.0) {
                relWidth = 0.0;
            }
            if (relWidth > 1.0) {
                relWidth = 1.0;
            }
            if ((relHeight = (ypos - (double)offsety) / (double)nodeLayout.getHeight()) < 0.0) {
                relHeight = 0.0;
            }
            if (relHeight > 1.0) {
                relHeight = 1.0;
            }
            anchor.setRelativeWidth(relWidth);
            anchor.setRelativeHeight(relHeight);
            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
        } else if (pelem instanceof FixPointAnchor) {
            FixPointAnchor anchor = (FixPointAnchor)pelem;
            anchor.getLocation().setX((int)(xpos - (double)offsetx));
            anchor.getLocation().setY((int)(ypos - (double)offsety));
        }
    }

    protected void applyNodeLayout(KNode knode, PictogramElement pelem) {
        KInsets parentInsets;
        KShapeLayout shapeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        float xpos = shapeLayout.getXpos();
        float ypos = shapeLayout.getYpos();
        if (knode.getParent() != null && (parentInsets = (KInsets)((KShapeLayout)knode.getParent().getData(KShapeLayout.class)).getProperty(INVIS_INSETS)) != null) {
            xpos += parentInsets.getLeft();
            ypos += parentInsets.getRight();
        }
        float width = shapeLayout.getWidth();
        float height = shapeLayout.getHeight();
        KInsets nodeInsets = (KInsets)shapeLayout.getProperty(INVIS_INSETS);
        if (nodeInsets != null) {
            xpos -= nodeInsets.getLeft();
            ypos -= nodeInsets.getTop();
            width += nodeInsets.getLeft() + nodeInsets.getRight();
            height += nodeInsets.getTop() + nodeInsets.getBottom();
        }
        ga.setX(Math.round(xpos));
        ga.setY(Math.round(ypos));
        ga.setWidth(Math.round(width));
        ga.setHeight(Math.round(height));
        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
    }

    protected void applyEdgeLayout(KEdge kedge, PictogramElement pelem) {
        KVectorChain bendPoints = this.getBendPoints(kedge);
        if (pelem instanceof FreeFormConnection) {
            FreeFormConnection connection = (FreeFormConnection)pelem;
            EList pointList = connection.getBendpoints();
            int i = 0;
            while (i < bendPoints.size()) {
                Point point;
                KVector kpoint = (KVector)bendPoints.get(i);
                if (i >= pointList.size()) {
                    point = Graphiti.getGaService().createPoint((int)Math.round(kpoint.x), (int)Math.round(kpoint.y));
                    pointList.add(point);
                } else {
                    point = (Point)pointList.get(i);
                    point.setX((int)Math.round(kpoint.x));
                    point.setY((int)Math.round(kpoint.y));
                }
                ++i;
            }
            while (pointList.size() > bendPoints.size()) {
                pointList.remove(pointList.size() - 1);
            }
            if (kedge.getSourcePort() == null) {
                KNode source = kedge.getSource();
                KPoint sourcePoint = ((KEdgeLayout)kedge.getData(KEdgeLayout.class)).getSourcePoint();
                float xpos = sourcePoint.getX();
                float ypos = sourcePoint.getY();
                if (KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)source)) {
                    KInsets insets = ((KShapeLayout)source.getData(KShapeLayout.class)).getInsets();
                    xpos += insets.getLeft();
                    ypos += insets.getTop();
                } else {
                    KShapeLayout sourceLayout = (KShapeLayout)source.getData(KShapeLayout.class);
                    xpos -= sourceLayout.getXpos();
                    ypos -= sourceLayout.getYpos();
                }
                this.applyPortLayout(xpos, ypos, (PictogramElement)connection.getStart(), source);
            }
            if (kedge.getTargetPort() == null) {
                KNode target = kedge.getTarget();
                KVector targetPoint = ((KEdgeLayout)kedge.getData(KEdgeLayout.class)).getTargetPoint().createVector();
                KNode referenceNode = kedge.getSource();
                if (!KimlUtil.isDescendant((KNode)target, (KNode)referenceNode)) {
                    referenceNode = referenceNode.getParent();
                }
                KimlUtil.toAbsolute((KVector)targetPoint, (KNode)referenceNode);
                KimlUtil.toRelative((KVector)targetPoint, (KNode)target);
                this.applyPortLayout(targetPoint.x, targetPoint.y, (PictogramElement)connection.getEnd(), target);
            }
        }
    }

    public KVectorChain getBendPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KVectorChain bendPoints = this.bendpointsMap.get(edgeLayout);
        if (bendPoints == null) {
            KNode parent = edge.getSource();
            if (!KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
                parent = parent.getParent();
            }
            KVector offset = new KVector();
            KimlUtil.toAbsolute((KVector)offset, (KNode)parent);
            bendPoints = new KVectorChain();
            KPoint sourcePoint = edgeLayout.getSourcePoint();
            bendPoints.add((double)sourcePoint.getX() + offset.x, (double)sourcePoint.getY() + offset.y);
            for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                bendPoints.add((double)bendPoint.getX() + offset.x, (double)bendPoint.getY() + offset.y);
            }
            KPoint targetPoint = edgeLayout.getTargetPoint();
            bendPoints.add((double)targetPoint.getX() + offset.x, (double)targetPoint.getY() + offset.y);
            EdgeRouting edgeRouting = (EdgeRouting)edgeLayout.getProperty(LayoutOptions.EDGE_ROUTING);
            if (edgeRouting == EdgeRouting.SPLINES && edgeLayout.getBendPoints().size() >= 1) {
                bendPoints = KielerMath.approximateSpline((KVectorChain)bendPoints);
            }
            bendPoints.removeFirst();
            bendPoints.removeLast();
            this.bendpointsMap.put(edgeLayout, bendPoints);
        }
        return bendPoints;
    }

    protected void applyEdgeLabelLayout(KLabel klabel, PictogramElement pelem) {
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        ConnectionDecorator decorator = (ConnectionDecorator)pelem;
        KEdge kedge = (KEdge)klabel.eContainer();
        KVectorChain bendPoints = new KVectorChain((Collection)this.getBendPoints(kedge));
        KVector sourcePoint = KimlGraphitiUtil.calculateAnchorEnds(kedge.getSource(), kedge.getSourcePort(), null);
        bendPoints.addFirst((Object)sourcePoint);
        KVector targetPoint = KimlGraphitiUtil.calculateAnchorEnds(kedge.getTarget(), kedge.getTargetPort(), null);
        bendPoints.addLast((Object)targetPoint);
        KVector referencePoint = decorator.isLocationRelative() ? bendPoints.getPointOnLine(decorator.getLocation() * bendPoints.getLength()) : bendPoints.getPointOnLine(decorator.getLocation());
        KShapeLayout shapeLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
        KVector position = shapeLayout.createVector();
        KNode parent = kedge.getSource();
        if (!KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)parent)) {
            parent = parent.getParent();
        }
        KimlUtil.toAbsolute((KVector)position, (KNode)parent);
        ga.setX((int)Math.round(position.x - referencePoint.x));
        ga.setY((int)Math.round(position.y - referencePoint.y));
    }
}

