/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf;

import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.gmf.GmfDiagramLayoutManager;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GefDiagramLayoutManager<T>
implements IDiagramLayoutManager<T> {
    public static final IProperty<Integer> ANIMATION_TIME = new Property("gef.animationTime", (Object)0);

    public void applyLayout(LayoutMapping<T> mapping, boolean zoomToFit, int animationTime) {
        mapping.setProperty(ANIMATION_TIME, (Object)animationTime);
        Object layoutGraphObj = mapping.getParentElement();
        if (zoomToFit && layoutGraphObj instanceof EditPart) {
            double oldScale;
            float desiredHeight;
            double scaleY;
            DiagramEditPart diagramEditPart = GmfDiagramLayoutManager.getDiagramEditPart((EditPart)layoutGraphObj);
            if (diagramEditPart == null) {
                this.applyLayout(mapping, animationTime);
                return;
            }
            ZoomManager zoomManager = ((RenderedDiagramRootEditPart)diagramEditPart.getRoot()).getZoomManager();
            KNode parentNode = mapping.getLayoutGraph();
            KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
            Dimension available = zoomManager.getViewport().getClientArea().getSize();
            float desiredWidth = parentLayout.getWidth();
            double scaleX = Math.min((double)((float)available.width / desiredWidth), zoomManager.getMaxZoom());
            double scale = Math.min(scaleX, scaleY = Math.min((double)((float)available.height / (desiredHeight = parentLayout.getHeight())), zoomManager.getMaxZoom()));
            if (scale < (oldScale = zoomManager.getZoom())) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
            this.applyLayout(mapping, animationTime);
            if (scale > oldScale) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
        } else {
            this.applyLayout(mapping, animationTime);
        }
    }

    private void applyLayout(LayoutMapping<T> mapping, int animationTime) {
        this.transferLayout(mapping);
        if (animationTime > 0) {
            Animation.markBegin();
            this.applyLayout(mapping);
            Animation.run((int)animationTime);
        } else {
            this.applyLayout(mapping);
        }
    }

    protected abstract void transferLayout(LayoutMapping<T> var1);

    protected abstract void applyLayout(LayoutMapping<T> var1);

    public void undoLayout(LayoutMapping<T> mapping) {
        int animationTime = (Integer)mapping.getProperty(ANIMATION_TIME);
        if (animationTime > 0) {
            Animation.markBegin();
            this.performUndo(mapping);
            Animation.run((int)animationTime);
        } else {
            this.performUndo(mapping);
        }
    }

    protected void performUndo(LayoutMapping<T> mapping) {
        throw new UnsupportedOperationException("Undo is not supported by this layout manager.");
    }
}

