/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ForwardingInputStream
extends InputStream {
    private InputStream inputStream;
    private OutputStream outputStream;

    public ForwardingInputStream(InputStream theinputStream, OutputStream theoutputStream) {
        this.inputStream = theinputStream;
        this.outputStream = theoutputStream;
    }

    public int read() throws IOException {
        int data = this.inputStream.read();
        if (data >= 0) {
            this.outputStream.write(data);
        }
        return data;
    }

    public int read(byte[] b) throws IOException {
        int count = this.inputStream.read(b);
        if (count > 0) {
            this.outputStream.write(b, 0, count);
        }
        return count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.inputStream.read(b, off, len);
        if (count > 0) {
            this.outputStream.write(b, off, count);
        }
        return count;
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

