/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.alg;

import de.cau.cs.kieler.core.alg.IFactory;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancePool<T> {
    public static final int INFINITE = -1;
    private IFactory<T> factory;
    private LinkedList<T> instances = new LinkedList();
    private int limit;

    public InstancePool(IFactory<T> thefactory) {
        this(thefactory, -1);
    }

    public InstancePool(IFactory<T> thefactory, int thelimit) {
        assert (thefactory != null);
        this.factory = thefactory;
        this.limit = thelimit;
    }

    public synchronized T fetch() {
        if (this.instances.isEmpty()) {
            return this.factory.create();
        }
        return this.instances.removeFirst();
    }

    public synchronized void release(T obj) {
        if (this.limit < 0 || this.instances.size() < this.limit) {
            this.instances.addLast(obj);
        } else {
            this.factory.destroy(obj);
        }
    }

    public synchronized void clear() {
        for (Object obj : this.instances) {
            this.factory.destroy(obj);
        }
        this.instances.clear();
    }
}

