/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class C89ArrayTypeInfo
extends ArrayTypeInfo
implements C89TypeInfo {
    public final boolean genLocalFunctions;

    public C89ArrayTypeInfo(boolean genLocalFunctions, CifType cifType, TypeInfo[] childTIs, int length) {
        super(cifType, childTIs, length);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return C89TypeInfoHelper.typeSupportsRawMemCmp(this.childInfos[0]);
    }

    @Override
    public boolean useValues() {
        return false;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return Strings.fmt((String)"%sTypePrint", (Object[])new Object[]{this.getTypeName()});
    }

    @Override
    public String getElementTargetType() {
        return this.childInfos[0].getTargetType();
    }

    @Override
    public ExprCode getProjectedValue(ExprCode containerCode, ExprCode indexCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(containerCode);
        result.add(indexCode);
        String containerRef = C89DataValue.constructReference(containerCode.getRawDataValue(), (TypeInfo)this, ctxt, result);
        String resultText = Strings.fmt((String)"%sTypeProject(%s, %s)", (Object[])new Object[]{this.getTypeName(), containerRef, indexCode.getData()});
        result.setDestination(dest);
        if (C89TypeInfoHelper.typeUsesValues(this.childInfos[0])) {
            result.setDataValue(C89DataValue.makeComputed(resultText));
        } else {
            result.setDataValue(C89DataValue.makeReference(resultText));
        }
        return result;
    }

    @Override
    public CodeBox modifyContainer(VariableInformation containerVar, ExprCode partCode, ExprCode indexCode, CodeContext ctxt) {
        MemoryCodeBox modifyCode = ctxt.makeCodeBox();
        modifyCode.add((Box)indexCode.getCode());
        modifyCode.add((Box)partCode.getCode());
        String partValue = C89TypeInfoHelper.typeUsesValues(this.childInfos[0]) ? partCode.getData() : C89DataValue.constructReference(partCode.getRawDataValue(), this.childInfos[0], ctxt, (CodeBox)modifyCode);
        modifyCode.add("%sTypeModify(&%s, %s, %s);", new Object[]{this.getTypeName(), containerVar.targetRef, indexCode.getData(), partValue});
        return modifyCode;
    }

    @Override
    public ExprCode convertLiteral(ListExpression expr, Destination dest, CodeContext ctxt) {
        String storeVar;
        ExprCode result = new ExprCode();
        if (dest == null) {
            VariableInformation tempVarInfo = ctxt.makeTempVariable(expr.getType(), "array_tmp");
            storeVar = tempVarInfo.targetRef;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), storeVar}));
            result.setDataValue(C89DataValue.makeValue(storeVar));
        } else {
            storeVar = dest.getData();
        }
        Assert.check((expr.getElements().size() == this.length ? 1 : 0) != 0);
        int i = 0;
        while (i < this.length) {
            String elementVar = Strings.fmt((String)"(%s).data[%d]", (Object[])new Object[]{storeVar, i});
            Destination elmDest = new Destination(null, this.childInfos[0], C89DataValue.makeValue(elementVar));
            ExprCode elmCode = ctxt.exprToTarget((Expression)expr.getElements().get(i), elmDest);
            result.add(elmCode);
            ++i;
        }
        return result;
    }

    @Override
    public ExprCode convertSizeStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        String value = Integer.toString(this.length);
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeLiteral(value));
        return result;
    }

    @Override
    public ExprCode convertEmptyStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeLiteral(this.length == 0 ? "TRUE" : "FALSE"));
        return result;
    }

    @Override
    public String getTargetType() {
        return Strings.fmt((String)"%sType", (Object[])new Object[]{this.getTypeName()});
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        MemoryCodeBox declCode = ctxt.makeCodeBox();
        MemoryCodeBox defCode = ctxt.makeCodeBox();
        this.generateC89Code((CodeBox)declCode, (CodeBox)defCode, ctxt);
        declCode.add();
        ctxt.appendReplacement("generated-types", declCode.toString());
        ctxt.appendReplacement("type-support-code", defCode.toString());
    }

    protected void generateC89Code(CodeBox declCode, CodeBox defCode, CodeContext ctxt) {
        String declarationPrefix;
        String definitionPrefix;
        if (this.genLocalFunctions) {
            definitionPrefix = "static ";
            declarationPrefix = "static ";
        } else {
            definitionPrefix = "";
            declarationPrefix = "extern ";
        }
        String typeName = this.getTypeName();
        String cifTypeText = CifTextUtils.typeToStr((CifType)this.cifType);
        declCode.add("/* CIF type: %s */", new Object[]{cifTypeText});
        declCode.add("struct %s_struct {", new Object[]{typeName});
        declCode.indent();
        declCode.add("%s data[%d];", new Object[]{this.getElementTargetType(), this.length});
        declCode.dedent();
        declCode.add("};");
        declCode.add("typedef struct %s_struct %sType;", new Object[]{typeName, typeName});
        declCode.add();
        String header = Strings.fmt((String)"BoolType %sTypeEquals(%s *left, %s *right)", (Object[])new Object[]{typeName, this.getTargetType(), this.getTargetType()});
        defCode.add("/**");
        defCode.add(" * Compare two arrays for equality.");
        defCode.add(" * @param left First array to compare.");
        defCode.add(" * @param right Second array to compare.");
        defCode.add(" * @return Whether both arrays are the same.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("if (left == right) return TRUE;");
        if (C89TypeInfoHelper.typeSupportsRawMemCmp(this.childInfos[0])) {
            defCode.add("return memcmp(left, right, sizeof(%s)) == 0;", new Object[]{this.getTargetType()});
        } else {
            String elmEqualsTemplate = this.childInfos[0].getBinaryExpressionTemplate(BinaryOperator.EQUAL, ctxt);
            defCode.add("int i;");
            defCode.add("for (i = 0; i < %d; i++) {", new Object[]{this.length});
            defCode.indent();
            C89DataValue leftValue = C89DataValue.makeValue("left->data[i]");
            C89DataValue rightValue = C89DataValue.makeValue("right->data[i]");
            String check = TypeInfoHelper.convertBinaryExpressionValues(leftValue, rightValue, elmEqualsTemplate);
            defCode.add("if (!(%s)) return FALSE;", new Object[]{check});
            defCode.dedent();
            defCode.add("}");
            defCode.add("return TRUE;");
        }
        defCode.dedent();
        defCode.add("}");
        defCode.add();
        boolean elmUsesValues = C89TypeInfoHelper.typeUsesValues(this.childInfos[0]);
        String elmTypeDecl = elmUsesValues ? this.childInfos[0].getTargetType() + " " : this.childInfos[0].getTargetType() + " *";
        header = Strings.fmt((String)"%s%sTypeProject(%s *array, IntType index)", (Object[])new Object[]{elmTypeDecl, typeName, this.getTargetType()});
        defCode.add("/**");
        defCode.add(" * Extract an element from the array.");
        defCode.add(" * @param array Array with value to retrieve.");
        defCode.add(" * @param index Element index in the array (not normalized).");
        defCode.add(" * @return Element value at the indicated index from the array.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("if (index < 0) index += %d; /* Normalize index. */", new Object[]{this.length});
        defCode.add("assert(index >= 0 && index < %d);", new Object[]{this.length});
        defCode.add();
        if (elmUsesValues) {
            defCode.add("return array->data[index];");
        } else {
            defCode.add("return &array->data[index];");
        }
        defCode.dedent();
        defCode.add("}");
        defCode.add();
        header = Strings.fmt((String)"void %sTypeModify(%s *array, IntType index, %svalue)", (Object[])new Object[]{typeName, this.getTargetType(), elmTypeDecl});
        defCode.add("/**");
        defCode.add(" * In-place change of the array.");
        defCode.add(" * @param array Array to modify.");
        defCode.add(" * @param index Element index in the array (not normalized).");
        defCode.add(" * @param value New value to copy into the array.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("if (index < 0) index += %d; /* Normalize index. */", new Object[]{this.length});
        defCode.add("assert(index >= 0 && index < %d);", new Object[]{this.length});
        defCode.add();
        if (elmUsesValues) {
            defCode.add("array->data[index] = value;");
        } else {
            defCode.add("memcpy(&array->data[index], value, sizeof(%s));", new Object[]{this.getElementTargetType()});
        }
        defCode.dedent();
        defCode.add("}");
        defCode.add();
        header = Strings.fmt((String)"int %sTypePrint(%s *array, char *dest, int start, int end)", (Object[])new Object[]{typeName, this.getTargetType()});
        defCode.add("/**");
        defCode.add(" * Append textual representation of the array value into the provided");
        defCode.add(" * destination, space permitting.");
        defCode.add(" * @param array Array to print.");
        defCode.add(" * @param dest Destination to write text to.");
        defCode.add(" * @param start First available offset in \\a dest for new text.");
        defCode.add(" * @param end Fist offset behind \\a dest.");
        defCode.add(" * @return First free offset in \\a dest, mat be \\a end.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("int last = end - 1;");
        defCode.add("if (start < last) { dest[start++] = '['; }");
        defCode.add("int index;");
        defCode.add("for (index = 0; index < %d; index++) {", new Object[]{this.length});
        defCode.indent();
        defCode.add("if (index > 0) {");
        defCode.indent();
        defCode.add("if (start < last) { dest[start++] = ','; }");
        defCode.add("if (start < last) { dest[start++] = ' '; }");
        defCode.dedent();
        defCode.add("}");
        String childArgument = C89TypeInfoHelper.typeUsesValues(this.childInfos[0]) ? "array->data[index]" : "&array->data[index]";
        defCode.add("start = %s(%s, dest, start, end);", new Object[]{C89TypeInfoHelper.typeGetTypePrintName(this.childInfos[0], false), childArgument});
        defCode.dedent();
        defCode.add("}");
        defCode.add("if (start < last) { dest[start++] = ']'; }");
        defCode.add("dest[start] = '\\0';");
        defCode.add("return start;");
        defCode.dedent();
        defCode.add("}");
        defCode.add();
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return Strings.fmt((String)"%sTypeEquals(${left-ref}, ${right-ref})", (Object[])new Object[]{this.getTypeName()});
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return Strings.fmt((String)"!%sTypeEquals(${left-ref}, ${right-ref})", (Object[])new Object[]{this.getTypeName()});
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof C89ArrayTypeInfo)) {
            return false;
        }
        C89ArrayTypeInfo otherArray = (C89ArrayTypeInfo)other;
        if (!this.childInfos[0].equals(otherArray.childInfos[0])) {
            return false;
        }
        return this.length == otherArray.length;
    }

    @Override
    public int hashCode() {
        int h = C89ArrayTypeInfo.class.hashCode();
        return (h += this.childInfos[0].hashCode()) + this.length;
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        C89DataValue elmRhsValue;
        ListType lhsList = (ListType)lhsType;
        ListType rhsList = (ListType)rhsType;
        if (CifTypeUtils.checkTypeCompat((CifType)lhsList.getElementType(), (CifType)rhsList.getElementType(), (RangeCompat)RangeCompat.CONTAINED)) {
            return;
        }
        String indexName = Strings.fmt((String)"rng_index%d", (Object[])new Object[]{level});
        String elemName = Strings.fmt((String)"rng_elem%d", (Object[])new Object[]{level});
        code.add("{");
        code.indent();
        code.add("int %s;", new Object[]{indexName});
        code.add("for(%s = 0; %s < %d; %s++) {", new Object[]{indexName, indexName, this.length, indexName});
        code.indent();
        boolean elmUsesValues = C89TypeInfoHelper.typeUsesValues(this.childInfos[0]);
        String elementText = rhsValue.isReferenceValue() ? Strings.fmt((String)"(%s)->data[%s]", (Object[])new Object[]{rhsValue.getReference(), indexName}) : Strings.fmt((String)"(%s).data[%s]", (Object[])new Object[]{rhsValue.getData(), indexName});
        if (elmUsesValues) {
            code.add("%s %s = %s;", new Object[]{this.childInfos[0].getTargetType(), elemName, elementText});
            elmRhsValue = C89DataValue.makeValue(elemName);
        } else {
            code.add("%s *%s = &(%s);", new Object[]{this.childInfos[0].getTargetType(), elemName, elementText});
            elmRhsValue = C89DataValue.makeReference(elemName);
        }
        int last = errorTexts.size();
        errorTexts.add(new RangeCheckErrorLevelText(true, indexName));
        this.childInfos[0].checkRange(lhsList.getElementType(), rhsList.getElementType(), elmRhsValue, varType, varName, errorTexts, level + 1, code, ctxt);
        errorTexts.remove(last);
        Assert.check((last == errorTexts.size() ? 1 : 0) != 0);
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
    }
}

