/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.util.Arrays;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.eclipse.escet.common.java.ReflectionUtils;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgUtils;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SvgUserAgent
extends UserAgentAdapter
implements CSSEngineUserAgent,
ErrorHandler {
    public Throwable problem = null;

    public void warning(CSSParseException exception) throws CSSException {
    }

    public void error(CSSParseException exception) throws CSSException {
        this.displayError((Exception)exception);
    }

    public void fatalError(CSSParseException exception) throws CSSException {
        this.displayError((Exception)exception);
    }

    public void displayError(Exception ex) {
        if (this.problem != null) {
            return;
        }
        this.problem = SvgUserAgent.convertBatikException(ex);
    }

    public static Throwable convertBatikException(Exception ex) {
        if (ex instanceof BridgeException) {
            String uri;
            String prefix;
            BridgeException bex = (BridgeException)((Object)ex);
            Object[] params = (Object[])ReflectionUtils.getFieldValue((Object)((Object)bex), (String)"params");
            int line = (Integer)ReflectionUtils.getFieldValue((Object)((Object)bex), (String)"line");
            Object rslt = ex.getCause();
            Object msg = bex.getMessage();
            msg = ((String)msg).replace("\r", "").replace("\n", " ");
            Element elem = bex.getElement();
            SVGDocument doc = null;
            if (elem != null) {
                doc = (SVGDocument)elem.getOwnerDocument();
            }
            if (((String)msg).startsWith(prefix = (uri = doc == null ? "<Unknown URI>" : doc.getURL()) + ":" + Strings.str((Object)line))) {
                msg = ((String)msg).substring(prefix.length());
            }
            msg = ((String)msg).trim();
            msg = "Problem message: " + (String)msg;
            rslt = new SvgException((String)msg, (Throwable)rslt);
            String code = bex.getCode();
            String detailsTxt = code + Arrays.deepToString(params);
            msg = Strings.fmt((String)"Problem details: %s", (Object[])new Object[]{detailsTxt});
            rslt = new SvgException((String)msg, (Throwable)rslt);
            String elemName = elem == null ? null : elem.getLocalName();
            Object elemTxt = elemName == null ? "" : "\"" + elemName + "\" ";
            String id = elem == null ? null : SvgUtils.getSvgElementId(elem);
            Object idTxt = id == null ? "unknown id" : "id \"" + id + "\"";
            msg = Strings.fmt((String)"Problem for SVG %selement with %s.", (Object[])new Object[]{elemTxt, idTxt});
            rslt = new SvgException((String)msg, (Throwable)rslt);
            return rslt;
        }
        if (ex instanceof DOMException) {
            return new SvgException("SVG DOM problem.", ex);
        }
        if (ex instanceof CSSException) {
            CSSException cssException = (CSSException)ex;
            return new SvgException("CSS problem.", (Throwable)((Object)new SvgException(ex.getMessage(), cssException.getException())));
        }
        return ex;
    }

    public void reportProblem() {
        if (this.problem == null) {
            return;
        }
        if (this.problem instanceof SvgException) {
            throw (SvgException)((Object)this.problem);
        }
        if (this.problem instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)this.problem;
        }
        String msg = Strings.fmt((String)"%s reported problem.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        throw new RuntimeException(msg, this.problem);
    }
}

