/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemTransform;

public class ItemTransformBase
implements ItemTransform {
    public static final boolean COPY_ALWAYS = true;
    public static final boolean COPY_ONLY_ON_CHANGE = false;
    private boolean alwaysCopy = false;

    public ItemTransformBase() {
        this(false);
    }

    public ItemTransformBase(boolean alwaysDuplicate) {
        this.alwaysCopy = alwaysDuplicate;
    }

    @Override
    public Item transform(Item item, ItemList itemList) {
        return this.xform(item, itemList);
    }

    @Override
    public Item transform(Item item, Node node) {
        return this.xform(item, node);
    }

    @Override
    public Item transform(Item item, String symbol) {
        return this.xform(item, symbol);
    }

    @Override
    public Item transformNil(Item item) {
        return this.xformNil(item);
    }

    private Item xform(Item item, ItemList itemList) {
        if (!this.alwaysCopy && item.getList() == itemList) {
            return item;
        }
        return Item.createList(itemList, item.getLine(), item.getColumn());
    }

    private Item xform(Item item, Node node) {
        if (!this.alwaysCopy && item.getNode().equals(node)) {
            return item;
        }
        return Item.createNode(node, item.getLine(), item.getColumn());
    }

    private Item xform(Item item, String symbol) {
        if (!this.alwaysCopy && item.getSymbol().equals(symbol)) {
            return item;
        }
        return Item.createSymbol(symbol, item.getLine(), item.getColumn());
    }

    private Item xformNil(Item item) {
        return item;
    }
}

