/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate.lib;

import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.lib.AccStatStdDevPopulation;
import org.apache.jena.sparql.expr.aggregate.lib.AccStatStdDevSample;
import org.apache.jena.sparql.expr.aggregate.lib.AccStatVarPopulation;
import org.apache.jena.sparql.expr.aggregate.lib.AccStatVarSample;
import org.apache.jena.sparql.expr.aggregate.lib.AggURI;

public class StandardAggregates {
    public static String BASE = "http://jena.apache.org/ARQ/function/aggregate#";
    public static String BASE2 = "http://jena.apache.org/ARQ/function#";

    public static void register() {
        AccumulatorFactory f_Stdev = (agg, distinct) -> new AccStatStdDevSample(agg.getExpr(), distinct);
        AccumulatorFactory f_StdevSamp = (agg, distinct) -> new AccStatStdDevSample(agg.getExpr(), distinct);
        AccumulatorFactory f_StdevPop = (agg, distinct) -> new AccStatStdDevPopulation(agg.getExpr(), distinct);
        AccumulatorFactory f_VarPop = (agg, distinct) -> new AccStatVarPopulation(agg.getExpr(), distinct);
        AccumulatorFactory f_VarSamp = (agg, distinct) -> new AccStatVarSample(agg.getExpr(), distinct);
        StandardAggregates.r(AggURI.stdev, f_Stdev);
        StandardAggregates.r(AggURI.stdev_samp, f_StdevSamp);
        StandardAggregates.r(AggURI.stdev_pop, f_StdevPop);
        StandardAggregates.r(AggURI.variance, f_VarSamp);
        StandardAggregates.r(AggURI.var_samp, f_VarSamp);
        StandardAggregates.r(AggURI.var_pop, f_VarPop);
    }

    private static void r(String uri, AccumulatorFactory f) {
        AggregateRegistry.register(uri, f, null);
        AggregateRegistry.register(uri.replace("/aggregate", ""), f, null);
    }
}

