/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.impl.NTripleWriter;
import org.apache.jena.rdfxml.xmloutput.impl.RDFXML_Abbrev;
import org.apache.jena.rdfxml.xmloutput.impl.RDFXML_Basic;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoWriterForLangException;

public class RDFWriterFImpl
implements RDFWriterF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Class<? extends RDFWriterI>> custom = new LinkedHashMap<String, Class<? extends RDFWriterI>>();
    private static RDFWriterF rewiredAlternative = null;

    public static void alternative(RDFWriterF other) {
        rewiredAlternative = other;
    }

    public static RDFWriterF getCurrentRDFWriterF(RDFWriterF other) {
        return rewiredAlternative;
    }

    @Override
    public RDFWriterI getWriter(String lang) {
        Class<? extends RDFWriterI> c;
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if (rewiredAlternative != null) {
            return rewiredAlternative.getWriter(lang);
        }
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if ((c = custom.get(lang)) == null) {
            throw new NoWriterForLangException("Writer not found: " + lang);
        }
        try {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    private static void reset() {
        Class<RDFXML_Basic> rdfxmlWriter = RDFXML_Basic.class;
        Class<RDFXML_Abbrev> rdfxmlAbbrevWriter = RDFXML_Abbrev.class;
        Class<NTripleWriter> ntWriter = NTripleWriter.class;
        custom.put(DEFAULTLANG, rdfxmlWriter);
        custom.put("RDF/XML-ABBREV", rdfxmlAbbrevWriter);
        custom.put("N-TRIPLE", ntWriter);
        custom.put("N-TRIPLES", ntWriter);
        custom.put("N-Triples", ntWriter);
    }

    private static String currentEntry(String lang) {
        Class<? extends RDFWriterI> oldClass = custom.get(lang);
        if (oldClass != null) {
            return oldClass.getName();
        }
        return null;
    }

    private static String remove(String lang) {
        if (rewiredAlternative != null) {
            Log.error(RDFWriterFImpl.class, "Rewired RDFWriterFImpl2 - configuration changes have no effect on writing");
        }
        String oldClassName = RDFWriterFImpl.currentEntry(lang);
        custom.remove(lang);
        return oldClassName;
    }

    static {
        RDFWriterFImpl.reset();
    }
}

