/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntFacetRestriction;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class OntDataRangeImpl
extends OntObjectImpl
implements OntDataRange {
    public OntDataRangeImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    private static Resource create(OntGraphModelImpl model) {
        Resource type = OntGraphModelImpl.configValue(model, OntModelControls.USE_OWL1_DATARANGE_DECLARATION_FEATURE) ? OWL2.DataRange : RDFS.Datatype;
        return model.createResource().addProperty(RDF.type, type);
    }

    public static OntDataRange.OneOf createOneOf(OntGraphModelImpl model, Stream<Literal> values) {
        OntJenaException.notNull(values, "Null values stream.");
        RDFList items = model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null literal.")).iterator());
        Resource res = OntDataRangeImpl.create(model).addProperty(OWL2.oneOf, items);
        return model.getNodeAs(res.asNode(), OntDataRange.OneOf.class);
    }

    public static OntDataRange.Restriction createRestriction(OntGraphModelImpl model, OntDataRange.Named dataType, Stream<OntFacetRestriction> values) {
        OntJenaException.notNull(dataType, "Null data-type.");
        OntJenaException.notNull(values, "Null values stream.");
        RDFList items = model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null faced restriction.")).iterator());
        Resource res = OntDataRangeImpl.create(model).addProperty(OWL2.onDatatype, dataType).addProperty(OWL2.withRestrictions, items);
        return model.getNodeAs(res.asNode(), OntDataRange.Restriction.class);
    }

    public static OntDataRange.ComplementOf createComplementOf(OntGraphModelImpl model, OntDataRange other) {
        OntJenaException.notNull(other, "Null data range.");
        Resource res = OntDataRangeImpl.create(model).addProperty(OWL2.datatypeComplementOf, other);
        return model.getNodeAs(res.asNode(), OntDataRange.ComplementOf.class);
    }

    public static OntDataRange.UnionOf createUnionOf(OntGraphModelImpl model, Stream<OntDataRange> values) {
        OntJenaException.notNull(values, "Null values stream.");
        RDFList items = model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null data range.")).iterator());
        Resource res = OntDataRangeImpl.create(model).addProperty(OWL2.unionOf, items);
        return model.getNodeAs(res.asNode(), OntDataRange.UnionOf.class);
    }

    public static OntDataRange.IntersectionOf createIntersectionOf(OntGraphModelImpl model, Stream<OntDataRange> values) {
        OntJenaException.notNull(values, "Null values stream.");
        RDFList items = model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null data range.")).iterator());
        Resource res = OntDataRangeImpl.create(model).addProperty(OWL2.intersectionOf, items);
        return model.getNodeAs(res.asNode(), OntDataRange.IntersectionOf.class);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        Resource type = OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL1_DATARANGE_DECLARATION_FEATURE) ? OWL2.DataRange : RDFS.Datatype;
        return OntDataRangeImpl.getRequiredRootStatement(this, type);
    }

    protected static abstract class CombinationImpl<N extends RDFNode>
    extends OntDataRangeImpl
    implements OntDataRange.Combination<N> {
        protected final Property predicate;
        protected final Class<N> type;

        protected CombinationImpl(Node n, EnhGraph m, Property predicate, Class<N> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(this.listDeclaration(), ((OntListImpl)this.getList()).listContent());
        }

        public ExtendedIterator<OntStatement> listDeclaration() {
            return super.listSpec();
        }

        @Override
        public OntListImpl<N> getList() {
            return this.getModel().asOntList(this.getRequiredObject(this.predicate, RDFList.class), this, this.predicate, true, null, this.type);
        }
    }

    public static class IntersectionOfImpl
    extends CombinationImpl<OntDataRange>
    implements OntDataRange.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.intersectionOf, OntDataRange.class);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDataRange.IntersectionOf.class;
        }
    }

    public static class UnionOfImpl
    extends CombinationImpl<OntDataRange>
    implements OntDataRange.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.unionOf, OntDataRange.class);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDataRange.UnionOf.class;
        }
    }

    public static class RestrictionImpl
    extends CombinationImpl<OntFacetRestriction>
    implements OntDataRange.Restriction {
        public RestrictionImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.withRestrictions, OntFacetRestriction.class);
        }

        public Class<OntDataRange.Restriction> objectType() {
            return OntDataRange.Restriction.class;
        }

        @Override
        public OntDataRange.Named getValue() {
            return this.getRequiredObject(OWL2.onDatatype, OntDataRange.Named.class);
        }

        @Override
        public RestrictionImpl setValue(OntDataRange.Named value) {
            Objects.requireNonNull(value);
            this.removeAll(OWL2.onDatatype).addProperty(OWL2.onDatatype, value);
            return this;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(this.listDeclaration(), this.listRequired(OWL2.onDatatype), this.withRestrictionsSpec());
        }

        public ExtendedIterator<OntStatement> withRestrictionsSpec() {
            return Iterators.flatMap(this.getList().listContent(), s -> {
                if (!s.getObject().canAs(OntFacetRestriction.class)) {
                    return Iterators.of(s);
                }
                return Iterators.of(new OntStatement[]{s, s.getObject().as(OntFacetRestriction.class).getMainStatement()});
            });
        }
    }

    public static class OneOfImpl
    extends CombinationImpl<Literal>
    implements OntDataRange.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.oneOf, Literal.class);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDataRange.OneOf.class;
        }
    }

    public static class ComplementOfImpl
    extends OntDataRangeImpl
    implements OntDataRange.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntDataRange getValue() {
            return this.getRequiredObject(OWL2.datatypeComplementOf, OntDataRange.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(OWL2.datatypeComplementOf));
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDataRange.ComplementOf.class;
        }

        @Override
        public OntDataRange.ComplementOf setValue(OntDataRange value) {
            Objects.requireNonNull(value);
            this.removeAll(OWL2.datatypeComplementOf).addProperty(OWL2.datatypeComplementOf, value);
            return this;
        }
    }
}

