/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.dictionary.model.element;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.emc.simulink.dictionary.model.SimulinkDictionaryModel;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.ISimulinkDictionaryModelElement;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SectionEnum;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SimulinkSection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkEntry
extends SimulinkModelElement
implements ISimulinkDictionaryModelElement {
    protected MatlabHandleElement entry;
    protected SimulinkSection section;
    protected String entryType;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public SimulinkEntry(SimulinkDictionaryModel model, MatlabEngine engine, SectionEnum sectionType) {
        super((IGenericSimulinkModel)model, engine);
        this.section = sectionType.getFromModel(model);
        this.entryType = sectionType.getEpsilonEntryName();
    }

    public SimulinkEntry(SimulinkDictionaryModel model, MatlabEngine engine, SimulinkSection section) {
        super((IGenericSimulinkModel)model, engine);
        this.section = section;
    }

    public SimulinkEntry(SimulinkDictionaryModel model, MatlabEngine engine, HandleObject entryHandle) {
        super((IGenericSimulinkModel)model, engine);
        this.entry = new MatlabHandleElement((IGenericSimulinkModel)model, engine, entryHandle);
    }

    public SimulinkSection getSection() {
        return this.section;
    }

    public String getEntryType() {
        if (this.entryType == null) {
            try {
                this.entryType = SectionEnum.fromMatlab((String)this.getSection().getProperty("Name")).getEpsilonEntryName();
            }
            catch (EolRuntimeException e) {
                return "";
            }
        }
        return this.entryType;
    }

    public Object getProperty(String property) throws EolRuntimeException {
        if (this.entry != null) {
            if ("Value".equals(property)) {
                try {
                    return this.engine.fevalWithResult("getValue", new Object[]{this.entry.getHandle()});
                }
                catch (MatlabException e) {
                    if (e.isUnsupportedTypeException().booleanValue()) {
                        return null;
                    }
                    throw new EolIllegalPropertyException((Object)this, property, null, null);
                }
            }
            return this.entry.getProperty(property);
        }
        if (this.properties.containsKey(property)) {
            return this.properties.get(property);
        }
        throw new EolIllegalPropertyException((Object)this, property, null, null);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        if (this.entry != null) {
            if (property.equals("Value")) {
                if (value instanceof HandleObject) {
                    value = ((HandleObject)value).getHandleObject();
                } else if (value instanceof ISimulinkModelElement && (value = ((ISimulinkModelElement)value).getHandle()) instanceof MatlabHandleElement) {
                    value = ((MatlabHandleElement)value).getHandle();
                }
                try {
                    this.engine.feval(0, "setValue", new Object[]{this.entry.getHandle(), value});
                }
                catch (MatlabException e) {
                    throw new EolIllegalPropertyException((Object)this, property, null, null);
                }
            } else {
                this.entry.setProperty(property, value);
            }
        } else {
            this.properties.put(property, value);
            if (this.properties.containsKey("Name") && this.properties.containsKey("Value")) {
                try {
                    HandleObject entryObject = (HandleObject)this.engine.fevalWithResult("addEntry", new Object[]{this.getSection().getHandle(), this.properties.get("Name"), this.properties.get("Value")});
                    this.entry = new MatlabHandleElement(this.model, this.engine, entryObject);
                    this.properties.remove("Name");
                    this.properties.remove("Value");
                    for (Map.Entry<String, Object> p : this.properties.entrySet()) {
                        this.setProperty(p.getKey(), p.getValue());
                    }
                    this.properties = null;
                }
                catch (MatlabException e) {
                    throw new EolIllegalPropertyException((Object)this, property, null, null);
                }
            }
        }
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        if (this.entry != null) {
            try {
                this.engine.fevalWithResult(0, "deleteEntry", new Object[]{this.entry.getHandle()});
            }
            catch (MatlabException e) {
                throw new EolRuntimeException(e.getMessage());
            }
        }
        return true;
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList("Entry", this.getEntryType());
    }

    public String getType() {
        return "Entry";
    }

    public Object getHandle() {
        return this.entry;
    }
}

