/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.service;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.GraphFeature;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IProperty;

@Singleton
public class LayoutConfigurationManager {
    @Inject(optional=true)
    private ILayoutConfigurationStore.Provider configProvider;
    @Inject
    private IGraphLayoutEngine graphLayoutEngine;

    public LayoutAlgorithmData getAlgorithm(ILayoutConfigurationStore config) {
        return LayoutMetaDataService.getInstance().getAlgorithmDataBySuffixOrDefault((String)this.getRawOptionValue(CoreOptions.ALGORITHM, config), this.graphLayoutEngine.getDefaultLayoutAlgorithmID());
    }

    public Set<LayoutOptionData> getSupportedOptions(ILayoutConfigurationStore config) {
        LayoutAlgorithmData algoData;
        ILayoutConfigurationStore parentConfig;
        LayoutAlgorithmData algoData2;
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        LinkedHashSet<LayoutOptionData> optionData = new LinkedHashSet<LayoutOptionData>();
        Set<LayoutOptionData.Target> optionTargets = config.getOptionTargets();
        if (optionTargets.contains(LayoutOptionData.Target.PARENTS) && (algoData2 = this.getAlgorithm(config)) != null) {
            optionData.addAll(layoutDataService.getOptionData(algoData2, LayoutOptionData.Target.PARENTS));
        }
        if ((parentConfig = config.getParent()) != null && (algoData = this.getAlgorithm(parentConfig)) != null) {
            for (LayoutOptionData.Target target : optionTargets) {
                if (target == LayoutOptionData.Target.PARENTS) continue;
                optionData.addAll(layoutDataService.getOptionData(algoData, target));
            }
        }
        return optionData;
    }

    public Object getOptionValue(LayoutOptionData optionData, ILayoutConfigurationStore config) {
        LayoutAlgorithmData algoData;
        ILayoutConfigurationStore parentConfig;
        LayoutAlgorithmData algoData2;
        Object result = this.getRawOptionValue((IProperty<?>)optionData, config);
        if (optionData.equals((Object)CoreOptions.ALGORITHM)) {
            algoData2 = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffixOrDefault((String)result, this.graphLayoutEngine.getDefaultLayoutAlgorithmID());
            if (algoData2 != null) {
                return algoData2.getId();
            }
        } else if (result != null) {
            return result;
        }
        if (optionData.getTargets().contains(LayoutOptionData.Target.PARENTS) ? (algoData2 = this.getAlgorithm(config)) != null && (result = algoData2.getDefaultValue(optionData)) != null : (parentConfig = config.getParent()) != null && (algoData = this.getAlgorithm(parentConfig)) != null && (result = algoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        result = optionData.getDefault();
        if (result != null) {
            return result;
        }
        return optionData.getDefaultDefault();
    }

    protected Object getRawOptionValue(IProperty<?> option, ILayoutConfigurationStore config) {
        Object result = config.getOptionValue(option.getId());
        if (result instanceof String && option instanceof LayoutOptionData) {
            return ((LayoutOptionData)option).parseValue((String)result);
        }
        return result;
    }

    protected ILayoutConfigurationStore getResponsibleParent(ILayoutConfigurationStore config) {
        ILayoutConfigurationStore result;
        ILayoutConfigurationStore current = result = config.getParent();
        while (current != null) {
            ILayoutConfigurationStore parent = current.getParent();
            if (parent != null && this.isFullHierarchyLayout(parent)) {
                result = parent;
            }
            current = parent;
        }
        return result;
    }

    protected boolean isFullHierarchyLayout(ILayoutConfigurationStore config) {
        boolean layoutHierarchy;
        Object layoutHierarchyVal = config.getOptionValue(CoreOptions.LAYOUT_HIERARCHY.getId());
        boolean bl = layoutHierarchy = layoutHierarchyVal instanceof Boolean ? (Boolean)layoutHierarchyVal : Boolean.parseBoolean((String)layoutHierarchyVal);
        if (layoutHierarchy) {
            LayoutAlgorithmData algoData = this.getAlgorithm(config);
            return algoData != null && (algoData.supportsFeature(GraphFeature.COMPOUND) || algoData.supportsFeature(GraphFeature.CLUSTERS));
        }
        return false;
    }

    protected ILayoutConfigurationStore getRoot(ILayoutConfigurationStore config) {
        ILayoutConfigurationStore parent;
        ILayoutConfigurationStore current = config;
        do {
            if ((parent = current.getParent()) != null) continue;
            return current;
        } while ((current = parent) != null);
        return null;
    }

    public void clearOptionValues(ILayoutConfigurationStore config) {
        for (String optionId : config.getAffectedOptions()) {
            config.setOptionValue(optionId, null);
        }
    }

    public <T> LayoutConfigurator createConfigurator(LayoutMapping layoutMapping) {
        LayoutConfigurator result = new LayoutConfigurator();
        if (this.configProvider != null) {
            this.configureElement((ElkGraphElement)layoutMapping.getLayoutGraph(), layoutMapping, result);
            UnmodifiableIterator allElements = Iterators.filter((Iterator)layoutMapping.getLayoutGraph().eAllContents(), ElkGraphElement.class);
            while (allElements.hasNext()) {
                ElkGraphElement element = (ElkGraphElement)allElements.next();
                this.configureElement(element, layoutMapping, result);
            }
        }
        return result;
    }

    protected void configureElement(ElkGraphElement element, LayoutMapping layoutMapping, LayoutConfigurator configurator) {
        Object diagramPart = layoutMapping.getGraphMap().get((Object)element);
        ILayoutConfigurationStore configurationStore = this.configProvider.get(layoutMapping.getWorkbenchPart(), diagramPart);
        if (configurationStore != null) {
            this.configureElement(element, configurationStore, configurator, false);
        }
    }

    protected void configureElement(ElkGraphElement element, ILayoutConfigurationStore configStore, LayoutConfigurator configurator, boolean recursiveOnly) {
        ILayoutConfigurationStore parentStore = configStore.getParent();
        if (parentStore != null) {
            this.configureElement(element, parentStore, configurator, true);
        }
        if (!recursiveOnly) {
            LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
            for (String optionId : configStore.getAffectedOptions()) {
                Object value = configStore.getOptionValue(optionId);
                LayoutOptionData optionData = layoutDataService.getOptionData(optionId);
                if (optionData == null || value == null) continue;
                if (value instanceof String) {
                    value = optionData.parseValue((String)value);
                }
                configurator.configure(element).setProperty((IProperty)optionData, value);
            }
        }
    }
}

