/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;

public class GroupModelOrderCalculator {
    private int firstSeparateNodes = 0;
    private int lastSeparateNodes = 0;

    public int computeConstraintModelOrder(LNode node, int offset) {
        int modelOrder = 0;
        switch ((LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT))) {
            case FIRST_SEPARATE: {
                modelOrder = 2 * -offset + this.firstSeparateNodes;
                ++this.firstSeparateNodes;
                break;
            }
            case FIRST: {
                modelOrder = -offset;
                break;
            }
            case LAST: {
                modelOrder = offset;
                break;
            }
            case LAST_SEPARATE: {
                modelOrder = 2 * offset + this.lastSeparateNodes;
                ++this.lastSeparateNodes;
                break;
            }
        }
        if (node.hasProperty(InternalProperties.MODEL_ORDER)) {
            modelOrder += ((Integer)node.getProperty(InternalProperties.MODEL_ORDER)).intValue();
        }
        return modelOrder;
    }

    public int computeConstraintGroupModelOrder(LNode node, int offset, int smallOffset) {
        int modelOrder = 0;
        switch ((LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT))) {
            case FIRST_SEPARATE: {
                modelOrder = 2 * -offset + this.firstSeparateNodes;
                ++this.firstSeparateNodes;
                break;
            }
            case FIRST: {
                modelOrder = -offset;
                break;
            }
            case LAST: {
                modelOrder = offset;
                break;
            }
            case LAST_SEPARATE: {
                modelOrder = 2 * offset + this.lastSeparateNodes;
                ++this.lastSeparateNodes;
                break;
            }
        }
        if (node.hasProperty(InternalProperties.MODEL_ORDER)) {
            modelOrder += (Integer)node.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CYCLE_BREAKING_ID) * smallOffset + (Integer)node.getProperty(InternalProperties.MODEL_ORDER);
        }
        return modelOrder;
    }

    public void resetInternalCounters() {
        this.firstSeparateNodes = 0;
        this.lastSeparateNodes = 0;
    }
}

