/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cfg;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;

public class ServerFiles {
    private final Path installRoot;
    private final Path instanceRoot;

    public ServerFiles(Path installRoot, Path instanceRoot) {
        this.installRoot = installRoot;
        this.instanceRoot = instanceRoot;
    }

    public Path getInstallRoot() {
        return this.installRoot;
    }

    public Path getInstanceRoot() {
        return this.instanceRoot;
    }

    public File getFileUnderInstallRoot(Path relativePath) {
        return this.installRoot.resolve(relativePath).toFile();
    }

    public File getFileUnderInstanceRoot(Path relativePath) {
        return this.instanceRoot.resolve(relativePath).toFile();
    }

    public File getOsgiHome(String envKey, String sysPropsKey, Path defaultSubdir) {
        String envProperty = System.getenv(envKey);
        if (envProperty != null) {
            return ServerFiles.toExistingFile(envProperty);
        }
        String sysProperty = System.getProperty(sysPropsKey);
        if (sysProperty != null) {
            return ServerFiles.toExistingFile(sysProperty);
        }
        return this.getFileUnderInstallRoot(defaultSubdir);
    }

    private static File toExistingFile(String path) throws IllegalArgumentException {
        File file = new File(path);
        try {
            File existingFile = file.getCanonicalFile();
            if (existingFile.isDirectory() && existingFile.canRead()) {
                return existingFile;
            }
            throw new IllegalArgumentException("Invalid path: " + path + " - must be an existing and readable directory.");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid path: " + path, e);
        }
    }

    public static File detectInstallRoot() {
        File bootstrapFile = ServerFiles.findBootstrapFile();
        File parent = bootstrapFile.getParentFile();
        for (int i = 0; i < 2; ++i) {
            if (parent == null) {
                return null;
            }
            parent = parent.getParentFile();
        }
        return parent;
    }

    private static File findBootstrapFile() {
        URL jarUrl = ServerFiles.class.getProtectionDomain().getCodeSource().getLocation();
        return new File(URI.create(jarUrl.toExternalForm().replaceFirst("jar:", "file:")));
    }
}

