/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.FaceletFullStateManagementStrategy;
import com.sun.faces.application.view.FaceletPartialStateManagementStrategy;
import com.sun.faces.application.view.FormOmittedChecker;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.ViewMetadataImpl;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.StateContext;
import com.sun.faces.facelets.compiler.FaceletDoctype;
import com.sun.faces.facelets.el.ContextualCompositeMethodExpression;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import com.sun.faces.facelets.impl.XMLFrontMatterSaver;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.DoctypeRenderer;
import com.sun.faces.util.Cache;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.Doctype;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.html.HtmlDoctype;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.MethodExpressionActionListener;
import jakarta.faces.event.MethodExpressionValueChangeListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.render.RenderKit;
import jakarta.faces.validator.MethodExpressionValidator;
import jakarta.faces.view.ActionSource2AttachedObjectHandler;
import jakarta.faces.view.ActionSource2AttachedObjectTarget;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.BehaviorHolderAttachedObjectHandler;
import jakarta.faces.view.BehaviorHolderAttachedObjectTarget;
import jakarta.faces.view.EditableValueHolderAttachedObjectHandler;
import jakarta.faces.view.EditableValueHolderAttachedObjectTarget;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ValueHolderAttachedObjectHandler;
import jakarta.faces.view.ValueHolderAttachedObjectTarget;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.ViewMetadata;
import jakarta.faces.view.facelets.Facelet;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.servlet.http.HttpSession;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class FaceletViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ViewDeclarationLanguageFactory vdlFactory;
    private DefaultFaceletFactory faceletFactory;
    private String[] extensionsArray;
    private String[] prefixesArray;
    public static final String IS_BUILDING_METADATA = FaceletViewHandlingStrategy.class.getName() + ".IS_BUILDING_METADATA";
    public static final String RESOURCE_LIBRARY_CONTRACT_DATA_STRUCTURE_KEY = FaceletViewHandlingStrategy.class.getName() + ".RESOURCE_LIBRARY_CONTRACT_DATA_STRUCTURE";
    private MethodRetargetHandlerManager retargetHandlerManager = new MethodRetargetHandlerManager();
    private int responseBufferSize;
    private Cache<Resource, BeanInfo> metadataCache;
    private Map<String, List<String>> contractMappings;

    public FaceletViewHandlingStrategy() {
        this.initialize();
    }

    public static boolean isBuildingMetadata(FacesContext context) {
        return context.getAttributes().containsKey(IS_BUILDING_METADATA);
    }

    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (UIDebug.debugRequest(context)) {
            context.getApplication().createComponent("jakarta.faces.ViewRoot");
        }
        if (this.isStateless(context, viewId)) {
            try {
                context.setProcessingEvents(true);
                ViewDeclarationLanguage vdl = this.vdlFactory.getViewDeclarationLanguage(viewId);
                UIViewRoot viewRoot = vdl.createView(context, viewId);
                context.setViewRoot(viewRoot);
                vdl.buildView(context, viewRoot);
                if (!viewRoot.isTransient()) {
                    throw new FacesException("Unable to restore view " + viewId);
                }
                return viewRoot;
            }
            catch (IOException ioe) {
                throw new FacesException(ioe);
            }
        }
        if (StateContext.getStateContext(context).isPartialStateSaving(context, viewId)) {
            try {
                String clientId;
                Object stateObj;
                Map state;
                context.setProcessingEvents(false);
                ViewDeclarationLanguage vdl = this.vdlFactory.getViewDeclarationLanguage(viewId);
                UIViewRoot viewRoot = vdl.getViewMetadata(context, viewId).createMetadataView(context);
                context.setViewRoot(viewRoot);
                Object[] rawState = (Object[])RenderKitUtils.getResponseStateManager(context, context.getApplication().getViewHandler().calculateRenderKitId(context)).getState(context, viewId);
                if (rawState != null && (state = (Map)rawState[1]) != null && (stateObj = state.get(clientId = viewRoot.getClientId(context))) != null) {
                    context.getAttributes().put("com.sun.faces.application.view.restoreViewScopeOnly", true);
                    viewRoot.restoreState(context, stateObj);
                    context.getAttributes().remove("com.sun.faces.application.view.restoreViewScopeOnly");
                }
                context.setProcessingEvents(true);
                vdl.buildView(context, viewRoot);
            }
            catch (IOException ioe) {
                throw new FacesException(ioe);
            }
        }
        UIViewRoot root = super.restoreView(context, viewId);
        this.setResourceLibraryContracts(context, viewId);
        this.startTrackViewModifications(context, root);
        return root;
    }

    @Override
    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        return new ViewMetadataImpl(viewId);
    }

    @Override
    public UIViewRoot createView(FacesContext ctx, String viewId) {
        Util.notNull("context", ctx);
        Util.notNull("viewId", viewId);
        if (UIDebug.debugRequest(ctx)) {
            UIViewRoot root = (UIViewRoot)ctx.getApplication().createComponent("jakarta.faces.ViewRoot");
            root.setViewId(viewId);
            return root;
        }
        UIViewRoot result = super.createView(ctx, viewId);
        this.setResourceLibraryContracts(ctx, viewId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildView(FacesContext ctx, UIViewRoot view) throws IOException {
        StateContext stateCtx = StateContext.getStateContext(ctx);
        if (Util.isViewPopulated(ctx, view)) {
            Facelet facelet = this.faceletFactory.getFacelet(ctx, view.getViewId());
            try {
                stateCtx.setTrackViewModifications(false);
                facelet.apply(ctx, view);
                this.reapplyDynamicActions(ctx);
                if (stateCtx.isPartialStateSaving(ctx, view.getViewId())) {
                    this.markInitialStateIfNotMarked(view);
                }
            }
            finally {
                stateCtx.setTrackViewModifications(true);
            }
            return;
        }
        view.setViewId(view.getViewId());
        LOGGER.log(Level.FINE, () -> "Building View: " + view.getViewId());
        if (this.faceletFactory == null) {
            this.faceletFactory = ApplicationAssociate.getInstance(ctx.getExternalContext()).getFaceletFactory();
        }
        RequestStateManager.set(ctx, "com.sun.faces.FACELET_FACTORY", this.faceletFactory);
        Facelet facelet = this.faceletFactory.getFacelet(ctx, view.getViewId());
        try {
            FaceletDoctype doctype;
            ctx.getAttributes().put("jakarta.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
            stateCtx.setTrackViewModifications(false);
            facelet.apply(ctx, view);
            if (facelet instanceof XMLFrontMatterSaver) {
                String XMLDECL;
                XMLFrontMatterSaver frontMatterSaver = (XMLFrontMatterSaver)((Object)facelet);
                Doctype doctype2 = frontMatterSaver.getSavedDoctype();
                if (doctype2 != null) {
                    Util.saveDOCTYPEToFacesContextAttributes(doctype2);
                }
                if ((XMLDECL = frontMatterSaver.getSavedXMLDecl()) != null) {
                    Util.saveXMLDECLToFacesContextAttributes(XMLDECL);
                }
            }
            if ((doctype = (FaceletDoctype)Util.getDOCTYPEFromFacesContextAttributes(ctx)) != null) {
                HtmlDoctype htmlDoctype = new HtmlDoctype();
                htmlDoctype.setRootElement(doctype.getRootElement());
                htmlDoctype.setPublic(doctype.getPublic());
                htmlDoctype.setSystem(doctype.getSystem());
                view.setDoctype(htmlDoctype);
            }
            if (!stateCtx.isPartialStateSaving(ctx, view.getViewId())) {
                this.reapplyDynamicActions(ctx);
            }
            this.startTrackViewModifications(ctx, view);
        }
        finally {
            ctx.getAttributes().remove("jakarta.faces.IS_BUILDING_INITIAL_STATE");
        }
        ctx.getApplication().publishEvent(ctx, PostAddToViewEvent.class, UIViewRoot.class, view);
        this.markInitialState(ctx, view);
        Util.setViewPopulated(ctx, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderView(FacesContext ctx, UIViewRoot viewToRender) throws IOException {
        if (!viewToRender.isRendered()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering View: " + viewToRender.getViewId());
        }
        WriteBehindStateWriter stateWriter = null;
        try {
            ResponseWriter origWriter;
            if (!Util.isViewPopulated(ctx, viewToRender)) {
                this.vdlFactory.getViewDeclarationLanguage(viewToRender.getViewId()).buildView(ctx, viewToRender);
            }
            if ((origWriter = ctx.getResponseWriter()) == null) {
                origWriter = this.createResponseWriter(ctx);
            }
            ExternalContext extContext = ctx.getExternalContext();
            if (this.isServerStateSaving() && !viewToRender.isTransient()) {
                this.getSession(ctx);
            }
            int bufferSize = this.responseBufferSize != -1 ? this.responseBufferSize : Integer.parseInt(WebConfiguration.WebContextInitParameter.FaceletsBufferSize.getDefaultValue());
            stateWriter = new WriteBehindStateWriter(extContext.getResponseOutputWriter(), ctx, bufferSize);
            ResponseWriter writer = origWriter.cloneWithWriter(stateWriter);
            ctx.setResponseWriter(writer);
            if (ctx.getPartialViewContext().isPartialRequest()) {
                viewToRender.encodeAll(ctx);
            } else {
                Doctype doctype;
                String xmlDecl;
                if (ctx.isProjectStage(ProjectStage.Development)) {
                    FormOmittedChecker.check(ctx);
                }
                if ((xmlDecl = Util.getXMLDECLFromFacesContextAttributes(ctx)) != null) {
                    writer.writePreamble(xmlDecl);
                }
                if ((doctype = viewToRender.getDoctype()) != null) {
                    if (doctype instanceof UIComponent) {
                        ((UIComponent)((Object)doctype)).encodeAll(ctx);
                    } else {
                        writer.writeDoctype(DoctypeRenderer.toString(doctype));
                    }
                    writer.append('\n');
                }
                writer.startDocument();
                viewToRender.encodeAll(ctx);
                try {
                    ctx.getExternalContext().getFlash().doPostPhaseActions(ctx);
                }
                catch (UnsupportedOperationException uoe) {
                    LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
                }
                writer.endDocument();
            }
            if (ctx.getExternalContext().getSession(false) != null) {
                ctx.getExternalContext().getSessionMap().put("jakarta.faces.request.charset", writer.getCharacterEncoding());
            }
            writer.close();
            if (stateWriter.stateWritten()) {
                stateWriter.flushToWriter();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleFaceletNotFound(ctx, viewToRender.getViewId(), fnfe.getMessage());
        }
        catch (Exception e) {
            this.handleRenderException(ctx, e);
        }
        finally {
            if (stateWriter != null) {
                stateWriter.release();
            }
        }
    }

    @Override
    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        if (StateContext.getStateContext(context).isPartialStateSaving(context, viewId)) {
            return new FaceletPartialStateManagementStrategy(context);
        }
        return new FaceletFullStateManagementStrategy(context);
    }

    @Override
    public BeanInfo getComponentMetadata(FacesContext context, Resource ccResource) {
        DefaultFaceletFactory factory = (DefaultFaceletFactory)RequestStateManager.get(context, "com.sun.faces.FACELET_FACTORY");
        if (factory.needsToBeRefreshed(ccResource.getURL())) {
            this.metadataCache.remove(ccResource);
        }
        return this.metadataCache.get(ccResource);
    }

    @Override
    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        Util.notNull("context", context);
        Util.notNull("componentResource", componentResource);
        return null;
    }

    @Override
    public void retargetAttachedObjects(FacesContext context, UIComponent topLevelComponent, List<AttachedObjectHandler> handlers) {
        Util.notNull("context", context);
        Util.notNull("topLevelComponent", topLevelComponent);
        Util.notNull("handlers", handlers);
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        if (componentBeanInfo == null) {
            return;
        }
        BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
        List targetList = (List)componentDescriptor.getValue("jakarta.faces.view.AttachedObjectTargets");
        block0: for (AttachedObjectHandler curHandler : handlers) {
            String forAttributeValue = curHandler.getFor();
            for (AttachedObjectTarget curTarget : targetList) {
                String curTargetName = curTarget.getName();
                List<UIComponent> targetComponents = curTarget.getTargets(topLevelComponent);
                if (curHandler instanceof ActionSource2AttachedObjectHandler && curTarget instanceof ActionSource2AttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (curHandler instanceof EditableValueHolderAttachedObjectHandler && curTarget instanceof EditableValueHolderAttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (curHandler instanceof ValueHolderAttachedObjectHandler && curTarget instanceof ValueHolderAttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (!(curHandler instanceof BehaviorHolderAttachedObjectHandler) || !(curTarget instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectHandler behaviorHandler = (BehaviorHolderAttachedObjectHandler)curHandler;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)curTarget;
                String eventName = behaviorHandler.getEventName();
                if ((null == eventName || !eventName.equals(curTargetName)) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                for (UIComponent curTargetComponent : targetComponents) {
                    this.retargetHandler(context, curHandler, curTargetComponent);
                }
            }
        }
    }

    @Override
    public void retargetMethodExpressions(FacesContext context, UIComponent topLevelComponent) {
        Util.notNull("context", context);
        Util.notNull("topLevelComponent", topLevelComponent);
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        if (componentBeanInfo == null) {
            return;
        }
        PropertyDescriptor[] attributes = componentBeanInfo.getPropertyDescriptors();
        MethodMetadataIterator allMetadata = new MethodMetadataIterator(context, attributes);
        for (CompCompInterfaceMethodMetadata metadata : allMetadata) {
            MethodRetargetHandler handler;
            String attrName = metadata.getName();
            String[] targets = metadata.getTargets(context);
            Object attrValue = topLevelComponent.getValueExpression(attrName);
            if (attrValue == null) {
                Map<String, Object> attrs = topLevelComponent.getAttributes();
                Object object = attrValue = attrs.containsKey(attrName) ? attrs.get(attrName) : metadata.getDefault();
                if (attrValue == null) {
                    if (!metadata.isRequired(context)) continue;
                    Object location = attrs.get("jakarta.faces.component.VIEW_LOCATION_KEY");
                    if (location == null) {
                        location = "";
                    }
                    throw new FacesException(location.toString() + ": Unable to find attribute with name \"" + attrName + "\" in top level component in consuming page,  or with default value in composite component.  Page author or composite component author error.");
                }
            }
            String targetAttributeName = metadata.getTargetAttributeName(context);
            UIComponent targetComp = null;
            if (targetAttributeName != null) {
                attrName = targetAttributeName;
            }
            if (targets != null) {
                handler = this.retargetHandlerManager.getRetargetHandler(attrName);
                if (handler != null) {
                    for (String curTarget : targets) {
                        targetComp = topLevelComponent.findComponent(curTarget);
                        if (targetComp == null) {
                            throw new FacesException(attrValue.toString() + " : Unable to re-target MethodExpression as inner component referenced by target id '" + curTarget + "' cannot be found.");
                        }
                        handler.retarget(context, metadata, attrValue, targetComp);
                    }
                } else {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "faces.compcomp.unecessary.targets.attribute", new Object[]{this.getCompositeComponentName(topLevelComponent), attrName});
                    }
                    handler = this.retargetHandlerManager.getDefaultHandler();
                    handler.retarget(context, metadata, attrValue, topLevelComponent);
                }
            } else {
                handler = null;
                if (targetAttributeName != null) {
                    targetComp = topLevelComponent.findComponent(metadata.getName());
                    handler = this.retargetHandlerManager.getRetargetHandler(attrName);
                }
                if (handler == null) {
                    targetComp = topLevelComponent;
                    handler = this.retargetHandlerManager.getDefaultHandler();
                }
                handler.retarget(context, metadata, attrValue, targetComp);
            }
            topLevelComponent.setValueExpression(attrName, null);
        }
    }

    @Override
    public UIComponent createComponent(FacesContext context, String taglibURI, String tagName, Map<String, Object> attributes) {
        Util.notNull("context", context);
        Util.notNull("taglibURI", taglibURI);
        Util.notNull("tagName", tagName);
        return this.associate.getFaceletFactory()._createComponent(context, taglibURI, tagName, attributes);
    }

    @Override
    public List<String> calculateResourceLibraryContracts(FacesContext context, String viewId) {
        List<String> result = null;
        String longestPattern = null;
        if (this.contractMappings == null) {
            return Collections.emptyList();
        }
        String longestMatch = null;
        for (Map.Entry<String, List<String>> mappings : this.contractMappings.entrySet()) {
            String urlPattern = mappings.getKey();
            if (urlPattern.endsWith("*")) {
                String prefix = urlPattern.substring(0, urlPattern.length() - 1);
                if (!viewId.startsWith(prefix)) continue;
                if (longestPattern == null) {
                    longestPattern = urlPattern;
                    longestMatch = prefix;
                    continue;
                }
                if (longestMatch.length() >= prefix.length()) continue;
                longestPattern = urlPattern;
                longestMatch = prefix;
                continue;
            }
            if (!viewId.equals(urlPattern)) continue;
            longestPattern = urlPattern;
            break;
        }
        if (longestPattern != null) {
            result = this.contractMappings.get(longestPattern);
        }
        if (result == null) {
            result = this.contractMappings.get("*");
        }
        return result;
    }

    @Override
    public boolean viewExists(FacesContext context, String viewId) {
        if (this.handlesViewId(viewId)) {
            return this.getFaceletFactory().getResourceResolver().resolveUrl(viewId) != null;
        }
        return false;
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, ViewVisitOption ... options) {
        return this.mapIfNeeded(super.getViews(context, path, new ViewVisitOption[0]).filter(viewId -> this.handlesViewId((String)viewId)), options);
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, int maxDepth, ViewVisitOption ... options) {
        return this.mapIfNeeded(super.getViews(context, path, maxDepth, new ViewVisitOption[0]).filter(viewId -> this.handlesViewId((String)viewId)), options);
    }

    @Override
    public boolean handlesViewId(String viewId) {
        if (viewId != null) {
            if (this.handlesByPrefixOrSuffix(viewId)) {
                return true;
            }
            if (Util.isViewIdExactMappedToFacesServlet(viewId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getId() {
        return "java.faces.Facelets";
    }

    protected void initialize() {
        LOGGER.fine("Initializing FaceletViewHandlingStrategy");
        this.initializeMappings();
        this.metadataCache = new Cache<Resource, BeanInfo>(ccResource -> {
            FacesContext context = FacesContext.getCurrentInstance();
            return this.createComponentMetadata(context, (Resource)ccResource);
        });
        try {
            this.responseBufferSize = Integer.parseInt(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsBufferSize));
        }
        catch (NumberFormatException nfe) {
            this.responseBufferSize = Integer.parseInt(WebConfiguration.WebContextInitParameter.FaceletsBufferSize.getDefaultValue());
        }
        LOGGER.fine("Initialization Successful");
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("jakarta.faces.view.ViewDeclarationLanguageFactory");
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> appMap = extContext.getApplicationMap();
        Map contractDataStructure = (Map)appMap.remove(RESOURCE_LIBRARY_CONTRACT_DATA_STRUCTURE_KEY);
        if (!Util.isEmpty(contractDataStructure)) {
            this.contractMappings = new ConcurrentHashMap<String, List<String>>();
            for (Map.Entry cur : contractDataStructure.entrySet()) {
                this.contractMappings.put((String)cur.getKey(), new CopyOnWriteArrayList((Collection)cur.getValue()));
                ((List)cur.getValue()).clear();
            }
            contractDataStructure.clear();
        }
    }

    protected void initializeMappings() {
        String viewMappings = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsViewMappings);
        if (viewMappings != null && viewMappings.length() > 0) {
            Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
            String[] mappingsArray = Util.split(appMap, viewMappings, ";");
            ArrayList<String> extensionsList = new ArrayList<String>(mappingsArray.length);
            ArrayList<String> prefixesList = new ArrayList<String>(mappingsArray.length);
            for (String aMappingsArray : mappingsArray) {
                String mapping = aMappingsArray.trim();
                int mappingLength = mapping.length();
                if (mappingLength <= 1) continue;
                if (mapping.charAt(0) == '*') {
                    extensionsList.add(mapping.substring(1));
                    continue;
                }
                if (mapping.charAt(mappingLength - 1) != '*') continue;
                prefixesList.add(mapping.substring(0, mappingLength - 1));
            }
            this.extensionsArray = new String[extensionsList.size()];
            extensionsList.toArray(this.extensionsArray);
            this.prefixesArray = new String[prefixesList.size()];
            prefixesList.toArray(this.prefixesArray);
        }
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            String id = context.getViewRoot().getRenderKitId();
            throw new IllegalStateException("No render kit was available for id \"" + id + "\"");
        }
        if (this.responseBufferSize != -1) {
            if (!extContext.isResponseCommitted()) {
                extContext.setResponseBufferSize(this.responseBufferSize);
            } else {
                LOGGER.warning("Skipping attempt to set buffer size on a committed response");
            }
        }
        String defaultContentType = (String)context.getAttributes().get("facelets.ContentType");
        String defaultEncoding = (String)context.getAttributes().get("facelets.Encoding");
        ResponseWriter initWriter = renderKit.createResponseWriter(NullWriter.INSTANCE, defaultContentType, defaultEncoding);
        String contentType = this.getResponseContentType(context, initWriter.getContentType());
        String encoding = Util.getResponseEncoding(context, initWriter.getCharacterEncoding());
        char[] buffer = new char[1028];
        HtmlUtils.writeTextForXML(initWriter, contentType, buffer);
        String str = String.valueOf(buffer).trim();
        extContext.setResponseContentType(str);
        extContext.setResponseCharacterEncoding(encoding);
        context.getViewRoot().getAttributes().put("facelets.Encoding", encoding);
        ResponseWriter writer = initWriter.cloneWithWriter(extContext.getResponseOutputWriter());
        return writer;
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            UIViewRoot root = context.getViewRoot();
            StringBuffer sb = new StringBuffer(64);
            sb.append("Error Rendering View");
            if (root != null) {
                sb.append('[');
                sb.append(root.getViewId());
                sb.append(']');
            }
            LOGGER.log(Level.FINE, sb.toString(), e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new FacesException(e.getMessage(), e);
    }

    protected void handleFaceletNotFound(FacesContext context, String viewId, String message) throws IOException {
        context.getExternalContext().responseSendError(404, (String)(message != null ? viewId + ": " + message : viewId));
        context.responseComplete();
    }

    protected String getResponseContentType(FacesContext context, String orig) {
        String contentType = orig;
        Map<Object, Object> contextAttributes = context.getAttributes();
        if (contextAttributes.containsKey("facelets.ContentType")) {
            contentType = (String)contextAttributes.get("facelets.ContentType");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Facelet specified alternate contentType '" + contentType + "'");
            }
        }
        if (contentType == null) {
            contentType = "text/html";
            LOGGER.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
        }
        return contentType;
    }

    private boolean isStateless(FacesContext context, String viewId) {
        return RenderKitUtils.getResponseStateManager(context, context.getApplication().getViewHandler().calculateRenderKitId(context)).isStateless(context, viewId);
    }

    private void setResourceLibraryContracts(FacesContext ctx, String viewId) {
        ViewDeclarationLanguage vdl = ctx.getApplication().getViewHandler().getViewDeclarationLanguage(ctx, viewId);
        if (vdl != null) {
            ctx.setResourceLibraryContracts(vdl.calculateResourceLibraryContracts(ctx, viewId));
        }
    }

    private BeanInfo createComponentMetadata(FacesContext context, Resource ccResource) {
        FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        DefaultFaceletFactory factory = (DefaultFaceletFactory)RequestStateManager.get(context, "com.sun.faces.FACELET_FACTORY");
        VariableMapper orig = faceletContext.getVariableMapper();
        UIComponent tmp = context.getApplication().createComponent("jakarta.faces.NamingContainer");
        UIPanel facetComponent = (UIPanel)context.getApplication().createComponent("jakarta.faces.Panel");
        facetComponent.setRendererType("jakarta.faces.Group");
        tmp.getFacets().put("jakarta.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        tmp.getAttributes().put("jakarta.faces.application.Resource.ComponentResource", ccResource);
        try {
            Facelet facelet = factory.getFacelet(context, ccResource.getURL());
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                @Override
                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            faceletContext.setVariableMapper(wrapper);
            context.getAttributes().put(IS_BUILDING_METADATA, Boolean.TRUE);
            facelet.apply(context, facetComponent);
        }
        catch (Exception e) {
            if (e instanceof FacesException) {
                throw (FacesException)e;
            }
            throw new FacesException(e);
        }
        finally {
            context.getAttributes().remove(IS_BUILDING_METADATA);
            faceletContext.setVariableMapper(orig);
        }
        return (CompositeComponentBeanInfo)tmp.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
    }

    private boolean handlesByPrefixOrSuffix(String viewId) {
        if (viewId.endsWith("-flow.xml")) {
            return true;
        }
        if (this.extensionsArray == null && this.prefixesArray == null) {
            return this.isMatchedWithFaceletsSuffix(viewId) ? true : viewId.endsWith(".xhtml");
        }
        if (this.extensionsArray != null) {
            for (String extension : this.extensionsArray) {
                if (!viewId.endsWith(extension)) continue;
                return true;
            }
        }
        if (this.prefixesArray != null) {
            for (String prefix : this.prefixesArray) {
                if (!viewId.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private String getCompositeComponentName(UIComponent compositeComponent) {
        Resource resource = (Resource)compositeComponent.getAttributes().get("jakarta.faces.application.Resource.ComponentResource");
        String name = resource.getResourceName();
        String library = resource.getLibraryName();
        if (library != null) {
            return "Composite Component: " + name + ", library: " + library;
        }
        return "Composite Component: " + name;
    }

    private void startTrackViewModifications(FacesContext ctx, UIViewRoot root) {
        StateContext.getStateContext(ctx).startTrackViewModifications(ctx, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markInitialState(FacesContext ctx, UIViewRoot root) {
        StateContext stateCtx = StateContext.getStateContext(ctx);
        if (stateCtx.isPartialStateSaving(ctx, root.getViewId())) {
            try {
                ctx.getAttributes().put("jakarta.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
                if (!root.isTransient()) {
                    this.markInitialState(root);
                }
            }
            finally {
                ctx.getAttributes().remove("jakarta.faces.IS_BUILDING_INITIAL_STATE");
            }
        }
    }

    private void markInitialState(UIComponent component) {
        component.markInitialState();
        Iterator<UIComponent> it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = it.next();
            if (child.isTransient()) continue;
            this.markInitialState(child);
        }
    }

    private void retargetHandler(FacesContext context, AttachedObjectHandler handler, UIComponent targetComponent) {
        if (UIComponent.isCompositeComponent(targetComponent)) {
            List<AttachedObjectHandler> nHandlers = CompositeComponentTagHandler.getAttachedObjectHandlers(targetComponent);
            nHandlers.add(handler);
            this.retargetAttachedObjects(context, targetComponent, nHandlers);
        } else {
            handler.applyAttachedObject(context, targetComponent);
        }
    }

    private UIComponent locateComponentByClientId(FacesContext context, UIComponent parent, String clientId, boolean dynamic) {
        ArrayList found = new ArrayList(1);
        UIComponent result = null;
        try {
            parent.invokeOnComponent(context, clientId, (context1, target) -> found.add(target));
        }
        catch (FacesException e) {
            if (dynamic) {
                LOGGER.log(Level.FINE, e, () -> "Cannot find dynamic component " + clientId + " in " + parent.getClientId(context) + "; assuming it just doesn't exist anymore; it will most likely emit a 'WARNING: Unable to save dynamic action' log later on anyway");
            }
            throw e;
        }
        if (found.isEmpty()) {
            VisitContext visitContext = VisitContext.createVisitContext(context);
            parent.visitTree(visitContext, (visitContext1, component) -> {
                VisitResult result1 = VisitResult.ACCEPT;
                if (component.getClientId(visitContext1.getFacesContext()).equals(clientId)) {
                    found.add(component);
                    result1 = VisitResult.COMPLETE;
                }
                return result1;
            });
        }
        if (!found.isEmpty()) {
            result = (UIComponent)found.get(0);
        }
        return result;
    }

    private void reapplyDynamicActions(FacesContext context) {
        StateContext stateContext = StateContext.getStateContext(context);
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        if (actions != null) {
            for (ComponentStruct action : actions) {
                if ("REMOVE".equals(action.getAction())) {
                    this.reapplyDynamicRemove(context, action);
                }
                if (!"ADD".equals(action.getAction())) continue;
                this.reapplyDynamicAdd(context, action);
            }
        }
    }

    private void reapplyDynamicAdd(FacesContext context, ComponentStruct struct) {
        UIComponent parent = this.locateComponentByClientId(context, context.getViewRoot(), struct.getParentClientId(), false);
        if (parent != null) {
            UIComponent child = this.locateComponentByClientId(context, parent, struct.getClientId(), true);
            StateContext stateContext = StateContext.getStateContext(context);
            if (child == null) {
                child = stateContext.getDynamicComponents().get(struct.getClientId());
            }
            if (child != null) {
                if (struct.getFacetName() != null) {
                    parent.getFacets().remove(struct.getFacetName());
                    parent.getFacets().put(struct.getFacetName(), child);
                    child.getClientId();
                } else {
                    int childIndex = -1;
                    if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    child.setId(struct.getId());
                    if (childIndex >= parent.getChildCount() || childIndex == -1) {
                        parent.getChildren().add(child);
                    } else {
                        parent.getChildren().add(childIndex, child);
                    }
                    child.getClientId();
                    child.getAttributes().put("com.sun.faces.DynamicComponent", child.getParent().getChildren().indexOf(child));
                }
                stateContext.getDynamicComponents().put(struct.getClientId(), child);
            }
        }
    }

    private void reapplyDynamicRemove(FacesContext context, ComponentStruct struct) {
        UIComponent child = this.locateComponentByClientId(context, context.getViewRoot(), struct.getClientId(), true);
        if (child != null) {
            StateContext stateContext = StateContext.getStateContext(context);
            stateContext.getDynamicComponents().put(struct.getClientId(), child);
            UIComponent parent = child.getParent();
            if (struct.getFacetName() != null) {
                parent.getFacets().remove(struct.getFacetName());
            } else {
                parent.getChildren().remove(child);
            }
        }
    }

    private boolean isServerStateSaving() {
        return "server".equals(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod));
    }

    private HttpSession getSession(FacesContext context) {
        Object sessionObj = context.getExternalContext().getSession(true);
        if (sessionObj instanceof HttpSession) {
            return (HttpSession)sessionObj;
        }
        return null;
    }

    private DefaultFaceletFactory getFaceletFactory() {
        if (this.faceletFactory == null) {
            this.faceletFactory = this.associate.getFaceletFactory();
            assert (this.faceletFactory != null);
        }
        return this.faceletFactory;
    }

    private boolean isMatchedWithFaceletsSuffix(String viewId) {
        String[] defaultsuffixes;
        for (String suffix : defaultsuffixes = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsSuffix, " ")) {
            if (!viewId.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private String getMatchedWithFaceletsSuffix(String viewId) {
        String[] defaultsuffixes;
        for (String suffix : defaultsuffixes = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsSuffix, " ")) {
            if (!viewId.endsWith(suffix)) continue;
            return suffix;
        }
        return null;
    }

    private Stream<String> mapIfNeeded(Stream<String> views, ViewVisitOption ... options) {
        if (!this.returnAsImplicitOutCome(options)) {
            return views;
        }
        return views.map(view -> this.toImplicitOutcome((String)view));
    }

    private boolean returnAsImplicitOutCome(ViewVisitOption ... options) {
        return Arrays.stream(options).filter(option -> option == ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME).findAny().isPresent();
    }

    private String toImplicitOutcome(String viewId) {
        String suffix = this.getConfiguredSuffix(viewId);
        if (suffix != null) {
            return viewId.substring(0, viewId.lastIndexOf(suffix));
        }
        String prefix = this.getConfiguredPrefix(viewId);
        if (prefix != null) {
            return viewId.substring(prefix.length());
        }
        return viewId;
    }

    private String getConfiguredSuffix(String viewId) {
        if (viewId != null) {
            if (viewId.endsWith("-flow.xml")) {
                return "-flow.xml";
            }
            if (this.extensionsArray == null && this.prefixesArray == null) {
                String suffix = this.getMatchedWithFaceletsSuffix(viewId);
                if (suffix != null) {
                    return suffix;
                }
                if (viewId.endsWith(".xhtml")) {
                    return ".xhtml";
                }
            }
            if (this.extensionsArray != null) {
                for (String extension : this.extensionsArray) {
                    if (!viewId.endsWith(extension)) continue;
                    return extension;
                }
            }
        }
        return null;
    }

    private String getConfiguredPrefix(String viewId) {
        if (this.prefixesArray != null) {
            for (String prefix : this.prefixesArray) {
                if (!viewId.startsWith(prefix)) continue;
                return prefix;
            }
        }
        return null;
    }

    private void markInitialStateIfNotMarked(UIComponent component) {
        if (!component.isTransient()) {
            if (!component.getAttributes().containsKey("com.sun.faces.DynamicComponent") && !component.initialStateMarked()) {
                component.markInitialState();
            }
            Iterator<UIComponent> it = component.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent child = it.next();
                this.markInitialStateIfNotMarked(child);
            }
        }
    }

    protected static final class NullWriter
    extends Writer {
        static final NullWriter INSTANCE = new NullWriter();

        protected NullWriter() {
        }

        @Override
        public void write(char[] buffer) {
        }

        @Override
        public void write(char[] buffer, int off, int len) {
        }

        @Override
        public void write(String str) {
        }

        @Override
        public void write(int c) {
        }

        @Override
        public void write(String str, int off, int len) {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    private static interface MethodRetargetHandler {
        public void retarget(FacesContext var1, CompCompInterfaceMethodMetadata var2, Object var3, UIComponent var4);

        public String getAttribute();
    }

    private static final class MethodRetargetHandlerManager {
        private Map<String, MethodRetargetHandler> handlerMap = new HashMap<String, MethodRetargetHandler>(4, 1.0f);
        private MethodRetargetHandler arbitraryHandler = new ArbitraryMethodRegargetHandler();

        MethodRetargetHandlerManager() {
            MethodRetargetHandler[] handlers;
            for (MethodRetargetHandler h : handlers = new MethodRetargetHandler[]{new ActionRegargetHandler(), new ActionListenerRegargetHandler(), new ValidatorRegargetHandler(), new ValueChangeListenerRegargetHandler()}) {
                this.handlerMap.put(h.getAttribute(), h);
            }
        }

        private MethodRetargetHandler getRetargetHandler(String attrName) {
            return this.handlerMap.get(attrName);
        }

        private MethodRetargetHandler getDefaultHandler() {
            return this.arbitraryHandler;
        }

        private static final class ArbitraryMethodRegargetHandler
        extends AbstractRetargetHandler {
            private ArbitraryMethodRegargetHandler() {
            }

            @Override
            public void retarget(FacesContext ctx, CompCompInterfaceMethodMetadata metadata, Object sourceValue, UIComponent target) {
                int j;
                Class expectedReturnType;
                String strValue;
                ValueExpression ve = (ValueExpression)sourceValue;
                ExpressionFactory f = ctx.getApplication().getExpressionFactory();
                String methodSignature = metadata.getMethodSignature(ctx);
                assert (null != methodSignature);
                methodSignature = methodSignature.trim();
                Class[] expectedParameters = NO_ARGS;
                int i = methodSignature.indexOf(" ");
                if (-1 != i) {
                    strValue = methodSignature.substring(0, i);
                    try {
                        expectedReturnType = Util.getTypeFromString(strValue.trim());
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new FacesException(methodSignature + " : Unable to load type '" + strValue + "'");
                    }
                } else {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to determine expected return type for " + methodSignature);
                    }
                    return;
                }
                i = methodSignature.indexOf("(");
                if (-1 != i && -1 != (j = methodSignature.indexOf(")", i + 1))) {
                    strValue = methodSignature.substring(i + 1, j);
                    if (0 < strValue.length()) {
                        String[] params = strValue.split(",");
                        expectedParameters = new Class[params.length];
                        boolean exceptionThrown = false;
                        for (i = 0; i < params.length; ++i) {
                            try {
                                expectedParameters[i] = Util.getTypeFromString(params[i].trim());
                                continue;
                            }
                            catch (ClassNotFoundException cnfe) {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.log(Level.SEVERE, "Unable to determine parameter type for " + methodSignature, cnfe);
                                }
                                exceptionThrown = true;
                                break;
                            }
                        }
                        if (exceptionThrown) {
                            return;
                        }
                    } else {
                        expectedParameters = NO_ARGS;
                    }
                }
                assert (null != expectedReturnType);
                assert (null != expectedParameters);
                ELContext elContext = (ELContext)ctx.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
                if (null == elContext) {
                    elContext = ctx.getELContext();
                }
                MethodExpression me = f.createMethodExpression(elContext, ve.getExpressionString(), expectedReturnType, expectedParameters);
                target.getAttributes().put(metadata.getName(), (Object)new ContextualCompositeMethodExpression(ve, me));
            }

            @Override
            public String getAttribute() {
                return null;
            }
        }

        private static final class ValueChangeListenerRegargetHandler
        extends AbstractRetargetHandler {
            private static final String VALUE_CHANGE_LISTENER = "valueChangeListener";
            private static final Class<?>[] VALUE_CHANGE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};

            private ValueChangeListenerRegargetHandler() {
            }

            @Override
            public void retarget(FacesContext ctx, CompCompInterfaceMethodMetadata metadata, Object sourceValue, UIComponent target) {
                ValueExpression ve = (ValueExpression)sourceValue;
                ExpressionFactory f = ctx.getApplication().getExpressionFactory();
                MethodExpression me = f.createMethodExpression(ctx.getELContext(), ve.getExpressionString(), Void.TYPE, (Class[])VALUE_CHANGE_LISTENER_ARGS);
                MethodExpression noArg = f.createMethodExpression(ctx.getELContext(), ve.getExpressionString(), Void.TYPE, NO_ARGS);
                ((EditableValueHolder)((Object)target)).addValueChangeListener(new MethodExpressionValueChangeListener(new ContextualCompositeMethodExpression(ve, me), new ContextualCompositeMethodExpression(ve, noArg)));
            }

            @Override
            public String getAttribute() {
                return VALUE_CHANGE_LISTENER;
            }
        }

        private static final class ValidatorRegargetHandler
        extends AbstractRetargetHandler {
            private static final String VALIDATOR = "validator";
            private static final Class<?>[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};

            private ValidatorRegargetHandler() {
            }

            @Override
            public void retarget(FacesContext ctx, CompCompInterfaceMethodMetadata metadata, Object sourceValue, UIComponent target) {
                ValueExpression ve = (ValueExpression)sourceValue;
                ExpressionFactory f = ctx.getApplication().getExpressionFactory();
                MethodExpression me = f.createMethodExpression(ctx.getELContext(), ve.getExpressionString(), Void.TYPE, (Class[])VALIDATOR_ARGS);
                ((EditableValueHolder)((Object)target)).addValidator(new MethodExpressionValidator(new ContextualCompositeMethodExpression(ve, me)));
            }

            @Override
            public String getAttribute() {
                return VALIDATOR;
            }
        }

        private static final class ActionListenerRegargetHandler
        extends AbstractRetargetHandler {
            private static final String ACTION_LISTENER = "actionListener";
            private static final Class<?>[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};

            private ActionListenerRegargetHandler() {
            }

            @Override
            public void retarget(FacesContext ctx, CompCompInterfaceMethodMetadata metadata, Object sourceValue, UIComponent target) {
                ValueExpression ve = (ValueExpression)sourceValue;
                ExpressionFactory f = ctx.getApplication().getExpressionFactory();
                MethodExpression me = f.createMethodExpression(ctx.getELContext(), ve.getExpressionString(), Void.TYPE, (Class[])ACTION_LISTENER_ARGS);
                MethodExpression noArg = f.createMethodExpression(ctx.getELContext(), ve.getExpressionString(), Void.TYPE, NO_ARGS);
                ((ActionSource2)((Object)target)).addActionListener(new MethodExpressionActionListener(new ContextualCompositeMethodExpression(ve, me), new ContextualCompositeMethodExpression(ve, noArg)));
            }

            @Override
            public String getAttribute() {
                return ACTION_LISTENER;
            }
        }

        private static final class ActionRegargetHandler
        extends AbstractRetargetHandler {
            private static final String ACTION = "action";

            private ActionRegargetHandler() {
            }

            @Override
            public void retarget(FacesContext ctx, CompCompInterfaceMethodMetadata metadata, Object sourceValue, UIComponent target) {
                String expr = sourceValue instanceof ValueExpression ? ((ValueExpression)sourceValue).getExpressionString() : sourceValue.toString();
                ExpressionFactory f = ctx.getApplication().getExpressionFactory();
                MethodExpression me = f.createMethodExpression(ctx.getELContext(), expr, Object.class, NO_ARGS);
                ((ActionSource2)((Object)target)).setActionExpression(new ContextualCompositeMethodExpression(sourceValue instanceof ValueExpression ? (ValueExpression)sourceValue : null, me));
            }

            @Override
            public String getAttribute() {
                return ACTION;
            }
        }

        private static abstract class AbstractRetargetHandler
        implements MethodRetargetHandler {
            protected static final Class<?>[] NO_ARGS = new Class[0];

            private AbstractRetargetHandler() {
            }
        }
    }

    private static final class CompCompInterfaceMethodMetadata {
        private final PropertyDescriptor propertyDescriptor;

        CompCompInterfaceMethodMetadata(PropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        public String getMethodSignature(FacesContext ctx) {
            ValueExpression methodSignature = (ValueExpression)this.propertyDescriptor.getValue("method-signature");
            if (methodSignature != null) {
                return (String)methodSignature.getValue(ctx.getELContext());
            }
            return null;
        }

        public String[] getTargets(FacesContext ctx) {
            String targets;
            ValueExpression targetsExpression = (ValueExpression)this.propertyDescriptor.getValue("targets");
            if (targetsExpression != null && (targets = (String)targetsExpression.getValue(ctx.getELContext())) != null) {
                return Util.split(ctx.getExternalContext().getApplicationMap(), targets, " ");
            }
            return null;
        }

        public String getTargetAttributeName(FacesContext ctx) {
            ValueExpression ve = (ValueExpression)this.propertyDescriptor.getValue("targetAttributeName");
            return ve != null ? (String)ve.getValue(ctx.getELContext()) : null;
        }

        public boolean isRequired(FacesContext ctx) {
            ValueExpression rd = (ValueExpression)this.propertyDescriptor.getValue("required");
            return rd != null ? Boolean.valueOf(rd.getValue(ctx.getELContext()).toString()) : false;
        }

        public Object getDefault() {
            return this.propertyDescriptor.getValue("default");
        }

        public String getName() {
            return this.propertyDescriptor.getName();
        }
    }

    private static final class MethodMetadataIterator
    implements Iterable<CompCompInterfaceMethodMetadata>,
    Iterator<CompCompInterfaceMethodMetadata> {
        private final PropertyDescriptor[] descriptors;
        private FacesContext context;
        private int curIndex = -1;

        MethodMetadataIterator(FacesContext context, PropertyDescriptor[] descriptors) {
            this.context = context;
            this.descriptors = descriptors;
            if (descriptors != null && descriptors.length > 0) {
                this.curIndex = 0;
            }
        }

        @Override
        public Iterator<CompCompInterfaceMethodMetadata> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.curIndex != -1 && this.curIndex < this.descriptors.length) {
                for (int idx = this.curIndex; idx < this.descriptors.length; ++idx) {
                    PropertyDescriptor pd = this.descriptors[idx];
                    if (this.shouldSkip(pd)) {
                        continue;
                    }
                    if (idx != this.curIndex) {
                        this.curIndex = idx;
                    }
                    return this.curIndex < this.descriptors.length;
                }
            }
            return false;
        }

        @Override
        public CompCompInterfaceMethodMetadata next() {
            return new CompCompInterfaceMethodMetadata(this.descriptors[this.curIndex++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean shouldSkip(PropertyDescriptor pd) {
            String name = pd.getName();
            ValueExpression ve = (ValueExpression)pd.getValue("targetAttributeName");
            String targetAttributeName = ve != null ? (String)ve.getValue(this.context.getELContext()) : "";
            boolean isSpecialAttributeName = Util.isSpecialAttributeName(name) || Util.isSpecialAttributeName(targetAttributeName);
            boolean result = !isSpecialAttributeName && (pd.getValue("type") != null || pd.getValue("method-signature") == null);
            return result;
        }
    }
}

