/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ContextableConnection;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.MQRuntimeException;
import com.sun.messaging.jms.ra.ConnectionMetaData;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.DirectConnectionMetaData;
import com.sun.messaging.jms.ra.DirectConsumer;
import com.sun.messaging.jms.ra.DirectQueueSession;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectTopicSession;
import com.sun.messaging.jms.ra.DirectTransactionManagedSession;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.TemporaryDestination;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class DirectConnection
implements QueueConnection,
TopicConnection,
ContextableConnection {
    private DirectConnectionFactory dcf;
    private final JMSService jmsservice;
    private final long connectionId;
    private final boolean inACC;
    private String clientID;
    private ExceptionListener exceptionListener;
    private ConnectionMetaData connectionMetaData;
    private DirectXAResource xar = null;
    private boolean sessions_allowed = true;
    private Vector<DirectSession> sessions = null;
    private Vector<TemporaryDestination> tmp_destinations = null;
    private Vector<DirectConsumer> durable_consumers = null;
    ManagedConnection mc = null;
    private boolean isManaged = false;
    private boolean isPooled = false;
    private volatile boolean isEnlisted = false;
    private boolean isClosed;
    private boolean isStopped;
    private boolean isUsed;
    private Object syncObj = new Object();
    private int temporaryDestinationId = 0;
    private static final String _className = "com.sun.messaging.jms.ra.DirectConnection";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSConnection = "jakarta.jms.Connection.mqjmsra";
    private static final String _lgrNameJMSConnectionClose = "jakarta.jms.Connection.mqjmsra.close";
    private static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final Logger _loggerJC = Logger.getLogger("jakarta.jms.Connection.mqjmsra");
    private static final Logger _loggerJCC = Logger.getLogger("jakarta.jms.Connection.mqjmsra.close");
    private static final String _lgrMIDPrefix = "MQJMSRA_DC";
    private static final String _lgrMID_INF = "MQJMSRA_DC1101: ";
    private static final String _lgrMID_WRN = "MQJMSRA_DC2001: ";
    private static final String _lgrMID_EXC = "MQJMSRA_DC4001: ";

    public DirectConnection(DirectConnectionFactory cf, JMSService jmsservice, long connectionId, boolean inACC) {
        Object[] params = new Object[]{cf, jmsservice, connectionId, inACC};
        _loggerOC.entering(_className, "constructor()", params);
        this.dcf = cf;
        this.jmsservice = jmsservice;
        this.connectionId = connectionId;
        this.inACC = inACC;
        this.clientID = null;
        this.exceptionListener = null;
        this.connectionMetaData = new DirectConnectionMetaData(cf._getConfiguration());
        this.sessions = new Vector();
        this.tmp_destinations = new Vector();
        this.durable_consumers = new Vector();
        this.isClosed = false;
        this.isStopped = true;
        this.isUsed = false;
    }

    public void close() throws JMSException {
        boolean willDestroy = false;
        this.close(willDestroy);
    }

    public void closeAndDestroy() throws JMSException {
        boolean willDestroy = true;
        this.close(willDestroy);
        this._destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean willDestroy) throws JMSException {
        _loggerJCC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":close(" + willDestroy + "):");
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":close(" + willDestroy + "):");
        DirectConnection directConnection = this;
        synchronized (directConnection) {
            if (this.isClosed) {
                return;
            }
            this._stop();
            this._closeAndClearSessions();
            if (this.mc == null || !this.mc.xaTransactionActive()) {
                this._deleteTemporaryDestinations();
            }
            this.isClosed = true;
            if (willDestroy) {
                return;
            }
            if (this.isManaged) {
                this.mc.sendEvent(1, null, this);
                return;
            }
        }
        this._destroy();
    }

    public ConnectionConsumer createConnectionConsumer(jakarta.jms.Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createConnectionConsumer():Destination=" + String.valueOf(destination) + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createSharedConnectionConsumer():Topic=" + String.valueOf(topic) + ":subscriptionName=" + subscriptionName + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createSharedConnectionConsumer():");
        return null;
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createSharedDurableConnectionConsumer():Topic=" + String.valueOf(topic) + ":subscriptionName=" + subscriptionName + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createSharedDurableConnectionConsumer():");
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createDurableConnectionConsumer():Topic=" + String.valueOf(topic) + ":SubscriptionName=" + subscriptionName + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createDurableConnectionConsumer():");
        return null;
    }

    public Session createSession(boolean isTransacted, int acknowledgeMode) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createSession():isTransacted=" + isTransacted + ":acknowledgeMode=" + acknowledgeMode);
        this._checkIfClosed("createSession():");
        this.checkSessionsAllowed("createSession():");
        this.setUsed();
        boolean actualTransactedArg = this.overrideTransacted(isTransacted);
        int actualAcknowledgeModeArg = this.overrideAcknowledgeMode(acknowledgeMode);
        long sessionId = this._createSessionId(this.connectionId, actualTransactedArg, actualAcknowledgeModeArg);
        JMSService.SessionAckMode ackMode = DirectConnection._getSessionAckModeFromSessionParams(actualTransactedArg, actualAcknowledgeModeArg);
        DirectSession ds = this.isManaged() ? new DirectTransactionManagedSession(this, this.jmsservice, sessionId, ackMode) : new DirectSession(this, this.jmsservice, sessionId, ackMode);
        this.addSession(ds);
        return ds;
    }

    public Session createSession(int sessionMode) throws JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, sessionMode);
        }
        return this.createSession(false, sessionMode);
    }

    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public Session createSessionForRAEndpoint() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createSessionForRAEndpoint():");
        this._checkIfClosed("createSession():");
        this.setUsed();
        boolean actualTransactedArg = false;
        int actualAcknowledgeModeArg = 2;
        long sessionId = this._createSessionId(this.connectionId, actualTransactedArg, actualAcknowledgeModeArg);
        JMSService.SessionAckMode ackMode = DirectConnection._getSessionAckModeFromSessionParams(actualTransactedArg, actualAcknowledgeModeArg);
        DirectSession ds = new DirectSession(this, this.jmsservice, sessionId, ackMode);
        this.addSession(ds);
        return ds;
    }

    private boolean overrideTransacted(boolean suppliedTransactedArgument) {
        boolean actualTransactedArg = this.inACC ? suppliedTransactedArgument : false;
        return actualTransactedArg;
    }

    private int overrideAcknowledgeMode(int suppliedAcknowledgeModeArgument) {
        int actualAcknowledgeModeArg = this.inACC ? suppliedAcknowledgeModeArgument : (suppliedAcknowledgeModeArgument == 2 ? 1 : suppliedAcknowledgeModeArgument);
        return actualAcknowledgeModeArg;
    }

    public String getClientID() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":getClientID():");
        this._checkIfClosed("getClientID():");
        this.setUsed();
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":getExceptionListener():");
        this._checkIfClosed("getExceptionListener():");
        this.setUsed();
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":getMetaData():");
        this._checkIfClosed("getMetaData():");
        this.setUsed();
        return this.connectionMetaData;
    }

    public void setClientID(String clientID) throws JMSException {
        String methodName = "setClientID()";
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + methodName);
        if (!this.inACC) {
            this._unsupported(methodName);
        }
        this._checkIfClosed(methodName);
        this._setClientID(clientID);
    }

    @Override
    public void _setClientIDForContext(String clientID) {
        String methodName = "_setClientIDForContext()";
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + methodName);
        try {
            if (!this.inACC) {
                this._unsupported(methodName);
            }
            this._checkIfClosed(methodName);
            this._setClientID(clientID);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        String methodName = "setExceptionListener()";
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + methodName);
        if (!this.inACC) {
            this._unsupported(methodName);
        }
        this._checkIfClosed(methodName);
    }

    public synchronized void start() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":start():");
        this._checkIfClosed("start():");
        if (!this.isStopped()) {
            return;
        }
        this.setUsed();
        try {
            this.jmsservice.startConnection(this.connectionId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":start():JMSService.startConnection():JMSServiceException=" + jmsse.getMessage());
        }
        this.isStopped = false;
        this._startSessions();
    }

    public synchronized void stop() throws JMSException {
        String methodName = "stop()";
        _loggerJC.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId);
        if (!this.inACC) {
            this._unsupported(methodName);
        }
        this._stop();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createConnectionConsumer():Queue=" + String.valueOf(queue) + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public QueueSession createQueueSession(boolean isTransacted, int acknowledgeMode) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createQueueSession():isTransacted=" + isTransacted + ":acknowledgeMode=" + acknowledgeMode);
        this._checkIfClosed("createQueueSession():");
        this.checkSessionsAllowed("createQueueSession():");
        this.setUsed();
        boolean actualTransactedArg = this.overrideTransacted(isTransacted);
        int actualAcknowledgeModeArg = this.overrideAcknowledgeMode(acknowledgeMode);
        long sessionId = this._createSessionId(this.connectionId, actualTransactedArg, actualAcknowledgeModeArg);
        JMSService.SessionAckMode ackMode = DirectConnection._getSessionAckModeFromSessionParams(actualTransactedArg, actualAcknowledgeModeArg);
        DirectQueueSession ds = new DirectQueueSession(this, this.jmsservice, sessionId, ackMode);
        this.addSession(ds);
        return ds;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createConnectionConsumer():Topic=" + String.valueOf(topic) + ":MessageSelector=" + messageSelector + ":ServerSessionPool=" + String.valueOf(sessionPool) + ":MaxMessages=" + maxMessages);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public TopicSession createTopicSession(boolean isTransacted, int acknowledgeMode) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":createTopicSession():isTransacted=" + isTransacted + ":acknowledgeMode=" + acknowledgeMode);
        this._checkIfClosed("createTopicSession():");
        this.checkSessionsAllowed("createTopicSession():");
        this.setUsed();
        boolean actualTransactedArg = this.overrideTransacted(isTransacted);
        int actualAcknowledgeModeArg = this.overrideAcknowledgeMode(acknowledgeMode);
        long sessionId = this._createSessionId(this.connectionId, actualTransactedArg, actualAcknowledgeModeArg);
        JMSService.SessionAckMode ackMode = DirectConnection._getSessionAckModeFromSessionParams(actualTransactedArg, actualAcknowledgeModeArg);
        DirectTopicSession ds = new DirectTopicSession(this, this.jmsservice, sessionId, ackMode);
        this.addSession(ds);
        return ds;
    }

    public String _getClientID() {
        return this.clientID;
    }

    public void _setClientID(String clientID) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":_setClientID():clientID=" + clientID);
        if (this.clientID != null) {
            String error = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_setclientID():Error to overwrite existing clientID:" + this.clientID + "with new clientID=" + clientID;
            _loggerJC.warning(error);
            throw new JMSException(error);
        }
        if (clientID == null || "".equals(clientID)) {
            String error = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_setclientID():Error to set a null or empty clientID:" + clientID;
            _loggerJC.warning(error);
            throw new JMSException(error);
        }
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":_setClientID():jmsservice.clientId():params=" + clientID + ":" + this.dcf.isRAClustered() + ":" + this.dcf.getRANamespace());
            this.jmsservice.setClientId(this.connectionId, clientID, this.dcf.isRAClustered(), this.dcf.getRANamespace());
            this.clientID = clientID;
        }
        catch (JMSServiceException jmsse) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_setClientID():JMSService.setClientId():JMSServiceException=" + jmsse.getMessage());
        }
    }

    public void _unsetClientID() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":_unsetClientID():");
        if (this.clientID == null) {
            return;
        }
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":_unsetClientID():jmsservice.unclientId():");
            this.jmsservice.unsetClientId(this.connectionId);
            this.clientID = null;
        }
        catch (JMSServiceException jmsse) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_unsetClientID():JMSService.unsetClientId():JMSServiceException=" + jmsse.getMessage());
        }
    }

    public void _setExceptionListener(ExceptionListener listener) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":_setExceptionListener()");
        this.exceptionListener = listener;
    }

    public synchronized DirectXAResource _getXAResource() {
        if (this.xar == null) {
            this.xar = new DirectXAResource(this, this.jmsservice, this.connectionId);
        }
        return this.xar;
    }

    protected JMSService _getJMSService() {
        return this.jmsservice;
    }

    protected synchronized void _activate(String clientId) throws JMSException {
        if (this.isManaged) {
            if (clientId != null && !"".equals(clientId)) {
                this._setClientID(clientId);
            }
            this.isPooled = false;
            this.isClosed = false;
        }
    }

    protected synchronized void _cleanup() throws JMSException {
        if (this.isManaged) {
            this.isPooled = true;
            this.isUsed = false;
            this._unsetClientID();
        }
    }

    protected synchronized void _destroy() throws JMSException {
        if (!this.isClosed) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_destroy():called on a connection that was not closed.");
        }
        if (this.isManaged) {
            this.isPooled = false;
        }
        try {
            this.jmsservice.destroyConnection(this.connectionId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":_close():JMSService.destroyConnection():JMSServiceException=" + jmsse.getMessage());
        }
    }

    protected void _stop() throws JMSException {
        this._checkIfClosed("stop():");
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this._stopSessions();
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":stop():jmsservice.stopConnection():connectionId=" + this.connectionId);
            this.jmsservice.stopConnection(this.connectionId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":stop():JMSService.stopConnection():JMSServiceException=" + jmsse.getMessage());
        }
    }

    private long _createSessionId(long connectionId, boolean isTransacted, int acknowledgeMode) throws JMSException {
        long sessionId = 0L;
        JMSService.SessionAckMode ackMode = DirectConnection._getSessionAckModeFromSessionParams(isTransacted, acknowledgeMode);
        try {
            JMSServiceReply reply = this.jmsservice.createSession(connectionId, ackMode);
            try {
                sessionId = reply.getJMQSessionID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DC4001: JMSServiceException:Missing JMQSessionID";
                JMSException jmse = new JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJC.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String exerrmsg = "createSession on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + connectionId + " due to " + (switch (status) {
                case JMSServiceReply.Status.BAD_REQUEST -> "invalid acknowledgment mode.";
                case JMSServiceReply.Status.NOT_ALLOWED -> "acknowledgmentmode is not allowed.";
                default -> "unkown JMSService server error.";
            });
            _loggerJC.severe(exerrmsg);
            JMSException jmsse = new JMSException(exerrmsg);
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
        return sessionId;
    }

    private void _checkIfClosed(String methodname) throws JMSException {
        if (this.isClosed()) {
            String closedmsg = _lgrMID_EXC + methodname + "Connection is closed:Id=" + this.connectionId;
            _loggerJC.warning(closedmsg);
            throw new IllegalStateException(closedmsg);
        }
    }

    private void checkSessionsAllowed(String methodName) throws JMSException {
        if (!this.sessions_allowed) {
            String disallowed = _lgrMID_EXC + methodName + "An active Session object already exists for this connection, only one active Session object allowed per connection.";
            _loggerJC.warning(disallowed);
            throw new JMSException(disallowed);
        }
    }

    private void _unsupported(String methodname) throws JMSException {
        String unsupported = "MQJMSRA_DC2001: Unsupported:" + methodname + ":inACC=" + this.inACC + ":connectionId=" + this.connectionId;
        _loggerJC.warning(unsupported);
        throw new JMSException(unsupported);
    }

    private synchronized void setUsed() {
        this.isUsed = true;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public synchronized boolean isPooled() {
        return this.isPooled;
    }

    public boolean isEnlisted() {
        return this.isEnlisted;
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public void setManaged(boolean value, ManagedConnection mc) {
        this.isManaged = value;
        this.mc = mc;
    }

    public void setEnlisted(boolean value) {
        this.isEnlisted = value;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isStopped() {
        return this.isStopped;
    }

    public synchronized boolean isStarted() {
        return !this.isStopped;
    }

    public synchronized boolean isUsed() {
        return this.isUsed;
    }

    protected static JMSService.SessionAckMode _getSessionAckModeFromSessionParams(boolean isTransacted, int acknowledgeMode) {
        JMSService.SessionAckMode ackMode = JMSService.SessionAckMode.UNSPECIFIED;
        ackMode = isTransacted ? JMSService.SessionAckMode.TRANSACTED : (acknowledgeMode == 1 ? JMSService.SessionAckMode.AUTO_ACKNOWLEDGE : (acknowledgeMode == 3 ? JMSService.SessionAckMode.DUPS_OK_ACKNOWLEDGE : (acknowledgeMode == 2 ? JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE : (acknowledgeMode == 32768 ? JMSService.SessionAckMode.NO_ACKNOWLEDGE : JMSService.SessionAckMode.AUTO_ACKNOWLEDGE))));
        return ackMode;
    }

    protected void addSession(DirectSession session) {
        this.sessions.add(session);
        if (!this.inACC) {
            this.sessions_allowed = false;
        }
    }

    protected void removeSession(DirectSession session) {
        boolean result = this.sessions.remove(session);
        assert (result);
        if (!this.sessions_allowed && this.sessions.isEmpty()) {
            this.sessions_allowed = true;
        }
    }

    protected void addDurableConsumer(DirectConsumer consumer) {
        this.durable_consumers.add(consumer);
    }

    protected void removeDurableConsumer(DirectConsumer consumer) {
        this.durable_consumers.remove(consumer);
    }

    protected Vector<DirectConsumer> _getDurableConsumers() {
        return this.durable_consumers;
    }

    protected void _createDestination(Destination destination) throws JMSException {
        try {
            this.jmsservice.createDestination(this.connectionId, destination);
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            Object failure_cause = null;
            String exerrmsg = "createDestination on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and Destination:" + String.valueOf((Object)destination.getType()) + ":" + destination.getName() + ":due to ";
            Throwable jmse = null;
            switch (status) {
                case FORBIDDEN: {
                    failure_cause = "client unauthorized for create.";
                    exerrmsg = exerrmsg + (String)failure_cause;
                    jmse = new JMSSecurityException(exerrmsg, jse.getJMSServiceReply().getErrorCode());
                    break;
                }
                case ERROR: {
                    failure_cause = "unkown JMSService server error.";
                    break;
                }
                default: {
                    failure_cause = "status =" + String.valueOf(status);
                }
            }
            if (jmse == null) {
                jmse = new JMSException(exerrmsg + (String)failure_cause);
            }
            jmse.initCause((Throwable)jse);
            if (status != JMSServiceReply.Status.CONFLICT) {
                _loggerJC.severe(exerrmsg);
                throw jmse;
            }
            _loggerJC.fine(exerrmsg);
        }
    }

    protected void _deleteDestination(TemporaryDestination t_destination, Destination destination) throws JMSException {
        JMSException jmse = null;
        String failure_cause = null;
        try {
            this.jmsservice.destroyDestination(this.connectionId, destination);
        }
        catch (JMSServiceException jmsse) {
            JMSServiceReply.Status status = jmsse.getJMSServiceReply().getStatus();
            switch (status) {
                case FORBIDDEN: {
                    failure_cause = "client unauthorized for delete.";
                    break;
                }
                case NOT_FOUND: {
                    failure_cause = "destination does not exist.";
                    break;
                }
                case CONFLICT: {
                    failure_cause = "destination has producers or consumers.";
                    break;
                }
                default: {
                    failure_cause = "unkown JMSService server error.";
                }
            }
            String exerrmsg = "destroyDestination on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and Destination:" + String.valueOf((Object)destination.getType()) + ":" + destination.getName() + ":due to " + failure_cause;
            jmse = new JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            _loggerJC.warning(exerrmsg);
        }
        if (jmse != null) {
            throw jmse;
        }
    }

    protected long _startTransaction(String fromMethod) throws JMSException {
        JMSServiceReply reply = null;
        long _transactionId = 0L;
        try {
            reply = this.jmsservice.startTransaction(this.connectionId, 0L, null, 0, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                _transactionId = reply.getJMQTransactionID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DC4001: :_startTransaction from " + fromMethod + ":JMSServiceException:Missing JMQTransactionID";
                JMSException jmse = new JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJC.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jmsse) {
            String exerrmsg = "MQJMSRA_DC4001: :_startTransaction from " + fromMethod + "JMSServiceException=" + jmsse.getMessage();
            JMSException jmse = new JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            _loggerJC.severe(exerrmsg);
            throw jmse;
        }
        return _transactionId;
    }

    protected void _commitTransaction(String methodName, long transactionId) throws JMSException {
        try {
            this.jmsservice.commitTransaction(this.connectionId, transactionId, null, 0);
        }
        catch (JMSServiceException jmsse) {
            String exerrmsg = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + methodName + ":JMSServiceException=" + jmsse.getMessage();
            JMSException jmse = new JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            _loggerJC.severe(exerrmsg);
            throw jmse;
        }
    }

    protected void _rollbackTransaction(String methodName, long transactionId) throws JMSException {
        try {
            this.jmsservice.rollbackTransaction(this.connectionId, transactionId, null, true, true);
        }
        catch (JMSServiceException jmsse) {
            String exerrmsg = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + methodName + ":JMSServiceException=" + jmsse.getMessage();
            JMSException jmse = new JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            _loggerJC.severe(exerrmsg);
            throw jmse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextTemporaryDestinationId() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.temporaryDestinationId;
            return this.temporaryDestinationId;
        }
    }

    protected String _getConnectionIdentifierForTemporaryDestination() {
        StringBuilder sb;
        try {
            sb = new StringBuilder(InetAddress.getLocalHost().getHostAddress());
        }
        catch (Exception ex) {
            sb = new StringBuilder("127.0.0.1");
        }
        if (this.clientID != null) {
            sb.append(":" + this.clientID);
        }
        sb.append("/" + this.connectionId);
        return sb.toString();
    }

    protected void addTemporaryDestination(TemporaryDestination t_destination) {
        this.tmp_destinations.add(t_destination);
    }

    protected void removeTemporaryDestination(TemporaryDestination t_destination) {
        boolean result = this.tmp_destinations.remove(t_destination);
        assert (result);
    }

    protected boolean _hasTemporaryDestination(TemporaryDestination t_destination) {
        return this.tmp_destinations.contains(t_destination);
    }

    protected boolean _hasConsumers(TemporaryDestination t_destination) {
        return t_destination._getConsumerCount() > 0;
    }

    private void _startSessions() {
        DirectSession ds2 = null;
        for (DirectSession ds2 : this.sessions) {
            ds2._start();
        }
    }

    private void _stopSessions() {
        DirectSession ds2 = null;
        for (DirectSession ds2 : this.sessions) {
            ds2._stop();
        }
    }

    private void _closeAndClearSessions() {
        DirectSession ds = null;
        Iterator<DirectSession> k = this.sessions.iterator();
        while (k.hasNext()) {
            ds = k.next();
            try {
                ds._close();
                k.remove();
            }
            catch (JMSException jmsedsc) {
                _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":close_session:sessionId:" + ds.getSessionId() + ":JMSException=" + jmsedsc.getMessage());
            }
        }
        this.sessions.clear();
        this.sessions_allowed = true;
    }

    protected void _deleteTemporaryDestinations() throws JMSException {
        TemporaryDestination td = null;
        Iterator<TemporaryDestination> k = this.tmp_destinations.iterator();
        while (k.hasNext()) {
            td = k.next();
            try {
                td._delete();
                k.remove();
            }
            catch (JMSException jmsetdd) {
                _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":delete_temporary_destination=" + td.getName() + ":JMSException=" + jmsetdd.getMessage());
            }
        }
        this.tmp_destinations.clear();
    }

    protected void _incrementTemporaryDestinationUsage(TemporaryDestination destination) throws JMSException {
        destination._incrementConsumerCount();
    }

    protected void _decrementTemporaryDestinationUsage(TemporaryDestination destination) throws JMSException {
        destination._decrementConsumerCount();
    }

    public void deleteTemporaryDestinationsIfClosed() throws JMSException {
        if (this.isClosed) {
            this._deleteTemporaryDestinations();
        }
    }
}

