/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.types.EntityManagerFactoryReference;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.persistence.EntityManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.security.common.Role;

public abstract class BundleDescriptor
extends RootDeploymentDescriptor
implements Roles {
    private static final long serialVersionUID = 1L;
    private static final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BundleDescriptor.class);
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "META-INF";
    private static final String WSDL_DIR = "wsdl";
    private static final double ANNOTATION_RAR_VER = 1.6;
    private static final double ANNOTATION_EJB_VER = 3.0;
    private static final double ANNOTATION_WAR_VER = 2.5;
    private static final double ANNOTATION_CAR_VER = 5.0;
    private boolean fullFlag;
    private boolean fullAttribute;
    private Application application;
    private Set<Role> roles;
    private Set<MessageDestinationDescriptor> messageDestinations = new HashSet<MessageDestinationDescriptor>();
    private final WebServicesDescriptor webServices = new WebServicesDescriptor();
    private final Set<ManagedBeanDescriptor> managedBeans = new HashSet<ManagedBeanDescriptor>();
    private final Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private final Hashtable<InjectionInfoCacheKey, InjectionInfo> injectionInfos = new Hashtable();
    private boolean policyModified;
    private String compatValue;
    private boolean keepState;
    private final HashMap<String, RootXMLNode<?>> rootNodes = new HashMap();

    public BundleDescriptor() {
        this.webServices.setBundleDescriptor(this);
    }

    public BundleDescriptor(String name, String description) {
        super(name, description);
        this.webServices.setBundleDescriptor(this);
    }

    public final void setApplication(Application application) {
        this.application = application;
        for (List extensionsByType : this.extensions.values()) {
            for (RootDeploymentDescriptor extension : extensionsByType) {
                if (!(extension instanceof BundleDescriptor)) continue;
                ((BundleDescriptor)extension).setApplication(application);
            }
        }
    }

    public void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        for (MessageDestinationDescriptor mdDesc : bundleDescriptor.getMessageDestinations()) {
            this.addMessageDestination(mdDesc);
        }
    }

    public boolean isPackagedAsSingleModule(BundleDescriptor other) {
        return this.getModuleDescriptor().equals(other.getModuleDescriptor());
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isStandalone() {
        return this.application.isVirtual();
    }

    public final Application getApplication() {
        return this.application;
    }

    public void addRootNode(String ddPath, RootXMLNode<?> rootNode) {
        this.rootNodes.put(ddPath, rootNode);
    }

    public RootXMLNode<?> getRootNode(String ddPath) {
        return this.rootNodes.get(ddPath);
    }

    public void addEntityManagerFactory(String unitName, EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactories.put(unitName, entityManagerFactory);
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.entityManagerFactories.get(unitName);
    }

    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    public void addManagedBean(ManagedBeanDescriptor desc) {
        if (!this.hasManagedBeanByBeanClass(desc.getBeanClassName())) {
            if (desc.isNamed()) {
                for (ManagedBeanDescriptor managedBeanDescriptor : this.managedBeans) {
                    if (!managedBeanDescriptor.isNamed() || !desc.getName().equals(managedBeanDescriptor.getName())) continue;
                    throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.exceptionduplicatemanagedbeandefinition", "ManagedBean [{0}] cannot have same name [{1}] already used by another ManagedBean [{2}]", new Object[]{desc.getBeanClassName(), managedBeanDescriptor.getName(), managedBeanDescriptor.getBeanClassName()}));
                }
            }
            this.managedBeans.add(desc);
            desc.setBundle(this);
        }
    }

    public boolean hasManagedBeanByBeanClass(String beanClassName) {
        ManagedBeanDescriptor descriptor = this.getManagedBeanByBeanClass(beanClassName);
        return descriptor != null;
    }

    public ManagedBeanDescriptor getManagedBeanByBeanClass(String beanClassName) {
        for (ManagedBeanDescriptor next : this.managedBeans) {
            if (!beanClassName.equals(next.getBeanClassName())) continue;
            return next;
        }
        return null;
    }

    public Set<ManagedBeanDescriptor> getManagedBeans() {
        return new HashSet<ManagedBeanDescriptor>(this.managedBeans);
    }

    public WebServicesDescriptor getWebServices() {
        return this.webServices;
    }

    public WebServiceEndpoint getWebServiceEndpointByName(String name) {
        return this.webServices.getEndpointByName(name);
    }

    public boolean hasWebServiceClients() {
        return false;
    }

    public boolean hasWebServices() {
        return this.getWebServices().hasWebServices();
    }

    public Set<MessageDestinationDescriptor> getMessageDestinations() {
        if (this.messageDestinations == null) {
            this.messageDestinations = new HashSet<MessageDestinationDescriptor>();
        }
        return this.messageDestinations;
    }

    public boolean hasMessageDestinationByName(String name) {
        for (MessageDestinationDescriptor mtd : this.getMessageDestinations()) {
            if (!mtd.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationDescriptor getMessageDestinationByName(String name) {
        for (MessageDestinationDescriptor mtd : this.getMessageDestinations()) {
            if (!mtd.getName().equals(name)) continue;
            return mtd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmessagedestbundle", "Referencing error: this bundle has no message destination of name: {0}", new Object[]{name}));
    }

    public void addMessageDestination(MessageDestinationDescriptor messageDestination) {
        messageDestination.setBundleDescriptor(this);
        this.getMessageDestinations().add(messageDestination);
    }

    public void removeMessageDestination(MessageDestinationDescriptor messageDestinationDescriptor) {
        messageDestinationDescriptor.setBundleDescriptor(null);
        this.getMessageDestinations().remove(messageDestinationDescriptor);
    }

    @Override
    public Set<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet<Role>();
        }
        if (this.application != null) {
            this.roles.addAll(this.application.getAppRoles());
        }
        return this.roles;
    }

    @Override
    public void addRole(Role role) {
        this.getRoles().add(role);
    }

    public void addRole(SecurityRoleDescriptor descriptor) {
        this.addRole(new Role(descriptor.getName(), descriptor.getDescription()));
    }

    @Override
    public void removeRole(Role role) {
        this.getRoles().remove(role);
    }

    protected Collection<NamedDescriptor> getNamedDescriptorsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedDescriptor> namedDescriptors = new Vector<NamedDescriptor>();
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : nameEnvironment.getResourceReferenceDescriptors()) {
            namedDescriptors.add(resourceReferenceDescriptor);
        }
        for (EjbReferenceDescriptor ejbReferenceDescriptor : nameEnvironment.getEjbReferenceDescriptors()) {
            namedDescriptors.add(ejbReferenceDescriptor);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : nameEnvironment.getResourceEnvReferenceDescriptors()) {
            namedDescriptors.add(resourceEnvReferenceDescriptor);
        }
        return namedDescriptors;
    }

    protected Vector<NamedReferencePair> getNamedReferencePairsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : nameEnvironment.getResourceReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceRefPair((Descriptor)nameEnvironment, resourceReferenceDescriptor));
        }
        for (EjbReferenceDescriptor ejbReferenceDescriptor : nameEnvironment.getEjbReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createEjbRefPair((Descriptor)nameEnvironment, ejbReferenceDescriptor));
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : nameEnvironment.getResourceEnvReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceEnvRefPair((Descriptor)nameEnvironment, resourceEnvReferenceDescriptor));
        }
        return pairs;
    }

    public InjectionInfo getInjectionInfoByClass(Class<?> clazz, JndiNameEnvironment jndiNameEnv) {
        InjectionInfoCacheKey key = null;
        if (jndiNameEnv instanceof EjbDescriptor) {
            EjbDescriptor jndiEjbDesc = (EjbDescriptor)jndiNameEnv;
            key = new InjectionInfoCacheKey(jndiEjbDesc.getName(), clazz);
        } else {
            key = new InjectionInfoCacheKey(clazz.getName(), clazz);
        }
        InjectionInfo injectionInfo = this.injectionInfos.get(key);
        if (injectionInfo != null) {
            return injectionInfo;
        }
        String className = clazz.getName();
        LifecycleCallbackDescriptor postConstructDesc = this.getPostConstructDescriptorByClass(className, jndiNameEnv);
        String postConstructMethodName = postConstructDesc == null ? null : postConstructDesc.getLifecycleCallbackMethod();
        LifecycleCallbackDescriptor preDestroyDesc = this.getPreDestroyDescriptorByClass(className, jndiNameEnv);
        String preDestroyMethodName = preDestroyDesc == null ? null : preDestroyDesc.getLifecycleCallbackMethod();
        List<InjectionCapable> resourcesByClass = this.getInjectableResourcesByClass(className, jndiNameEnv);
        injectionInfo = new InjectionInfo(className, postConstructMethodName, preDestroyMethodName, resourcesByClass);
        this.injectionInfos.put(key, injectionInfo);
        return injectionInfo;
    }

    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public List<InjectionCapable> getInjectableResources(JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        this.addJndiNameEnvironmentInjectables(jndiNameEnv, injectables);
        return injectables;
    }

    private void addJndiNameEnvironmentInjectables(JndiNameEnvironment jndiNameEnv, List<InjectionCapable> injectables) {
        HashSet<EnvironmentProperty> allEnvProps = new HashSet<EnvironmentProperty>();
        for (EnvironmentProperty environmentProperty : jndiNameEnv.getEnvironmentProperties()) {
            if (!environmentProperty.hasContent() && !(jndiNameEnv instanceof EjbBundleDescriptor)) continue;
            allEnvProps.add(environmentProperty);
        }
        allEnvProps.addAll(jndiNameEnv.getEjbReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getServiceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getResourceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getResourceEnvReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getMessageDestinationReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerFactoryReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerReferenceDescriptors());
        for (InjectionCapable injectionCapable : allEnvProps) {
            if (!injectionCapable.isInjectable()) continue;
            injectables.add(injectionCapable);
        }
    }

    public List<InjectionCapable> getInjectableResourcesByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        for (InjectionCapable next : this.getInjectableResources(jndiNameEnv)) {
            if (!next.isInjectable()) continue;
            for (InjectionTarget target : next.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectables.add(next);
            }
        }
        return injectables;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.application != null) {
            return this.application.getClassLoader();
        }
        return this.classLoader;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n Roles[] = ").append(this.roles);
        if (this.getWebServices().hasWebServices()) {
            toStringBuffer.append("\n WebServices ");
            this.getWebServices().print(toStringBuffer);
        }
    }

    public abstract ArchiveType getModuleType();

    public ComponentVisitor getBundleVisitor() {
        return new ApplicationValidator();
    }

    public void visit(ComponentVisitor aVisitor) {
        aVisitor.accept(this);
    }

    public String getModuleID() {
        if (super.getModuleID() == null) {
            this.setModuleID(this.getModuleDescriptor().getArchiveUri());
        }
        if (this.getModuleDescriptor().isStandalone()) {
            return super.getModuleID();
        }
        if (this.application != null && !this.application.isVirtual()) {
            return this.application.getRegistrationName() + PERSISTENCE_UNIT_NAME_SEPARATOR + this.getModuleDescriptor().getArchiveUri();
        }
        return super.getModuleID();
    }

    public String getRawModuleID() {
        return super.getModuleID();
    }

    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    public String getWsdlDir() {
        return this.getDeploymentDescriptorDir() + "/wsdl";
    }

    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        return Collections.emptyList();
    }

    protected static Collection<? extends PersistenceUnitDescriptor> findReferencedPUsViaPURefs(JndiNameEnvironment component) {
        HashSet<PersistenceUnitDescriptor> persistenceUnitDescriptors = new HashSet<PersistenceUnitDescriptor>();
        for (EntityManagerFactoryReferenceDescriptor entityManagerFactoryReference : component.getEntityManagerFactoryReferenceDescriptors()) {
            persistenceUnitDescriptors.add(BundleDescriptor.findReferencedPUViaEMFRef(entityManagerFactoryReference));
        }
        return persistenceUnitDescriptors;
    }

    protected static PersistenceUnitDescriptor findReferencedPUViaEMFRef(EntityManagerFactoryReference entityManagerFactoryReference) {
        BundleDescriptor bundle = entityManagerFactoryReference.getReferringBundleDescriptor();
        PersistenceUnitDescriptor persistenceUnitDescriptor = bundle.findReferencedPU(entityManagerFactoryReference.getUnitName());
        if (persistenceUnitDescriptor == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-unresolved-pu-ref", "xxx", new Object[]{entityManagerFactoryReference.getName(), bundle.getName()}));
        }
        return persistenceUnitDescriptor;
    }

    protected static Collection<? extends PersistenceUnitDescriptor> findReferencedPUsViaPCRefs(JndiNameEnvironment component) {
        HashSet<PersistenceUnitDescriptor> persistenceUnitDescriptors = new HashSet<PersistenceUnitDescriptor>();
        for (EntityManagerReferenceDescriptor entityManagerReference : component.getEntityManagerReferenceDescriptors()) {
            persistenceUnitDescriptors.add(BundleDescriptor.findReferencedPUViaEMRef(entityManagerReference));
        }
        return persistenceUnitDescriptors;
    }

    protected static PersistenceUnitDescriptor findReferencedPUViaEMRef(EntityManagerReference entityManagerReference) {
        BundleDescriptor bundle = entityManagerReference.getReferringBundleDescriptor();
        PersistenceUnitDescriptor persistenceUnitDescriptor = bundle.findReferencedPU(entityManagerReference.getUnitName());
        if (persistenceUnitDescriptor == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-unresolved-pc-ref", "xxx", new Object[]{entityManagerReference.getName(), bundle.getName()}));
        }
        if ("RESOURCE_LOCAL".equals(persistenceUnitDescriptor.getTransactionType())) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exception-non-jta-container-managed-em", "xxx", new Object[]{entityManagerReference.getName(), bundle.getName(), persistenceUnitDescriptor.getName()}));
        }
        return persistenceUnitDescriptor;
    }

    public PersistenceUnitDescriptor findReferencedPU(String unitName) {
        if (Utility.isEmpty((String)unitName)) {
            return this.findDefaultPU();
        }
        return this.findReferencedPU0(unitName);
    }

    public PersistenceUnitDescriptor findDefaultPU() {
        PersistenceUnitDescriptor persistenceUnitDescriptor = null;
        int totalNumberOfPUInBundle = 0;
        for (PersistenceUnitsDescriptor nextPUs : this.getModuleDescriptor().getDescriptor().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            Iterator<PersistenceUnitDescriptor> iterator = nextPUs.getPersistenceUnitDescriptors().iterator();
            while (iterator.hasNext()) {
                PersistenceUnitDescriptor nextPersistenceUnitDescriptor;
                persistenceUnitDescriptor = nextPersistenceUnitDescriptor = iterator.next();
                ++totalNumberOfPUInBundle;
            }
        }
        if (totalNumberOfPUInBundle == 1) {
            return persistenceUnitDescriptor;
        }
        if (totalNumberOfPUInBundle == 0) {
            int totalNumberOfPUInEar = 0;
            for (PersistenceUnitsDescriptor nextPUs : this.getApplication().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                Iterator<PersistenceUnitDescriptor> iterator = nextPUs.getPersistenceUnitDescriptors().iterator();
                while (iterator.hasNext()) {
                    PersistenceUnitDescriptor nextPersistenceUnitDescriptor;
                    persistenceUnitDescriptor = nextPersistenceUnitDescriptor = iterator.next();
                    ++totalNumberOfPUInEar;
                }
            }
            if (totalNumberOfPUInEar == 1) {
                return persistenceUnitDescriptor;
            }
        }
        return null;
    }

    private PersistenceUnitDescriptor findReferencedPU0(String unitName) {
        int separatorIndex = unitName.lastIndexOf(PERSISTENCE_UNIT_NAME_SEPARATOR);
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String puRoot = this.getTargetUri(this, path);
            PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)this.getApplication().getExtensionsDescriptors(PersistenceUnitsDescriptor.class, puRoot);
            if (persistenceUnitsDescriptor != null) {
                for (PersistenceUnitDescriptor persistenceUnitDescriptor : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                    if (!persistenceUnitDescriptor.getName().equals(unqualifiedUnitName)) continue;
                    return persistenceUnitDescriptor;
                }
            }
        } else {
            Map<String, PersistenceUnitDescriptor> visiblePUs = this.getVisiblePUs();
            PersistenceUnitDescriptor result = visiblePUs.get(unitName);
            if (result != null) {
                return result;
            }
            int sameNamedEarScopedPUCount = 0;
            Set<Map.Entry<String, PersistenceUnitDescriptor>> entrySet = visiblePUs.entrySet();
            for (Map.Entry<String, PersistenceUnitDescriptor> entry : entrySet) {
                String s = entry.getKey();
                int idx = s.lastIndexOf(PERSISTENCE_UNIT_NAME_SEPARATOR);
                if (idx == -1 || !s.substring(idx + 1).matches(unitName)) continue;
                result = entry.getValue();
                ++sameNamedEarScopedPUCount;
            }
            if (sameNamedEarScopedPUCount == 1) {
                return result;
            }
        }
        return null;
    }

    public Map<String, PersistenceUnitDescriptor> getVisiblePUs() {
        HashMap<String, PersistenceUnitDescriptor> visiblePersistenceUnits = new HashMap<String, PersistenceUnitDescriptor>();
        for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : this.getModuleDescriptor().getDescriptor().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            for (PersistenceUnitDescriptor persistenceUnitDescriptor : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                visiblePersistenceUnits.put(persistenceUnitDescriptor.getName(), persistenceUnitDescriptor);
            }
        }
        Application application = this.getApplication();
        if (application != null) {
            for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : application.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                for (PersistenceUnitDescriptor persistenceUnitDescriptor : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                    visiblePersistenceUnits.put(persistenceUnitDescriptor.getPuRoot() + PERSISTENCE_UNIT_NAME_SEPARATOR + persistenceUnitDescriptor.getName(), persistenceUnitDescriptor);
                }
            }
        }
        return visiblePersistenceUnits;
    }

    private String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            return new URI(archiveUri).resolve(relativeTargetUri).getPath();
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public String getModuleName() {
        if (this.getApplication().isVirtual()) {
            return this.getApplication().getRegistrationName();
        }
        return this.getModuleDescriptor().getArchiveUri();
    }

    public String getUniqueFriendlyId() {
        return FileUtils.makeFriendlyFilename((String)this.getModuleName());
    }

    public boolean isPolicyModified() {
        return this.policyModified;
    }

    public void setPolicyModified(boolean policyModified) {
        this.policyModified = policyModified;
    }

    public String getCompatibility() {
        return this.compatValue;
    }

    public void setCompatibility(String compatValue) {
        this.compatValue = compatValue;
    }

    public boolean getKeepState() {
        return this.keepState;
    }

    public void setKeepState(String keepStateVal) {
        this.keepState = Boolean.parseBoolean(keepStateVal);
    }

    public void setFullFlag(boolean flag) {
        this.fullFlag = flag;
    }

    public void setFullAttribute(String value) {
        this.fullAttribute = Boolean.parseBoolean(value);
    }

    public boolean isFullAttribute() {
        return this.fullAttribute;
    }

    public boolean isFullFlag() {
        if (this.fullFlag) {
            return true;
        }
        return this.isDDWithNoAnnotationAllowed();
    }

    public boolean isDDWithNoAnnotationAllowed() {
        ArchiveType moduleType = this.getModuleType();
        if (moduleType == null) {
            return false;
        }
        double specVersion = Double.parseDouble(this.getSpecVersion());
        return moduleType.equals((Object)DOLUtils.ejbType()) && specVersion < 3.0 || moduleType.equals((Object)DOLUtils.warType()) && specVersion < 2.5 || moduleType.equals((Object)DOLUtils.carType()) && specVersion < 5.0 || moduleType.equals((Object)DOLUtils.rarType()) && specVersion < 1.6;
    }

    private static final class InjectionInfoCacheKey {
        String beanName;
        Class<?> clazz;
        int hc;

        InjectionInfoCacheKey(String beanName, Class<?> clazz) {
            this.beanName = beanName;
            this.clazz = clazz;
            this.hc = beanName.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof InjectionInfoCacheKey) {
                InjectionInfoCacheKey other = (InjectionInfoCacheKey)o;
                if (this.hc == other.hc) {
                    return this.clazz == other.clazz && this.beanName.equals(other.beanName);
                }
            }
            return result;
        }
    }
}

