/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.config;

import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Ref;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.glassfish.loadbalancer.config.customvalidators.RefConstraint;
import org.glassfish.loadbalancer.config.customvalidators.RefValidator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@RefConstraint(message="{ref.invalid}", payload={RefValidator.class})
public interface LbConfig
extends ConfigBeanProxy,
PropertyBag,
Payload {
    public static final String LAST_APPLIED_PROPERTY = "last-applied";
    public static final String LAST_EXPORTED_PROPERTY = "last-exported";

    @Attribute(key=true)
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\./;#]*", message="{lbconfig.invalid.name}", payload={LbConfig.class})
    @NotNull
    public @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\./;#]*", message="{lbconfig.invalid.name}", payload={LbConfig.class}) @NotNull String getName();

    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="60")
    @Min(value=0L)
    public @Min(value=0L) String getResponseTimeoutInSeconds();

    @Param(name="responsetimeout", optional=true)
    public void setResponseTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getHttpsRouting();

    @Param(name="httpsrouting", optional=true)
    public void setHttpsRouting(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="60")
    public String getReloadPollIntervalInSeconds();

    @Param(name="reloadinterval", optional=true)
    public void setReloadPollIntervalInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getMonitoringEnabled();

    @Param(name="monitor", optional=true)
    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getRouteCookieEnabled();

    @Param(name="routecookie", optional=true)
    public void setRouteCookieEnabled(String var1) throws PropertyVetoException;

    @Element(value="*")
    public List<Ref> getClusterRefOrServerRef();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    default public <T> List<T> getRefs(Class<T> type) {
        ArrayList<T> refs = new ArrayList<T>();
        for (Ref ref : this.getClusterRefOrServerRef()) {
            if (!type.isInstance(ref)) continue;
            refs.add(type.cast(ref));
        }
        return Collections.unmodifiableList(refs);
    }

    default public <T> T getRefByRef(Class<T> type, String refName) {
        if (refName == null) {
            return null;
        }
        for (Ref ref : this.getClusterRefOrServerRef()) {
            if (!type.isInstance(ref) || !ref.getRef().equals(refName)) continue;
            return type.cast(ref);
        }
        return null;
    }

    default public Date getLastExported() {
        return this.getInternalPropertyValue(LAST_EXPORTED_PROPERTY);
    }

    default public Date getLastApplied() {
        return this.getInternalPropertyValue(LAST_APPLIED_PROPERTY);
    }

    default public boolean setLastExported() {
        return this.setInternalProperty(LAST_EXPORTED_PROPERTY);
    }

    default public boolean setLastApplied() {
        return this.setInternalProperty(LAST_APPLIED_PROPERTY);
    }

    private Date getInternalPropertyValue(String propertyName) {
        String propertyValue = this.getPropertyValue(propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new Date(Long.parseLong(propertyValue));
    }

    private boolean setInternalProperty(String propertyName) {
        Property property = this.getProperty(propertyName);
        Transaction transaction = new Transaction();
        try {
            if (property == null) {
                LbConfig lcProxy = (LbConfig)transaction.enroll((ConfigBeanProxy)this);
                property = (Property)lcProxy.createChild(Property.class);
                property.setName(propertyName);
                property.setValue(String.valueOf(new Date().getTime()));
                lcProxy.getProperty().add(property);
            } else {
                Property propertyProxy = (Property)transaction.enroll((ConfigBeanProxy)property);
                propertyProxy.setValue(String.valueOf(new Date().getTime()));
            }
            transaction.commit();
        }
        catch (Exception ex) {
            transaction.rollback();
            Logger logger = LogDomains.getLogger(LbConfig.class, (String)"jakarta.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
            String msg = localStrings.getLocalString("UnableToSetPropertyInLbconfig", "Unable to set property {0} in lbconfig with name {1}", new Object[]{propertyName, this.getName()});
            logger.log(Level.SEVERE, msg);
            logger.log(Level.FINE, "Exception when trying to set property " + propertyName + " in lbconfig " + this.getName(), ex);
            return false;
        }
        return true;
    }

    @Service
    @PerLookup
    public static class DeleteDecorator
    implements DeletionDecorator<LbConfigs, LbConfig> {
        @Inject
        private Domain domain;

        public void decorate(AdminCommandContext context, LbConfigs parent, LbConfig child) throws TransactionFailure {
            Logger logger = LogDomains.getLogger(LbConfig.class, (String)"jakarta.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
            String lbConfigName = child.getName();
            LbConfig lbConfig = ((LbConfigs)this.domain.getExtensionByType(LbConfigs.class)).getLbConfig(lbConfigName);
            if (lbConfig.getClusterRefOrServerRef().size() != 0) {
                String msg = localStrings.getLocalString("LbConfigNotEmpty", lbConfigName);
                throw new TransactionFailure(msg);
            }
            logger.info(localStrings.getLocalString("http_lb_admin.LbConfigDeleted", lbConfigName));
        }
    }

    @Service
    @PerLookup
    public static class Decorator
    implements CreationDecorator<LbConfig> {
        @Param(name="name", optional=true)
        String config_name;
        @Param(optional=true)
        String target;
        @Param(optional=true, defaultValue="60")
        String responsetimeout;
        @Param(optional=true, defaultValue="false")
        Boolean httpsrouting;
        @Param(optional=true, defaultValue="60")
        String reloadinterval;
        @Param(optional=true, defaultValue="false")
        Boolean monitor;
        @Param(optional=true, defaultValue="true")
        Boolean routecookie;
        @Param(optional=true, name="property", separator=58)
        Properties properties;
        @Inject
        Domain domain;

        public void decorate(AdminCommandContext context, LbConfig instance) throws TransactionFailure, PropertyVetoException {
            String msg;
            LbConfigs lbconfigs;
            Logger logger = LogDomains.getLogger(LbConfig.class, (String)"jakarta.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
            if (this.config_name == null && this.target == null) {
                String msg2 = localStrings.getLocalString("RequiredTargetOrConfig", "Neither LB config name nor target specified");
                throw new TransactionFailure(msg2);
            }
            if (this.config_name == null) {
                this.config_name = this.target + "_LB_CONFIG";
            }
            if ((lbconfigs = (LbConfigs)this.domain.getExtensionByType(LbConfigs.class)) == null) {
                Transaction transaction = new Transaction();
                try {
                    Domain domainProxy = (Domain)transaction.enroll((ConfigBeanProxy)this.domain);
                    lbconfigs = (LbConfigs)domainProxy.createChild(LbConfigs.class);
                    domainProxy.getExtensions().add(lbconfigs);
                    transaction.commit();
                }
                catch (RetryableException | TransactionFailure ex) {
                    transaction.rollback();
                    String msg3 = localStrings.getLocalString("LbConfigsCreationFailed", "Creation of parent element lb-configs failed");
                    throw new TransactionFailure(msg3, ex);
                }
            }
            if (lbconfigs.getLbConfig(this.config_name) != null) {
                msg = localStrings.getLocalString("LbConfigExists", this.config_name);
                throw new TransactionFailure(msg);
            }
            instance.setName(this.config_name);
            instance.setResponseTimeoutInSeconds(this.responsetimeout);
            instance.setReloadPollIntervalInSeconds(this.reloadinterval);
            instance.setMonitoringEnabled(this.monitor == null ? null : this.monitor.toString());
            instance.setRouteCookieEnabled(this.routecookie == null ? null : this.routecookie.toString());
            instance.setHttpsRouting(this.httpsrouting == null ? null : this.httpsrouting.toString());
            if (this.target != null) {
                if (this.domain.getClusterNamed(this.target) != null) {
                    ClusterRef cRef = (ClusterRef)instance.createChild(ClusterRef.class);
                    cRef.setRef(this.target);
                    instance.getClusterRefOrServerRef().add((Ref)cRef);
                } else if (this.domain.isServer(this.target)) {
                    ServerRef sRef = (ServerRef)instance.createChild(ServerRef.class);
                    sRef.setRef(this.target);
                    instance.getClusterRefOrServerRef().add((Ref)sRef);
                } else {
                    msg = localStrings.getLocalString("InvalidTarget", this.target);
                    throw new TransactionFailure(msg);
                }
            }
            if (this.properties != null) {
                for (Object propname : this.properties.keySet()) {
                    Property newprop = (Property)instance.createChild(Property.class);
                    newprop.setName((String)propname);
                    newprop.setValue(this.properties.getProperty((String)propname));
                    instance.getProperty().add(newprop);
                }
            }
            logger.info(localStrings.getLocalString("http_lb_admin.LbConfigCreated", "Load balancer configuration {0} created.", new Object[]{this.config_name}));
        }
    }
}

