/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfoListIterator;
import java.nio.ByteBuffer;
import java.util.EmptyStackException;
import org.glassfish.pfl.basic.reflection.Bridge;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;

public class BufferManagerWriteStream
extends BufferManagerWrite {
    private int fragmentCount = 0;

    BufferManagerWriteStream(ORB orb) {
        super(orb);
    }

    @Override
    public boolean sentFragment() {
        return this.fragmentCount > 0;
    }

    @Override
    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    @Override
    protected ByteBuffer overflow(ByteBuffer byteBuffer, int numBytesNeeded) {
        MessageBase.setFlag(byteBuffer, 2);
        try {
            this.sendFragment(false);
        }
        catch (SystemException se) {
            ContactInfoListIterator itr;
            try {
                itr = this.getContactInfoListIterator();
            }
            catch (EmptyStackException ese) {
                throw se;
            }
            this.orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
            boolean retry = itr.reportException(null, (RuntimeException)((Object)se));
            if (retry) {
                Bridge bridge = Bridge.get();
                bridge.throwException((Throwable)new RemarshalException());
            }
            throw se;
        }
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        FragmentMessage header = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        header.write((OutputStream)((CDROutputObject)this.outputObject));
        return byteBuffer;
    }

    @Override
    public boolean isFragmentOnOverflow() {
        return true;
    }

    private void sendFragment(boolean isLastFragment) {
        Connection conn = ((CDROutputObject)this.outputObject).getMessageMediator().getConnection();
        conn.writeLock();
        try {
            conn.sendWithoutLock((CDROutputObject)this.outputObject);
            ++this.fragmentCount;
        }
        finally {
            conn.writeUnlock();
        }
    }

    @Override
    public void sendMessage() {
        this.sendFragment(true);
        this.sentFullMessage = true;
    }

    @Override
    public void close() {
    }

    protected ContactInfoListIterator getContactInfoListIterator() {
        return (ContactInfoListIterator)this.orb.getInvocationInfo().getContactInfoListIterator();
    }
}

